<?php
session_start();

$path = __DIR__;
$folderName = '';
if (preg_match('/whitelabels\/([^\/]+)/', $path, $matches)) {
    $folderName = $matches[1];
}


require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';

include_once('../../funcoes/users.php');

require '../../class/walletClass.php';
require '../../class/chamadosClass.php';
require '../../class/statusClass.php';
require '../../class/topicoClass.php';
require '../../class/validaAssinatura.php';

// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);
?>


<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter">

<head>
    <?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->

                
                
                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="container mt-5">
                            <div class="card shadow-sm border-0 rounded-3">
                                <?php
                                    $getStatus = new getStatus($pdo);
                                    $statusList = $getStatus->getStatus(['admin_chamados', 'all']);
                                    $usuarioId = $_SESSION['usuario']['id_usuario'];
                                    $getTopico = new getTopico($pdo);
                                    $topicoList = $getTopico->getTopico('all');
                                ?>

                                <div class="card-header btext-white d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">Central de Chamados</h5>
                                    <button class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#modalNovoChamado">
                                        <i class="bx bx-plus"></i> Novo Chamado
                                    </button>
                                </div>

                                <div class="card-body mt-3">
                                    <div class="row mb-3">
                                        <div class="col-md-4">
                                            <select class="form-select" id="filtro-status">
                                                <option value="">Status: Todos</option>
                                                <?php if (!empty($statusList) && is_array($statusList)): ?>
                                                    <?php foreach ($statusList as $status): ?>
                                                        <option value="<?= htmlspecialchars($status['nome']); ?>">
                                                            <?= htmlspecialchars($status['nome']); ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php else: ?>
                                                    <option value="">---</option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <select class="form-select" id="filtro-prioridade">
                                                <option value="">Prioridade: Todas</option>
                                                <option>Baixa</option>
                                                <option>Média</option>
                                                <option>Alta</option>
                                                <option>Urgente</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="row" id="chamados-container">
                                        <?php
                                        // Buscar chamados do usuário logado usando a API
                                        $tokenApi = Config::get('api_configs.token');
                                        $baseUrl = Config::get('api_configs.base_url');

                                        $url = $baseUrl . 'query/custom';
                                        
                                        // SQL com JOINs para buscar os chamados
                                        $sql = "SELECT 
                                                    c.id,
                                                    c.titulo,
                                                    c.status,
                                                    c.prioridade,
                                                    c.categoria,
                                                    c.data_criacao,
                                                    c.data_atualizacao,
                                                    c.user_id,
                                                    c.user_email,
                                                    c.whitelabel,
                                                    c.fornecedor,
                                                    cd.mensagem AS ultima_mensagem,
                                                    cd.data_envio AS ultima_interacao
                                                FROM drophub_global.chamados c
                                                LEFT JOIN (
                                                    SELECT cd1.*
                                                    FROM drophub_global.chamados_dados cd1
                                                    INNER JOIN (
                                                        SELECT chamado_id, MAX(data_envio) AS max_data
                                                        FROM drophub_global.chamados_dados
                                                        GROUP BY chamado_id
                                                    ) cd2 ON cd1.chamado_id = cd2.chamado_id 
                                                         AND cd1.data_envio = cd2.max_data
                                                ) cd ON c.id = cd.chamado_id
                                                WHERE c.user_id = :user_id
                                                ORDER BY c.data_atualizacao DESC, c.id DESC
                                                LIMIT 100";
                                        
                                        // Payload para a API
                                        $payload = [
                                            'sql' => $sql,
                                            'params' => [
                                                'user_id' => $usuarioId
                                            ]
                                        ];

                                        // Fazer chamada à API
                                        $ch = curl_init($url);
                                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                                        curl_setopt($ch, CURLOPT_POST, true);
                                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                                            'Content-Type: application/json',
                                            'Authorization: Bearer ' . $tokenApi
                                        ]);
                                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

                                        $response = curl_exec($ch);
                                        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                                        curl_close($ch);

                                        // Processar resposta
                                        $chamados = [];
                                        if ($httpCode === 200) {
                                            $data = json_decode($response, true);
                                            if (isset($data['success']) && $data['success'] && isset($data['data']['data'])) {
                                                $chamados = $data['data']['data'];
                                            }
                                        }
                                        ?>

                                        <?php if (!empty($chamados)): ?>
                                            <?php foreach ($chamados as $chamado): ?>
                                                <?php
                                                // Define a cor do badge de status
                                                $statusClass = 'bg-secondary'; // cor padrão
                                                $status = strtolower(trim($chamado['status']));
                                                switch ($status) {
                                                    case 'novo':
                                                        $statusClass = 'bg-primary';
                                                        break;
                                                    case 'fechado':
                                                        $statusClass = 'bg-danger';
                                                        break;
                                                    case 'resolvido':
                                                        $statusClass = 'bg-success';
                                                        break;
                                                }

                                                // Define a cor do badge de prioridade
                                                $prioridadeClass = 'bg-secondary'; // cor padrão
                                                $prioridade = strtolower(trim($chamado['prioridade']));
                                                switch ($prioridade) {
                                                    case 'baixa':
                                                        $prioridadeClass = 'bg-info';
                                                        break;
                                                    case 'média':
                                                    case 'media':
                                                        $prioridadeClass = 'bg-warning';
                                                        break;
                                                    case 'alta':
                                                        $prioridadeClass = 'bg-danger';
                                                        break;
                                                    case 'urgente':
                                                        $prioridadeClass = 'bg-danger';
                                                        break;
                                                }
                                                ?>
                                                <div class="col-md-6 col-lg-4 mb-3">
                                                    <div class="card h-100 shadow-sm border rounded-3">
                                                        <div class="card-body d-flex flex-column">
                                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                                <h6 class="card-title mb-0 text-muted">ID: CLD_<?= htmlspecialchars($chamado['id']) ?></h6>
                                                                <div class="dropdown">
                                                                    <button class="btn btn-sm border-0 p-1" type="button" data-bs-toggle="dropdown" style="background: transparent;">
                                                                        <i class="bx bx-dots-vertical-rounded" ></i>
                                                                    </button>
                                                                    <ul class="dropdown-menu">
                                                                        <li><a class="dropdown-item" href="visualizar_chamado?id=<?= htmlspecialchars($chamado['id']) ?>">
                                                                            <i class="bx bx-show me-2"></i>Visualizar
                                                                        </a></li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                            
                                                            <h5 class="card-title"><?= htmlspecialchars($chamado['titulo']) ?></h5>
                                                            
                                                            <div class="d-flex gap-2 mb-3">
                                                                <span class="badge <?= $statusClass ?>"><?= htmlspecialchars($chamado['status']) ?></span>
                                                                <span class="badge <?= $prioridadeClass ?>"><?= htmlspecialchars($chamado['prioridade']) ?></span>
                                                            </div>

                                                            <div class="mt-auto">
                                                                <div class="d-flex justify-content-between align-items-center">
                                                                    <small class="text-muted"><?= date('d/m/Y', strtotime($chamado['data_criacao'])) ?></small>
                                                                    <button class="btn btn-outline-primary btn-sm" onclick="window.location.href='visualizar_chamado?id=<?= htmlspecialchars($chamado['id']) ?>'">
                                                                        <i class="bx bx-edit-alt me-1"></i>Ver / Responder
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <div class="col-12">
                                                <div class="text-center py-5">
                                                    <i class="bx bx-folder-open display-4 text-muted mb-3"></i>
                                                    <h5 class="text-muted">Nenhum chamado encontrado</h5>
                                                    <p class="text-muted">Você ainda não possui chamados. Crie seu primeiro chamado clicando no botão acima.</p>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Novo Chamado -->
                        <div class="modal fade" id="modalNovoChamado" tabindex="-1" aria-labelledby="modalNovoChamadoLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                <form class="modal-content" method="POST" action="salvar_chamado.php" enctype="multipart/form-data">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Novo Chamado</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="d-none">

                                                <div class="mb-3">
                                                    <label class="form-label">Id usuario</label>
                                                    <input type="text" name="user_id" readonly class="form-control" value="<?= $_SESSION['usuario']['id_usuario'] ?>" required>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label">email usuario</label>
                                                    <input type="text" name="user_email" readonly class="form-control" value="<?= $_SESSION['usuario']['email'] ?>" required>
                                                </div>

                                                <div class="mb-3">
                                                    <label class="form-label">whitelabel</label>
                                                    <input type="text" name="whitelabel" readonly class="form-control" value="<?php echo strtolower($folderName); ?>" required>
                                                </div>

                                            </div>

                                            <div class="mb-3 col-4">
                                                <label for="select" class="form-label">Fornecedor:</label>
                                                <?php
                                                // Buscar fornecedores ativos usando a função global
                                                $fornecedores = getFornecedoresAtivos($pdo, [
                                                    'apenas_ativos' => true,
                                                    'order_by' => 'nome ASC'
                                                ]);
                                                ?>

                                                <select class="form-select" name="fornecedor">
                                                    <?php if (!empty($fornecedores)): ?>
                                                        <?php foreach ($fornecedores as $fornecedor): ?>
                                                            <option value="<?= htmlspecialchars($fornecedor['id']) ?>">
                                                                <?= htmlspecialchars($fornecedor['nome']) ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <option value="">Nenhum fornecedor encontrado</option>
                                                    <?php endif; ?>
                                                </select>

                                            </div>

                                            <div class="mb-3 col-4">
                                                <label class="form-label">Categoria</label>
                                                <select name="categoria" class="form-select" required>
                                                    <?php if (!empty($topicoList) && is_array($topicoList)): ?>
                                                        <?php foreach ($topicoList as $topico): ?>
                                                            <option value="<?= htmlspecialchars($topico['nome']); ?>">
                                                                <?= htmlspecialchars($topico['nome']); ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <option value="">Nenhum topico encontrado</option>
                                                    <?php endif; ?>
                                                </select>
                                            </div>

                                            <div class="mb-3 col-4">
                                                <label class="form-label">Prioridade</label>
                                                <select name="prioridade" class="form-select" required>
                                                    <option>Baixa</option>
                                                    <option>Média</option>
                                                    <option>Alta</option>
                                                    <option>Urgente</option>
                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Título do Chamado</label>
                                                <input type="text" name="titulo" class="form-control" required>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Descrição</label>
                                                <textarea name="descricao" class="form-control" rows="5" required></textarea>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Anexos (imagens)</label>
                                                <input type="file" name="anexos[]" class="form-control" accept="image/*" multiple onchange="previewImages(this)">
                                                <div id="preview-anexos" class="mt-2 d-flex flex-wrap"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary">Enviar Chamado</button>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>


    <!-- / Layout wrapper -->
    <script>
        function minhafuncao() {
            Swal.fire({


                icon: 'success',
                title: 'voce clicou com sucesso',
                showConfirmButton: true,

            })
        }
    </script>

    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        $(document).ready(function() {
            $('#vendas').DataTable({
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese.json"
                },
                "paging": false,
                "responsive": true,
                "searching": false
            });
        });

        function limitarTexto(texto, limite) {
            return texto.length > limite ? texto.substring(0, limite) + '...' : texto;
        }

        function previewImages(input) {
            const preview = document.getElementById('preview-anexos');
            preview.innerHTML = '';
            if (input.files) {
                Array.from(input.files).forEach((file, idx) => {
                    if (file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = e => {
                            const wrapper = document.createElement('div');
                            wrapper.style.position = 'relative';
                            wrapper.style.display = 'inline-block';
                            wrapper.style.margin = '5px';
                            const img = document.createElement('img');
                            img.src = e.target.result;
                            img.style.maxWidth = '120px';
                            img.style.maxHeight = '120px';
                            img.style.border = '1px solid #ccc';
                            img.style.borderRadius = '6px';
                            // Botão X para remover
                            const btn = document.createElement('button');
                            btn.type = 'button';
                            btn.innerHTML = '&times;';
                            btn.style.position = 'absolute';
                            btn.style.top = '0';
                            btn.style.right = '0';
                            btn.style.background = 'rgba(0,0,0,0.6)';
                            btn.style.color = '#fff';
                            btn.style.border = 'none';
                            btn.style.borderRadius = '0 6px 0 6px';
                            btn.style.cursor = 'pointer';
                            btn.style.width = '24px';
                            btn.style.height = '24px';
                            btn.onclick = function() {
                                removeFileFromInput(input, idx);
                            };
                            wrapper.appendChild(img);
                            wrapper.appendChild(btn);
                            preview.appendChild(wrapper);
                        };
                        reader.readAsDataURL(file);
                    }
                });
            }
        }
        // Remove o arquivo do input (recria FileList sem o índice removido)
        function removeFileFromInput(input, removeIdx) {
            const dt = new DataTransfer();
            Array.from(input.files).forEach((file, idx) => {
                if (idx !== removeIdx) dt.items.add(file);
            });
            input.files = dt.files;
            previewImages(input);
        }

        // Filtros de status e prioridade
        var statusFiltro = '';
        var prioridadeFiltro = '';

        $(document).ready(function() {
            // Filtro de status
            $(document).on('change', '#filtro-status', function() {
                statusFiltro = $(this).val();
                atualizarTabelaChamados();
            });
            // Filtro de prioridade
            $(document).on('change', '#filtro-prioridade', function() {
                prioridadeFiltro = $(this).val();
                atualizarTabelaChamados();
            });
            // Submissão AJAX do novo chamado
            $(document).on('submit', '#modalNovoChamado form', function(e) {
                e.preventDefault();
                var form = this;
                var formData = new FormData(form);
                var btn = $(form).find('button[type=submit]');
                btn.prop('disabled', true).text('Enviando...');
                $.ajax({
                    url: '../../assets/ajax/chamados/ajax_salvar_chamado.php',
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function(resp) {
                        btn.prop('disabled', false).text('Enviar Chamado');
                        if (resp.success) {
                            $('#modalNovoChamado').modal('hide');
                            Swal.fire('Sucesso', resp.message, 'success');
                            atualizarTabelaChamados();
                            form.reset();
                            previewImages(form.querySelector('input[type=file]'));
                        } else {
                            Swal.fire('Erro', resp.message, 'error');
                        }
                    },
                    error: function() {
                        btn.prop('disabled', false).text('Enviar Chamado');
                        Swal.fire('Erro', 'Erro ao enviar chamado.', 'error');
                    }
                });
            });
            // Função para atualizar os chamados via AJAX
            function atualizarTabelaChamados() {
                $.get('../../assets/ajax/chamados/ajax_listar_chamados.php', {
                    status: statusFiltro,
                    prioridade: prioridadeFiltro
                }, function(resp) {
                    console.log('Resposta AJAX:', resp); // Debug
                    if (resp.success && resp.chamados) {
                        var html = '';
                        resp.chamados.forEach(function(chamado) {
                            // Define a cor do badge de status
                            var statusClass = 'bg-secondary';
                            var status = chamado.status.toLowerCase().trim();
                            switch (status) {
                                case 'novo':
                                    statusClass = 'bg-primary';
                                    break;
                                case 'fechado':
                                    statusClass = 'bg-danger';
                                    break;
                                case 'resolvido':
                                    statusClass = 'bg-success';
                                    break;
                            }

                            // Define a cor do badge de prioridade
                            var prioridadeClass = 'bg-secondary';
                            var prioridade = chamado.prioridade.toLowerCase().trim();
                            switch (prioridade) {
                                case 'baixa':
                                    prioridadeClass = 'bg-info';
                                    break;
                                case 'média':
                                case 'media':
                                    prioridadeClass = 'bg-warning';
                                    break;
                                case 'alta':
                                    prioridadeClass = 'bg-danger';
                                    break;
                                case 'urgente':
                                    prioridadeClass = 'bg-danger';
                                    break;
                            }

                            var dataFormatada = chamado.data_criacao ? chamado.data_criacao.split(' ')[0].split('-').reverse().join('/') : '';

                            html += '<div class="col-md-6 col-lg-4 mb-3">' +
                                '<div class="card h-100 shadow-sm border rounded-3" style="border-color: #e0e0e0 !important;">' +
                                '<div class="card-body d-flex flex-column">' +
                                '<div class="d-flex justify-content-between align-items-start mb-2">' +
                                '<h6 class="card-title mb-0 text-muted">ID: CLD_' + chamado.id + '</h6>' +
                                '<div class="dropdown">' +
                                '<button class="btn btn-sm border-0 p-1" type="button" data-bs-toggle="dropdown" style="background: transparent;">' +
                                '<i class="bx bx-dots-vertical-rounded" style="font-size: 18px; color: #6c757d;"></i>' +
                                '</button>' +
                                '<ul class="dropdown-menu">' +
                                '<li><a class="dropdown-item" href="visualizar_chamado?id=' + chamado.id + '">' +
                                '<i class="bx bx-show me-2"></i>Visualizar' +
                                '</a></li>' +
                                '</ul>' +
                                '</div>' +
                                '</div>' +
                                '<h5 class="card-title">' + chamado.titulo + '</h5>' +
                                '<div class="d-flex gap-2 mb-3">' +
                                '<span class="badge ' + statusClass + '">' + chamado.status + '</span>' +
                                '<span class="badge ' + prioridadeClass + '">' + chamado.prioridade + '</span>' +
                                '</div>' +
                                '<div class="mt-auto">' +
                                '<div class="d-flex justify-content-between align-items-center">' +
                                '<small class="text-muted">' + dataFormatada + '</small>' +
                                '<button class="btn btn-outline-primary btn-sm" onclick="window.location.href=\'visualizar_chamado?id=' + chamado.id + '\'">' +
                                '<i class="bx bx-edit-alt me-1"></i>Editar Chamado' +
                                '</button>' +
                                '</div>' +
                                '</div>' +
                                '</div>' +
                                '</div>' +
                                '</div>';
                        });
                        
                        if (!html) {
                            html = '<div class="col-12">' +
                                '<div class="text-center py-5">' +
                                '<i class="bx bx-folder-open display-4 text-muted mb-3"></i>' +
                                '<h5 class="text-muted">Nenhum chamado encontrado</h5>' +
                                '<p class="text-muted">Você ainda não possui chamados. Crie seu primeiro chamado clicando no botão acima.</p>' +
                                '</div>' +
                                '</div>';
                        }
                        
                        $("#chamados-container").html(html);
                    } else {
                        console.error('Erro na resposta:', resp); // Debug erro
                        var errorHtml = '<div class="col-12">' +
                            '<div class="alert alert-danger text-center">' +
                            '<i class="bx bx-error-circle me-2"></i>' +
                            '<strong>Erro:</strong> ' + (resp.message || 'Não foi possível carregar os chamados.') +
                            '</div>' +
                            '</div>';
                        $("#chamados-container").html(errorHtml);
                    }
                }, 'json').fail(function(xhr, status, error) {
                    console.error('Erro AJAX:', {xhr: xhr, status: status, error: error}); // Debug falha
                    var errorHtml = '<div class="col-12">' +
                        '<div class="alert alert-danger text-center">' +
                        '<i class="bx bx-error-circle me-2"></i>' +
                        '<strong>Erro de conexão:</strong> Não foi possível conectar ao servidor.' +
                        '</div>' +
                        '</div>';
                    $("#chamados-container").html(errorHtml);
                });
            }
            // Atualiza a tabela ao carregar a página
            atualizarTabelaChamados();
        });
    </script>

</body>

</html>