<?php
session_start();
header('Content-Type: application/json');

// Log para debug
error_log("=== AJAX LISTAR CHAMADOS ===");
error_log("SESSION usuario: " . print_r($_SESSION['usuario'] ?? 'não definido', true));

// Incluir classes e funções necessárias
require_once('../../class/configClass.php');
Config::load('../../config/config.php');
include_once('../../funcoes/general.php');

if (!isset($_SESSION['usuario']['id_usuario'])) {
    error_log("ERRO: Usuário não autenticado");
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado.']);
    exit;
}

$is_supllier = $_SESSION['usuario']['is_supplier'] ?? false;

if ($is_supllier) {
    $user_id = pegaPrefixo().$_SESSION['usuario']['id_usuario'];
} else {
    $user_id = $_SESSION['usuario']['id_usuario'];
}

error_log("is_supplier: " . ($is_supllier ? 'true' : 'false'));
error_log("user_id final: " . $user_id);

$status = isset($_GET['status']) ? trim($_GET['status']) : '';
$prioridade = isset($_GET['prioridade']) ? trim($_GET['prioridade']) : '';

$token = 'api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed';
$api_url = 'https://api-hom.codefly.site/api/v1/consulta/chamados_fornecedor.php';

$post_fields = [
    'token' => $token,
    'user_id' => $user_id,
    'is_supplier' => $is_supllier ? 1 : 0
];
if ($status !== '') {
    $post_fields['status'] = $status;
}
if ($prioridade !== '') {
    $post_fields['prioridade'] = $prioridade;
}

$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);

error_log("Enviando para API: " . $api_url);
error_log("Dados enviados: " . print_r($post_fields, true));

$response = curl_exec($ch);
$curl_error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

error_log("HTTP Code: " . $http_code);
error_log("Response: " . substr($response, 0, 500));

if ($response === false) {
    error_log("ERRO CURL: " . $curl_error);
    echo json_encode(['success' => false, 'message' => 'Erro ao conectar à API: ' . $curl_error]);
    exit;
}

$data = json_decode($response, true);
if (!is_array($data) || !isset($data['success'])) {
    error_log("ERRO: Resposta inválida da API");
    echo json_encode(['success' => false, 'message' => 'Resposta inválida da API.', 'raw_response' => substr($response, 0, 200)]);
    exit;
}

error_log("Sucesso! Retornando dados...");
echo json_encode($data);
