#!/bin/bash
################################################################################
# Script de monitoramento do Worker de Zeramento de Estoque
# 
# Monitora o worker e reinicia automaticamente se necessário.
# Pode ser executado via cron a cada minuto.
#
# Exemplo de crontab:
# * * * * * /var/www/whitelabels/stage/workers/monitor_worker_zerar_estoque.sh >> /var/www/whitelabels/stage/logs/monitor_zerar_estoque.log 2>&1
#
# @author Sistema Drophub
# @version 1.0
# @date 2025-12-16
################################################################################

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
CONTROL_SCRIPT="$SCRIPT_DIR/controlar_worker_zerar_estoque.sh"
PID_FILE="$SCRIPT_DIR/worker_zerar_estoque.pid"
LOG_FILE="$(dirname "$SCRIPT_DIR")/logs/monitor_worker_zerar_estoque.log"

# Garantir que diretório de logs existe
mkdir -p "$(dirname "$LOG_FILE")"

# Função de log
log_message() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}

# Verificar se worker está rodando
if [ -f "$PID_FILE" ]; then
    PID=$(cat "$PID_FILE")
    if ps -p "$PID" > /dev/null 2>&1; then
        # Worker está rodando
        exit 0
    else
        log_message "ALERTA: Worker não está rodando (PID morto: $PID)"
    fi
else
    log_message "ALERTA: Worker não está rodando (sem PID file)"
fi

# Worker não está rodando - tentar reiniciar
log_message "Tentando reiniciar worker..."

if bash "$CONTROL_SCRIPT" start; then
    log_message "Worker reiniciado com sucesso"
    
    # Enviar notificação se tiver configuração de email/webhook
    # TODO: Implementar notificação
else
    log_message "ERRO: Falha ao reiniciar worker"
    
    # Enviar alerta crítico
    # TODO: Implementar alerta crítico
fi

exit 0
