<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';


require '../../class/walletClass.php';
require '../../class/getPlanosConfig.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';

require '../../class/usuariosApiContasbyUser.php';
require '../../class/getTokens.php';

// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);


if ($_SESSION['usuario']['is_adm'] != '1') {
    header('Location: /dash/dashboard');
    exit();
}

// ===== Buscar cores disponíveis para a whitelabel =====
$whitelabel = strtolower(Config::get('site_configs.name'));
try {
    $stmtCores = $pdo->prepare("SELECT * FROM drophub_global.tbl_cores WHERE whitelabel = :whitelabel OR whitelabel = 'all' ORDER BY nome ASC");
    $stmtCores->bindValue(':whitelabel', $whitelabel);
    $stmtCores->execute();
    $coresDisponiveis = $stmtCores->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $coresDisponiveis = [];
    error_log("Erro ao buscar cores: " . $e->getMessage());
}

// ================= Forçar Zerar Estoque (manual) =================
// Cooldown: 30 minutos entre usos por produto
$forceCooldownMin = 30;
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['get_force_status']) && isset($_GET['produto_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    $pid = trim($_GET['produto_id']);
    $can = true; $wait = 0; $lastManual = null;
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS drophub_global.zera_estoque_status (produto_id BIGINT PRIMARY KEY, locked TINYINT(1) NOT NULL DEFAULT 0, last_zero_at DATETIME NULL, last_restore_at DATETIME NULL, last_unlock_at DATETIME NULL, restore_done TINYINT(1) NOT NULL DEFAULT 0, partial_success TINYINT(1) NULL DEFAULT NULL, updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)");
        try { $pdo->exec("ALTER TABLE drophub_global.zera_estoque_status ADD COLUMN last_manual_force_at DATETIME NULL"); } catch (Throwable $e) { /* ignore */ }
        $stFM = $pdo->prepare("SELECT last_manual_force_at, TIMESTAMPDIFF(MINUTE,last_manual_force_at,NOW()) AS diff FROM drophub_global.zera_estoque_status WHERE produto_id = :pid LIMIT 1");
        $stFM->bindValue(':pid',$pid);
        $stFM->execute();
        $rowFM = $stFM->fetch(PDO::FETCH_ASSOC);
        if ($rowFM && $rowFM['last_manual_force_at']) {
            $lastManual = $rowFM['last_manual_force_at'];
            $diff = is_null($rowFM['diff'])?null:(int)$rowFM['diff'];
            if ($diff !== null && $diff < $forceCooldownMin) {
                $can = false; $wait = $forceCooldownMin - $diff;
            }
        }
    } catch (Throwable $e) {
        echo json_encode(['success'=>false,'error'=>'db_error','message'=>$e->getMessage()]);
        exit;
    }
    echo json_encode(['success'=>true,'can_force'=>$can,'wait_minutes'=>$wait,'cooldown_min'=>$forceCooldownMin,'last_manual_force_at'=>$lastManual]);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['force_zero']) && isset($_POST['produto_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    $pid = trim($_POST['produto_id']);
    if ($pid==='') { echo json_encode(['success'=>false,'message'=>'produto_id vazio']); exit; }
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS drophub_global.zera_estoque_status (produto_id BIGINT PRIMARY KEY, locked TINYINT(1) NOT NULL DEFAULT 0, last_zero_at DATETIME NULL, last_restore_at DATETIME NULL, last_unlock_at DATETIME NULL, restore_done TINYINT(1) NOT NULL DEFAULT 0, partial_success TINYINT(1) NULL DEFAULT NULL, updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)");
        try { $pdo->exec("ALTER TABLE drophub_global.zera_estoque_status ADD COLUMN last_manual_force_at DATETIME NULL"); } catch (Throwable $e) { /* ignore */ }
        $stChk = $pdo->prepare("SELECT TIMESTAMPDIFF(MINUTE,last_manual_force_at,NOW()) AS diff FROM drophub_global.zera_estoque_status WHERE produto_id=:pid LIMIT 1");
        $stChk->bindValue(':pid',$pid); $stChk->execute(); $row = $stChk->fetch(PDO::FETCH_ASSOC);
        if ($row && $row['diff']!==null && (int)$row['diff'] < $forceCooldownMin) {
            $wait = $forceCooldownMin - (int)$row['diff'];
            echo json_encode(['success'=>false,'message'=>'Aguarde '.$wait.' min para usar novamente.','wait_minutes'=>$wait]);
            exit;
        }
        $stUp = $pdo->prepare("INSERT INTO drophub_global.zera_estoque_status (produto_id,last_manual_force_at) VALUES (:pid,NOW()) ON DUPLICATE KEY UPDATE last_manual_force_at=NOW()");
        $stUp->bindValue(':pid',$pid); $stUp->execute();
        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $url = $scheme.'://'.$host.'/assets/validations/zera_estoque2.php?pid='.urlencode($pid).'&auto=1';
        try { $ch=curl_init($url); curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true,CURLOPT_TIMEOUT=>2,CURLOPT_CONNECTTIMEOUT=>2]); curl_exec($ch); curl_close($ch);} catch (Throwable $e) { /* ignore */ }
        echo json_encode(['success'=>true,'message'=>'Processo iniciado para produto '.$pid,'pid'=>$pid,'url'=>$url]);
    } catch (Throwable $e) {
        echo json_encode(['success'=>false,'message'=>'Erro ao iniciar: '.$e->getMessage()]);
    }
    exit;
}

// ===== Buscar produto e fornecedores (usando nova arquitetura V2) =====
try {
    $stmt = $pdo->prepare("SELECT * FROM drophub_global.produtos WHERE id = :id");
    $stmt->bindParam(':id', $_GET['id'], PDO::PARAM_INT);
    $stmt->execute();
    $produto = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$produto) { echo "Produto não encontrado."; exit; }
} catch (PDOException $e) { echo "Erro ao conectar ao banco de dados: ".$e->getMessage(); exit; }

// Buscar fornecedores usando a nova função global
$is_supplier = $_SESSION['usuario']['is_supplier'] ?? 0;
$id_usuario = $_SESSION['usuario']['id_usuario'];

try {
    if ($is_supplier == 1) {
        // Se for fornecedor, busca apenas o fornecedor dele
        $prefixo = pegaPrefixo();
        $fornecedor_id = $prefixo . $id_usuario;
        
        $fornecedores = getFornecedoresAtivos($pdo, [
            'apenas_ativos' => true,
            'order_by' => 'nome ASC'
        ]);
        
        // Filtrar apenas o fornecedor do usuário logado
        $fornecedores = array_filter($fornecedores, function($f) use ($fornecedor_id) {
            return $f['id'] === $fornecedor_id;
        });
        $fornecedores = array_values($fornecedores); // Reindexar array
    } else {
        // Se for admin, busca todos os fornecedores ativos
        $fornecedores = getFornecedoresAtivos($pdo, [
            'apenas_ativos' => true,
            'order_by' => 'nome ASC'
        ]);
    }
    
    // Garantir que é um array
    if (!is_array($fornecedores)) {
        $fornecedores = [];
    }
} catch (Exception $e) {
    error_log("Erro ao buscar fornecedores em editar_prod.php: " . $e->getMessage());
    $fornecedores = [];
}

$produto_id = $_GET['id'];
?>


<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter" >
<head>
<?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>
    
    <!-- Estilos customizados para thumb -->
    <style>
        /* THUMB - COMPLETAMENTE NÃO ARRASTÁVEL */
        .imagem-card[data-imagem-id*="thumb_"] {
            cursor: default !important;
            position: static !important;
        }
        
        .imagem-card[data-imagem-id*="thumb_"] .card {
            opacity: 0.95;
            cursor: default !important;
        }
        
        /* BLOQUEAR DRAG em TODA a thumb e seus elementos */
        .imagem-card[data-imagem-id*="thumb_"],
        .imagem-card[data-imagem-id*="thumb_"] *,
        .imagem-card[data-imagem-id*="thumb_"] .card,
        .imagem-card[data-imagem-id*="thumb_"] .btn,
        .imagem-card[data-imagem-id*="thumb_"] button,
        .imagem-card[data-imagem-id*="thumb_"] .excluir-thumb {
            -webkit-user-drag: none !important;
            -khtml-user-drag: none !important;
            -moz-user-drag: none !important;
            -o-user-drag: none !important;
            -webkit-user-select: none !important;
            -moz-user-select: none !important;
            -ms-user-select: none !important;
            user-select: none !important;
        }
        
        /* PERMITIR apenas cliques nos botões da thumb (mas NÃO drag) */
        .imagem-card[data-imagem-id*="thumb_"] .btn,
        .imagem-card[data-imagem-id*="thumb_"] .excluir-thumb,
        .imagem-card[data-imagem-id*="thumb_"] button {
            pointer-events: auto !important;
            cursor: pointer !important;
        }
        
        /* Indicar visualmente que demais imagens são arrastáveis */
        .imagem-card:not([data-imagem-id*="thumb_"]) .card:hover {
            cursor: grab;
            transform: translateY(-2px);
            transition: all 0.2s ease;
        }
        
        .imagem-card:not([data-imagem-id*="thumb_"]) .card:active {
            cursor: grabbing;
        }
    </style>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>


                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>

            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">

                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="mt-3">
                                <div class="p-2 rounded">

                                    <?php
                                    if ($produto['is_filho'] == 1) {
                                        $produto_pai = $produto['produto_pai'];
                                        $stmt_pai = $pdo->prepare("SELECT titulo FROM drophub_global.produtos WHERE id = :produto_pai");
                                        $stmt_pai->bindParam(':produto_pai', $produto_pai, PDO::PARAM_STR);
                                        $stmt_pai->execute();
                                        $produto_pai_info = $stmt_pai->fetch(PDO::FETCH_ASSOC);
                                        $produto_pai_titulo = $produto_pai_info ? $produto_pai_info['titulo'] : 'Desconhecido';
                                    ?>
                                        <div class="alert alert-primary" role="alert">
                                            <h4 class="alert-heading">Atenção!</h4>
                                            <p>Este produto é uma variação do produto principal <b><?= $produto_pai_titulo ?></b> diante disso alguns campos não poderão ser alterados.</p>
                                            <hr>
                                            <p class="mb-0"><a href="/dash/editar_prod?id=<?= $produto_pai ?>" class="fw-bolder">Clique aqui</a> e vá para o produto principal.</p>
                                        </div>
                                    <?php
                                    }
                                    ?>

                                    <div class="col-12">
                                        <div class="card mb-3">
                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0 card-title">Editar Produtos</h5>
                                            </div>
                                        </div>
                                    </div>



                                    <div class="card-body">
                                        <?php
                                        if (checkPermissionAdmin('produtos', 'editar', $dataAdmin) == 'true') {
                                        ?>
                                            <form method="POST" enctype="multipart/form-data" id="formProduto">
                                                <!-- Campo oculto para o ID -->
                                                <input type="hidden" name="id" value="<?= htmlspecialchars($produto['id']) ?>">

                                                <div class="row">
                                                    <div class="col-8">

                                                        <div class="card h-100 mb-4">
                                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                                <h5 class="mb-0 card-title">Informações do produto</h5>
                                                            </div>
                                                            <div class="card-body mt-3">
                                                                <!-- Campo para Título -->
                                                                <div class="mb-3">
                                                                    <label for="titulo" class="form-label">Título</label>
                                                                    <input type="text" class="form-control" name="titulo" id="titulo" value="<?= htmlspecialchars($produto['titulo']) ?>">
                                                                </div>

                                                                <div class="row">
                                                                    <div class="col-6 mb-2">
                                                                        <label for="estoque" class="form-label">Estoque</label>
                                                                        <div class="input-group">
                                                                            <input type="number" readonly min="0" class="form-control" name="estoque" id="estoque" value="<?= htmlspecialchars($produto['estoque']) ?>">
                                                                        </div>
                                                                        <small class="text-muted">Força zerar estoque nas plataformas (cooldown 30 min). Executa em background.</small>
                                                                    </div>

                                                                    <div class="col-6 mb-2">
                                                                        <label class="form-label" for="fornecedor">Fornecedor</label>
                                                                        <select required class="form-select" name="fornecedor" id="fornecedor">
                                                                            <option disabled value="">Selecione</option>
                                                                            <?php 
                                                                            if (!empty($fornecedores) && is_array($fornecedores)):
                                                                                foreach ($fornecedores as $fornecedor): 
                                                                                    if (!empty($fornecedor['id']) && !empty($fornecedor['nome'])):
                                                                            ?>
                                                                                <option value="<?= htmlspecialchars($fornecedor['id']) ?>" <?= ($fornecedor['id'] == ($produto['fornecedor'] ?? null)) ? 'selected' : '' ?>>
                                                                                    <?= htmlspecialchars($fornecedor['nome']) ?>
                                                                                </option>
                                                                            <?php 
                                                                                    endif;
                                                                                endforeach;
                                                                            else:
                                                                            ?>
                                                                                <option disabled value="">Nenhum fornecedor disponível</option>
                                                                            <?php endif; ?>
                                                                        </select>
                                                                    </div>

                                                                    <div class="col-6 mb-2">
                                                                        <label class="form-label" for="sku_fornecedoru">Ref. Fornecedor</label>
                                                                        <input type="text" class="form-control" name="sku_fornecedor" value="<?= htmlspecialchars($produto['sku_for']) ?>" id="sku_fornecedor" placeholder="sku fornecedor">
                                                                    </div>

                                                                    <div class="col-6 d-none mb-2">
                                                                        <label class="form-label" for="category_domain">Category Domain</label>
                                                                        <input type="text" class="form-control" name="category_domain" value="<?= htmlspecialchars($produto['category_domain']) ?>" id="category_domain" placeholder="category_domain">
                                                                    </div>

                                                                    <div class="col-6 d-none mb-2">
                                                                        <label class="form-label" for="categoria_shopee">categoria_shopee</label>
                                                                        <input type="text" class="form-control" name="categoria_shopee" value="<?= htmlspecialchars($produto['categoria_shopee']) ?>" id="categoria_shopee" placeholder="categoria_shopee">
                                                                    </div>

                                                                    <div class="col-6 mb-2">
                                                                        <label class="form-label" for="sku_fornecedoru">NCM</label>
                                                                        <input type="text" class="form-control" name="ncm" id="ncm" value="<?= $produto['ncm'] ?>" oninput="this.value = this.value.replace(/[^0-9]/g, '')" id="sku_fornecedor" placeholder="sku fornecedor">
                                                                    </div>

                                                                    <div class="col-4 mb-2">
                                                                        <label class="form-label" for="altura">Altura <small class="text-muted">(cm)</small></label>
                                                                        <input type="number" max="999" min="1" class="form-control" value="<?= $produto['altura'] ?>" required="" name="altura" id="altura" placeholder="Altura do pacote">
                                                                    </div>

                                                                    <div class="col-4 mb-2">
                                                                        <label class="form-label" for="largura">Largura <small class="text-muted">(cm)</small></label>
                                                                        <input type="number" max="999" min="1" class="form-control" value="<?= $produto['largura'] ?>" required="" name="largura" id="largura" placeholder="Largura do pacote">
                                                                    </div>

                                                                    <div class="col-4 mb-2">
                                                                        <label class="form-label" for="comprimento">Comprimento <small class="text-muted">(cm)</small></label>
                                                                        <input type="number" max="999" min="1" class="form-control" value="<?= $produto['comprimento'] ?>" required="" name="comprimento" id="comprimento" placeholder="Comprimento do pacote">
                                                                    </div>

                                                                    <?php
                                                                    $peso_explode = explode(" ", $produto['peso']);
                                                                    $vlr_peso = $peso_explode[0];
                                                                    $vlr_unidade = $peso_explode[1];
                                                                    ?>
                                                                    <div class="col-12 mb-2">
                                                                        <label class="form-label" for="peso">Peso do pacote</label>
                                                                        <div class="input-group mb-3">
                                                                            <input type="number" step="0.2" max="999" min="1" value="<?= $vlr_peso ?>" class="form-control" name="peso" id="peso" placeholder="Digite o peso" aria-label="Peso do pacote">
                                                                            <select class="form-select" name="unidade" id="unidade" aria-label="Selecionar unidade">
                                                                                <option selected value="<?= $vlr_unidade ?>"><?= $vlr_unidade ?></option>

                                                                                <!-- <option value="KG">KG</option>
                                                                            <option value="ML">ML</option>
                                                                            <option value="L">L</option>
                                                                            <option value="MG">MG</option>
                                                                            <option value="G/GR">G</option>
                                                                            <option value="CM">CM</option>
                                                                            <option value="M">M</option>
                                                                            <option value="Dozen">DZ</option>
                                                                            <option value="Piece">PC</option>
                                                                            <option value="Pack">PCT</option>
                                                                            <option value="Set">CJ</option>
                                                                            <option value="Box">CX</option> -->
                                                                            </select>
                                                                        </div>
                                                                        <input type="hidden" class="form-control" name="atributo_101029*label_Peso_Pacote" id="value_peso_pacote" readonly="" placeholder="Resultado">
                                                                    </div>
                                                                </div>

                                                                <!-- Campo para Descrição -->
                                                                <div class="mb-3">
                                                                    <label for="descricao" class="form-label">Descrição</label>
                                                                    <textarea class="form-control" name="descricao" id="descricao" rows="3"><?= htmlspecialchars($produto['descricao']) ?></textarea>
                                                                </div>
                                                            </div>
                                                        </div>


                                                    </div>

                                                    <div class="col-4">
                                                        <!-- NOVA Seção para Categoria e Atributos Shopee (baseada em adicionar_produtos.php) -->
                                                        <div class="card mb-4">
                                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                                <h5 class="mb-0 card-title">Categoria e Atributos Shopee</h5>
                                                            </div>
                                                            <div class="card-body mt-3">
                                                                <div id="shopee-info-edit" class="info-section"> <!-- ID único para evitar conflito -->

                                                                    <div class="mb-4">
                                                                        <label for="nome_produto_shopee" class="form-label fw-semibold">
                                                                            Buscar Categoria Shopee
                                                                        </label>
                                                                        <div class="dropdown w-100">
                                                                            <input
                                                                                type="text"
                                                                                id="nome_produto_shopee"
                                                                                class="form-control form-control dropdown-toggle"
                                                                                value="<?= htmlspecialchars($produto['titulo']) ?>"
                                                                                placeholder="Digite para buscar categorias (ex: chinelo, camiseta, smartphone)..."
                                                                                autocomplete="off"
                                                                                data-bs-toggle="dropdown"
                                                                                data-bs-auto-close="false">
                                                                            <ul class="dropdown-menu w-100" id="shopee-search-dropdown" style="max-height: 400px; overflow-y: auto;">
                                                                                <!-- Dynamic content will be inserted here -->
                                                                            </ul>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Error Alert -->
                                                                    <div id="shopee-error-message" class="alert alert-danger d-none" role="alert">
                                                                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                                                        <span id="shopee-error-text"></span>
                                                                    </div>

                                                                    <!-- Result Input -->
                                                                    <div class="mb-3 d-none">
                                                                        <label for="id_shopee" class="form-label fw-semibold">
                                                                            <i class="bi bi-tag me-2"></i>Categoria Selecionada
                                                                        </label>
                                                                        <div class="input-groupe">
                                                                            <span class="input-group-text">
                                                                                <i class="bi bi-hash"></i>
                                                                            </span>
                                                                            <input
                                                                                type="text"
                                                                                id="categoria_shopee_display"
                                                                                class="form-control"
                                                                                placeholder="Nenhuma categoria selecionada"
                                                                                readonly>
                                                                            <button class="btn btn-outline-secondary" type="button" onclick="clearShopeeSelection()">
                                                                                <i class="bi bi-x-lg"></i>
                                                                            </button>
                                                                        </div>
                                                                    </div>


                                                                    <!-- <div class="form-group mb-3">
                                                                        <label class="form-label"><strong>Categoria Shopee Sugerida:</strong></label>
                                                                        <span id="categoria-sugerida-edit">Carregando...</span>
                                                                    </div> -->

                                                                    <p><strong>Atributos Específicos / Obrigatórios Shopee:</strong></p>
                                                                    <div id="atributos-obrigatorios-edit-wrapper">
                                                                        <div id="atributos-obrigatorios-edit"></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- FIM NOVA Seção -->


                                                        <div class="card b-4">
                                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                                <h5 class="mb-0 card-title">Categoria e Atributos <small class="text-muted">[Mercado Livre]</small></h5>
                                                            </div>
                                                            <div class="card-body mt-3">
                                                                <!-- Campo de busca de categoria ML -->
                                                                <div class="mb-4">
                                                                    <label for="nome_produto_ml_edit" class="form-label fw-semibold">
                                                                        Buscar Nova Categoria ML
                                                                    </label>
                                                                    <input
                                                                        type="text"
                                                                        id="nome_produto_ml_edit"
                                                                        class="form-control"
                                                                        placeholder="Digite o nome do produto para buscar categoria (ex: chinelo, camiseta)..."
                                                                        value="<?= htmlspecialchars($produto['titulo']) ?>">
                                                                    <small class="text-muted">Digite e pressione Enter ou aguarde para buscar automaticamente</small>
                                                                    
                                                                    <!-- Hidden fields para armazenar categoria -->
                                                                    <input type="hidden" id="domain_id_edit" name="domain_id" value="<?= htmlspecialchars($produto['category_domain'] ?? '') ?>">
                                                                    <input type="hidden" id="domain_name_edit" name="domain_name" value="<?= htmlspecialchars($produto['category_domain'] ?? '') ?>">
                                                                    <input type="hidden" id="category_id_edit" name="category_id" value="<?= htmlspecialchars($produto['id_cat_ml'] ?? '') ?>">
                                                                    <input type="hidden" id="category_name_edit" name="category_name" value="<?= htmlspecialchars($produto['categoria_ml'] ?? '') ?>">
                                                                    
                                                                    <!-- Display categoria atual -->
                                                                    <div class="mt-2">
                                                                        <small class="text-muted">Categoria atual: <strong id="categoria_ml_display_edit"><?= htmlspecialchars($produto['categoria_ml'] ?? 'Não definida') ?></strong></small>
                                                                    </div>
                                                                </div>
                                                                
                                                                <hr>
                                                                
                                                                <p class="fw-semibold mb-3">Atributos Obrigatórios:</p>
                                                                <div id="ml-atributos-obrigatorios-edit"></div>
                                                            </div>
                                                        </div>
                                                        <!-- Script para buscar e preencher atributos obrigatórios Mercado Livre ao editar -->
                                                        <?php
                                                        // --- PHP: Buscar access_token atualizado e category_id igual ao adicionar_produtos.php ---
                                                        $user_id = $_SESSION['usuario']['id_usuario'];
                                                        $tokenFetcher = new TokenFetcher($pdo);
                                                        $dados = $tokenFetcher->getTokenByPlataforma('MercadoLivre', ['client_id', 'client_secret']);
                                                        $client_id = $dados['client_id'] ?? null;
                                                        $client_secret = $dados['client_secret'] ?? null;
                                                        $usuarioApiConta = new UsuarioApiConta($pdo);
                                                        $resultados_tokens = $usuarioApiConta->buscarUsuariosApiContas($user_id, 'fornecedor_ml');
                                                        $access_token = null;
                                                        $shop_id = null;
                                                        $refresh_token = null;
                                                        if (!empty($resultados_tokens)) {
                                                            $conta = $resultados_tokens[0];
                                                            $access_token = $conta['access_token'];
                                                            $shop_id = $conta['seller_id'];
                                                            $refresh_token = $conta['refresh_token'];
                                                        }
                                                        // Atualiza token se necessário
                                                        if ($client_id && $client_secret && $refresh_token) {
                                                            $url = 'https://api.mercadolibre.com/oauth/token';
                                                            $post_fields = http_build_query([
                                                                'grant_type'    => 'refresh_token',
                                                                'client_id'     => $client_id,
                                                                'client_secret' => $client_secret,
                                                                'refresh_token' => $refresh_token,
                                                            ]);
                                                            $ch = curl_init();
                                                            curl_setopt_array($ch, array(
                                                                CURLOPT_URL => $url,
                                                                CURLOPT_RETURNTRANSFER => true,
                                                                CURLOPT_CUSTOMREQUEST => 'POST',
                                                                CURLOPT_POSTFIELDS => $post_fields,
                                                                CURLOPT_HTTPHEADER => array(
                                                                    'accept: application/json',
                                                                    'content-type: application/x-www-form-urlencoded'
                                                                ),
                                                            ));
                                                            $response = curl_exec($ch);
                                                            curl_close($ch);
                                                            $data = json_decode($response, true);
                                                            if (!empty($data['access_token']) && !empty($data['refresh_token'])) {
                                                                $new_access_token = $data['access_token'];
                                                                $new_refresh_token = $data['refresh_token'];
                                                                // Atualiza os tokens no banco de dados
                                                                $sqlUpdate = "UPDATE drophub_global.usuarios_api_contas SET access_token = :access_token, code = :refresh_token WHERE seller_id = :seller_id AND plataforma = 'fornecedor_ml'";
                                                                $stmtUpdate = $pdo->prepare($sqlUpdate);
                                                                $stmtUpdate->execute([
                                                                    'access_token' => $new_access_token,
                                                                    'refresh_token' => $new_refresh_token,
                                                                    'seller_id' => $shop_id
                                                                ]);
                                                                $access_token = $new_access_token;
                                                            }
                                                        }
                                                        // Buscar category_id do produto
                                                        $category_id_ml = $produto['category_id_ml'] ?? ($produto['id_cat_ml'] ?? '');
                                                        ?>
                                                        <?php
                                                        // Buscar atributos do banco diretamente
                                                        $atributosBanco = [];
                                                        $sql_atributos = "SELECT id, id_atributo, nome_atributo, valor_atributo FROM drophub_global.produtos_atributos WHERE id_produto = :produto_id";
                                                        $stmt_atributos = $pdo->prepare($sql_atributos);
                                                        $stmt_atributos->bindParam(':produto_id', $produto_id, PDO::PARAM_INT);
                                                        $stmt_atributos->execute();
                                                        $atributosBanco = $stmt_atributos->fetchAll(PDO::FETCH_ASSOC);
                                                        ?>
                                                        <script>
                                                            // ===== FUNÇÕES GLOBAIS =====
                                                            // Função GLOBAL para renderizar atributos (acessível de qualquer lugar)
                                                            function renderAtributos(atributosML, atributosBanco, mostrarIrregulares = true) {
                                                                const mlAtributosDiv = document.getElementById('ml-atributos-obrigatorios-edit');
                                                                if (!mlAtributosDiv) {
                                                                    console.error('mlAtributosDiv não encontrado');
                                                                    return;
                                                                }
                                                                
                                                                mlAtributosDiv.innerHTML = '';
                                                                if (!Array.isArray(atributosML) || atributosML.length === 0) {
                                                                    mlAtributosDiv.innerHTML = '<p class="text-muted">Nenhum atributo obrigatório encontrado para esta categoria.</p>';
                                                                    return;
                                                                }
                                                                // Mapeia os valores do banco por id_atributo
                                                                const valoresBanco = {};
                                                                if (Array.isArray(atributosBanco)) {
                                                                    atributosBanco.forEach(attr => {
                                                                        valoresBanco[attr.id_atributo] = {
                                                                            valor: attr.valor_atributo,
                                                                            id: attr.id,
                                                                            nome: attr.nome_atributo
                                                                        };
                                                                    });
                                                                }
                                                                // IDs dos atributos obrigatórios do ML (apenas required === true)
                                                                const idsML = atributosML.filter(attribute => (
                                                                    (attribute.tags && attribute.tags.required === true) ||
                                                                    attribute.hierarchy === "PARENT_PK"
                                                                )).map(attribute => attribute.id);

                                                                // Renderiza atributos obrigatórios do ML
                                                                atributosML.forEach(attribute => {
                                                                    if ((attribute.tags && attribute.tags.required === true) || attribute.hierarchy === "PARENT_PK") {
                                                                        const div = document.createElement('div');
                                                                        div.className = 'mb-3';

                                                                        const label = document.createElement('label');
                                                                        label.textContent = attribute.name;
                                                                        label.className = 'form-label fw-semibold';
                                                                        label.htmlFor = 'atributo_' + attribute.id;

                                                                        let inputElement;
                                                                        
                                                                        // Verifica se o atributo tem valores predefinidos (SELECT)
                                                                        if (attribute.values && Array.isArray(attribute.values) && attribute.values.length > 0) {
                                                                            // Criar SELECT com opções
                                                                            inputElement = document.createElement('select');
                                                                            inputElement.className = 'form-select';
                                                                            inputElement.id = 'atributo_' + attribute.id;
                                                                            inputElement.name = 'atributo_' + attribute.id;
                                                                            inputElement.required = true;
                                                                            
                                                                            // Opção padrão vazia
                                                                            const defaultOption = document.createElement('option');
                                                                            defaultOption.value = '';
                                                                            defaultOption.textContent = 'Selecione uma opção';
                                                                            defaultOption.disabled = true;
                                                                            defaultOption.selected = !valoresBanco[attribute.id]; // Só seleciona se não houver valor salvo
                                                                            inputElement.appendChild(defaultOption);
                                                                            
                                                                            // Adicionar cada opção
                                                                            attribute.values.forEach(valueOption => {
                                                                                const option = document.createElement('option');
                                                                                option.value = valueOption.name || valueOption.id;
                                                                                option.textContent = valueOption.name || valueOption.id;
                                                                                
                                                                                // Seleciona se o valor salvo corresponder
                                                                                if (valoresBanco[attribute.id] && 
                                                                                    (valoresBanco[attribute.id].valor === valueOption.name || 
                                                                                     valoresBanco[attribute.id].valor === valueOption.id)) {
                                                                                    option.selected = true;
                                                                                    console.log(`SELECT ${attribute.id}: Selecionando opção "${valueOption.name}"`);
                                                                                }
                                                                                
                                                                                inputElement.appendChild(option);
                                                                            });
                                                                            
                                                                            if (valoresBanco[attribute.id]) {
                                                                                inputElement.setAttribute('data-atributo-db-id', valoresBanco[attribute.id].id);
                                                                            }
                                                                            
                                                                        } else {
                                                                            // Criar INPUT de texto normal
                                                                            inputElement = document.createElement('input');
                                                                            inputElement.type = 'text';
                                                                            inputElement.className = 'form-control';
                                                                            inputElement.id = 'atributo_' + attribute.id;
                                                                            inputElement.name = 'atributo_' + attribute.id;
                                                                            inputElement.placeholder = attribute.name;
                                                                            inputElement.required = true;
                                                                            
                                                                            // Preenche com valor do banco se existir PARA O MESMO ATRIBUTO
                                                                            if (valoresBanco[attribute.id]) {
                                                                                inputElement.value = valoresBanco[attribute.id].valor;
                                                                                inputElement.setAttribute('data-atributo-db-id', valoresBanco[attribute.id].id);
                                                                                console.log(`INPUT ${attribute.id}: Preenchendo com valor salvo: ${valoresBanco[attribute.id].valor}`);
                                                                            } else {
                                                                                console.log(`INPUT ${attribute.id} (${attribute.name}): Campo vazio - não há valor salvo`);
                                                                            }
                                                                        }

                                                                        div.appendChild(label);
                                                                        div.appendChild(inputElement);
                                                                        mlAtributosDiv.appendChild(div);
                                                                    }
                                                                });

                                                                // Atributos irregulares: do banco que não vieram do ML
                                                                // Só mostra se mostrarIrregulares === true (para carregamento inicial)
                                                                if (mostrarIrregulares) {
                                                                    const irregulares = atributosBanco.filter(attr => !idsML.includes(attr.id_atributo));
                                                                    if (irregulares.length > 0) {
                                                                        const hr = document.createElement('hr');
                                                                        hr.className = 'my-4';
                                                                        mlAtributosDiv.appendChild(hr);

                                                                        // Card container clean
                                                                        const card = document.createElement('div');
                                                                        card.className = 'card shadow-sm mb-3 border-0';

                                                                        const cardBody = document.createElement('div');
                                                                        cardBody.className = 'card-body py-3 px-3';

                                                                        const titulo = document.createElement('div');
                                                                        titulo.className = 'mb-3 fw-semibold text-warning d-flex align-items-center gap-2';
                                                                        titulo.innerHTML = '<i class="bi bi-exclamation-triangle"></i> Atributos da Categoria Anterior';
                                                                        cardBody.appendChild(titulo);
                                                                        
                                                                        const aviso = document.createElement('p');
                                                                        aviso.className = 'text-muted small mb-3';
                                                                        aviso.textContent = 'Estes atributos não são obrigatórios na categoria atual e serão removidos ao salvar.';
                                                                        cardBody.appendChild(aviso);

                                                                        irregulares.forEach(attr => {
                                                                            const row = document.createElement('div');
                                                                            row.className = 'd-flex align-items-center justify-content-between mb-2 flex-wrap';

                                                                            const info = document.createElement('div');
                                                                            info.className = 'flex-grow-1';
                                                                            info.innerHTML = `<span class="fw-medium">${attr.nome_atributo}</span><br><small class="text-muted">${attr.valor_atributo}</small>`;

                                                                            const btnRemove = document.createElement('button');
                                                                            btnRemove.type = 'button';
                                                                            btnRemove.className = 'btn btn-sm btn-outline-danger';
                                                                            btnRemove.innerHTML = '<i class="bi bi-trash"></i>';
                                                                            btnRemove.onclick = function() {
                                                                                if (typeof Swal === 'undefined') {
                                                                                    alert('SweetAlert2 não encontrado!');
                                                                                    return;
                                                                                }
                                                                                Swal.fire({
                                                                                    title: 'Remover atributo?',
                                                                                    text: 'Tem certeza que deseja remover este atributo irregular do banco?',
                                                                                    icon: 'warning',
                                                                                    showCancelButton: true,
                                                                                    confirmButtonColor: '#d33',
                                                                                    cancelButtonColor: '#6c757d',
                                                                                    confirmButtonText: 'Sim, remover',
                                                                                    cancelButtonText: 'Cancelar'
                                                                                }).then((result) => {
                                                                                    if (result.isConfirmed) {
                                                                                        fetch('/assets/ajax/produtos/remover_atributo_produto.php', {
                                                                                                method: 'POST',
                                                                                                headers: {
                                                                                                    'Content-Type': 'application/x-www-form-urlencoded'
                                                                                                },
                                                                                                body: 'id=' + encodeURIComponent(attr.id)
                                                                                            })
                                                                                            .then(res => res.json())
                                                                                            .then(data => {
                                                                                                if (data.success) {
                                                                                                    row.remove();
                                                                                                    Swal.fire('Removido!', 'Atributo removido com sucesso.', 'success');
                                                                                                    // Atualiza atributos globais
                                                                                                    buscarAtributosDoBanco(function(updated) {
                                                                                                        atributosBancoGlobal = updated;
                                                                                                    });
                                                                                                } else {
                                                                                                    Swal.fire('Erro!', 'Erro ao remover atributo!', 'error');
                                                                                                }
                                                                                            })
                                                                                            .catch(() => Swal.fire('Erro!', 'Erro ao remover atributo!', 'error'));
                                                                                    }
                                                                                });
                                                                            };

                                                                            row.appendChild(info);
                                                                            row.appendChild(btnRemove);
                                                                            cardBody.appendChild(row);
                                                                        });

                                                                        card.appendChild(cardBody);
                                                                        mlAtributosDiv.appendChild(card);
                                                                    }
                                                                }
                                                            }
                                                            // ===== FIM FUNÇÕES GLOBAIS =====
                                                            
                                                            document.addEventListener('DOMContentLoaded', function() {
                                                                const mlAtributosDiv = document.getElementById('ml-atributos-obrigatorios-edit');
                                                                const categoryId = '<?= $category_id_ml ?>';
                                                                const accessToken = '<?= $access_token ?>';
                                                                const atributosBanco = <?= json_encode($atributosBanco) ?>;

                                                                // Função para buscar atributos obrigatórios do ML
                                                                function fetchAtributosML(categoryId, accessToken) {
                                                                    const formData = new FormData();
                                                                    formData.append('category_id', categoryId);
                                                                    if (accessToken) formData.append('access_token', accessToken);
                                                                    return fetch('/assets/ajax/plataformas/mercado_livre/buscar_atributos.php', {
                                                                        method: 'POST',
                                                                        body: formData
                                                                    }).then(res => res.json());
                                                                }

                                                                // Execução principal
                                                                if (categoryId && accessToken) {
                                                                    fetchAtributosML(categoryId, accessToken).then(atributosML => {
                                                                        // TRUE = mostrar atributos irregulares no carregamento inicial
                                                                        renderAtributos(atributosML, atributosBanco, true);
                                                                    });
                                                                } else {
                                                                    mlAtributosDiv.innerHTML = '<p class="text-muted">Categoria ou token do Mercado Livre não disponível.</p>';
                                                                }
                                                            });
                                                        </script>
                                                        
                                                        <!-- Script para busca de categoria ML no editar -->
                                                        <script>
                                                            // Variável global para armazenar atributos do banco
                                                            let atributosBancoGlobal = <?= json_encode($atributosBanco) ?>;
                                                            const accessTokenGlobal = '<?= $access_token ?>';
                                                            const produtoIdEdit = '<?= $produto_id ?>';
                                                            
                                                            // Função GLOBAL para buscar atributos atualizados do banco
                                                            function buscarAtributosDoBanco(callback) {
                                                                fetch('/assets/ajax/produtos/buscar_atributos_produto.php', {
                                                                    method: 'POST',
                                                                    headers: {
                                                                        'Content-Type': 'application/x-www-form-urlencoded'
                                                                    },
                                                                    body: 'produto_id=' + encodeURIComponent(produtoIdEdit)
                                                                })
                                                                .then(res => res.json())
                                                                .then(data => {
                                                                    if (data.success && Array.isArray(data.atributos)) {
                                                                        atributosBancoGlobal = data.atributos;
                                                                        if (callback) callback(atributosBancoGlobal);
                                                                    } else {
                                                                        console.log('Usando atributos em cache');
                                                                        if (callback) callback(atributosBancoGlobal);
                                                                    }
                                                                })
                                                                .catch(error => {
                                                                    console.error('Erro ao buscar atributos do banco:', error);
                                                                    if (callback) callback(atributosBancoGlobal);
                                                                });
                                                            }
                                                            
                                                            document.addEventListener('DOMContentLoaded', function() {
                                                                const nomeProdutoMLInput = document.getElementById('nome_produto_ml_edit');
                                                                const domainIdInput = document.getElementById('domain_id_edit');
                                                                const domainNameInput = document.getElementById('domain_name_edit');
                                                                const categoryIdInput = document.getElementById('category_id_edit');
                                                                const categoryNameInput = document.getElementById('category_name_edit');
                                                                const categoriaDisplayEdit = document.getElementById('categoria_ml_display_edit');
                                                                const mlAtributosDiv = document.getElementById('ml-atributos-obrigatorios-edit');
                                                                
                                                                let searchTimeout;
                                                                
                                                                // Função para buscar categoria ML
                                                                function buscarCategoriaML(nomeProduto) {
                                                                    if (!nomeProduto || nomeProduto.trim() === '') return;
                                                                    
                                                                    const url = `https://api.mercadolibre.com/sites/MLB/domain_discovery/search?limit=1&q=${encodeURIComponent(nomeProduto.trim())}`;
                                                                    
                                                                    fetch(url)
                                                                        .then(response => response.json())
                                                                        .then(data => {
                                                                            if (data && data.length > 0) {
                                                                                const category = data[0];
                                                                                
                                                                                // Atualiza campos hidden
                                                                                domainIdInput.value = category.domain_id || '';
                                                                                domainNameInput.value = category.domain_name || '';
                                                                                categoryIdInput.value = category.category_id || '';
                                                                                categoryNameInput.value = category.category_name || '';
                                                                                
                                                                                // Atualiza display
                                                                                categoriaDisplayEdit.textContent = category.category_name || 'Não definida';
                                                                                
                                                                                // Busca novos atributos
                                                                                if (category.category_id) {
                                                                                    buscarNovosAtributosML(category.category_id);
                                                                                }
                                                                            } else {
                                                                                console.log('Nenhuma categoria encontrada');
                                                                            }
                                                                        })
                                                                        .catch(error => {
                                                                            console.error('Erro ao buscar categoria ML:', error);
                                                                        });
                                                                }
                                                                
                                                                // Função para buscar atributos da nova categoria
                                                                function buscarNovosAtributosML(categoryId) {
                                                                    // Mostra loading
                                                                    mlAtributosDiv.innerHTML = '<p class="text-muted"><i class="bi bi-hourglass-split"></i> Buscando atributos...</p>';
                                                                    
                                                                    // Primeiro busca atributos atualizados do banco
                                                                    buscarAtributosDoBanco(function(atributosBancoAtualizados) {
                                                                        // Depois busca atributos da categoria ML
                                                                        const formData = new FormData();
                                                                        formData.append('category_id', categoryId);
                                                                        if (accessTokenGlobal) formData.append('access_token', accessTokenGlobal);
                                                                        
                                                                        fetch('/assets/ajax/plataformas/mercado_livre/buscar_atributos.php', {
                                                                            method: 'POST',
                                                                            body: formData
                                                                        })
                                                                        .then(res => res.json())
                                                                        .then(atributosML => {
                                                                            // Usa a função global renderAtributos
                                                                            // FALSE = não mostrar atributos irregulares ao buscar nova categoria
                                                                            if (typeof renderAtributos === 'function') {
                                                                                renderAtributos(atributosML, atributosBancoAtualizados, false);
                                                                            } else {
                                                                                console.error('Função renderAtributos não encontrada');
                                                                            }
                                                                        })
                                                                        .catch(error => {
                                                                            console.error('Erro ao buscar atributos ML:', error);
                                                                            mlAtributosDiv.innerHTML = '<p class="text-danger">Erro ao carregar atributos. Tente novamente.</p>';
                                                                        });
                                                                    });
                                                                }
                                                                
                                                                // Eventos de busca
                                                                nomeProdutoMLInput.addEventListener('input', function() {
                                                                    clearTimeout(searchTimeout);
                                                                    searchTimeout = setTimeout(() => {
                                                                        buscarCategoriaML(this.value);
                                                                    }, 800); // Delay de 800ms após parar de digitar
                                                                });
                                                                
                                                                nomeProdutoMLInput.addEventListener('keypress', function(e) {
                                                                    if (e.key === 'Enter') {
                                                                        e.preventDefault();
                                                                        clearTimeout(searchTimeout);
                                                                        buscarCategoriaML(this.value);
                                                                    }
                                                                });
                                                            });
                                                        </script>
                                                    </div>
                                                </div>

                                                <?php
                                                if ($produto['is_filho'] == 0) {
                                                ?>
                                                    <div class="col-12 mt-3">
                                                        <div class="card mb-4">
                                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                                <h5 class="mb-0 card-title">Variações</h5>

                                                                <button type="button" class="btn btn-primary btn-sm" id="btnAddVariacao" data-bs-toggle="modal" data-bs-target="#modalVariacao">
                                                                    <i class="bi bi-plus"></i> Adicionar Variação
                                                                </button>
                                                            </div>
                                                            <div class="card-body mt-3">
                                                                <?php
                                                                // Buscar variações do produto (produtos filhos)
                                                                $sql_variacoes = "SELECT * FROM drophub_global.produtos WHERE produto_pai = :produto_id AND is_filho = 1";
                                                                $stmt_variacoes = $pdo->prepare($sql_variacoes);
                                                                $stmt_variacoes->bindParam(':produto_id', $produto_id, PDO::PARAM_STR);
                                                                $stmt_variacoes->execute();
                                                                $variacoes = $stmt_variacoes->fetchAll(PDO::FETCH_ASSOC);

                                                                ?>
                                                                <!-- Variações aqui -->
                                                                <div id="card-variacoes-lista" class="row">
                                                                    <?php
                                                                    ?>
                                                                    <script>
                                                                        $(document).ready(function() {
                                                                            atualizarCardVariacoes();
                                                                        });
                                                                    </script>
                                                                </div>
                                                                <script>
                                                                    // Função para atualizar apenas o card de variações
                                                                    function atualizarCardVariacoes() {
                                                                        $.ajax({
                                                                            url: '/assets/ajax/produtos/card_variacoes_list.php',
                                                                            type: 'GET',
                                                                            data: {
                                                                                produto_id: '<?= $_GET['id'] ?>'
                                                                            },
                                                                            success: function(html) {
                                                                                $('#card-variacoes-lista').html(html);
                                                                            },
                                                                            error: function() {
                                                                                $('#card-variacoes-lista').html('<div class="col-12"><p class="text-danger">Erro ao atualizar variações.</p></div>');
                                                                            }
                                                                        });
                                                                    }

                                                                    // Após adicionar variação com sucesso, atualizar apenas o card de variações
                                                                    $(document).on('click', '#btnSalvarVariacao', function() {
                                                                        var form = $('#formVariacao')[0];
                                                                        if (!form.checkValidity()) {
                                                                            form.reportValidity();
                                                                            return;
                                                                        }
                                                                        var formData = new FormData(form);
                                                                        formData.append('produto_id', '<?= $produto_id ?>');
                                                                        formData.append('produto_pai_id', '<?= $_GET['id'] ?>');
                                                                        $.ajax({
                                                                            url: '../../assets/ajax/produtos/adicionar_variacao.php',
                                                                            type: 'POST',
                                                                            data: formData,
                                                                            processData: false,
                                                                            contentType: false,
                                                                            dataType: 'json',
                                                                            success: function(res) {
                                                                                if (res.success) {
                                                                                    $('#modalVariacao').modal('hide');
                                                                                    $('#formVariacao')[0].reset();
                                                                                    atualizarCardVariacoes(); // Atualiza só o card de variações
                                                                                    Swal.fire({
                                                                                        icon: 'success',
                                                                                        text: 'Variação adicionada com sucesso!',
                                                                                        timer: 1200,
                                                                                        showConfirmButton: false
                                                                                    });
                                                                                } else {
                                                                                    Swal.fire({
                                                                                        icon: 'error',
                                                                                        text: res.message || 'Erro ao adicionar variação.'
                                                                                    });
                                                                                }
                                                                            },
                                                                            error: function() {
                                                                                Swal.fire({
                                                                                    icon: 'error',
                                                                                    text: 'Erro ao adicionar variação.'
                                                                                });
                                                                            }
                                                                        });
                                                                        return false;
                                                                    });
                                                                </script>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                                }
                                                ?>
                                                <div class="col-12 mt-3">
                                                    <div class="card mb-4">
                                                        <div class="card-header d-flex justify-content-between align-items-center">
                                                            <h5 class="mb-0 card-title">Imagens</h5>
                                                        </div>
                                                        <div class="card-body mt-3">
                                                            <div class="mb-3">
                                                                <label for="imagem" class="form-label">Escolha uma Imagem:</label>
                                                                <input type="file" multiple class="form-control" id="imagem" name="imagem">
                                                            </div>
                                                            <button type="button" id="btnEnviarImagem" class="btn btn-primary">Enviar Imagem</button>

                                                            <hr class="text-dark bg-opacity-10 mt-4 mx-auto">
                                                            </hr>

                                                            <?php
                                                            $produto_id = $_GET['id'] ?? null;
                                                            if (!$produto_id) {
                                                                echo "Produto ID não fornecido!";
                                                                exit;
                                                            }

                                                            // Consulta para buscar as imagens do produto
                                                            $sql = "SELECT 
                                                                    MIN(id) AS id, 
                                                                    imagem_url 
                                                                FROM 
                                                                    drophub_global.produtos_imagens 
                                                                WHERE 
                                                                    produto_id = :produto_id 
                                                                GROUP BY 
                                                                    imagem_url 
                                                                ORDER BY 
                                                                    MIN(ordem) ASC
                                                                ";
                                                            $stmt = $pdo->prepare($sql);
                                                            $stmt->bindValue(':produto_id', $produto_id, PDO::PARAM_INT);
                                                            $stmt->execute();
                                                            $imagens = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                                            ?>

                                                            <div class="row g-4 mt-2" id="imagem-container">
                                                                <?php 
                                                                // Separar thumb das demais imagens
                                                                $thumb = null;
                                                                $imagensNormais = [];
                                                                
                                                                // Primeiro, processar imagens da tabela
                                                                foreach ($imagens as $imagem) {
                                                                    if (basename($imagem['imagem_url']) === 'thumb.png') {
                                                                        $thumb = $imagem;
                                                                    } else {
                                                                        $imagensNormais[] = $imagem;
                                                                    }
                                                                }
                                                                
                                                                // Se não encontrou thumb na tabela, verificar se existe fisicamente
                                                                if (!$thumb && !empty($imagensNormais)) {
                                                                    // Pegar o diretório da primeira imagem para verificar se tem thumb.png
                                                                    $primeiraImagem = $imagensNormais[0]['imagem_url'];
                                                                    
                                                                    // Garantir que temos apenas o path a partir de /images
                                                                    if (strpos($primeiraImagem, '/images') !== false) {
                                                                        // Se contém /images, pegar tudo a partir dele
                                                                        $primeiraImagem = '/images' . explode('/images', $primeiraImagem)[1];
                                                                    }
                                                                    
                                                                    $diretorioImagem = dirname($primeiraImagem);
                                                                    $thumbUrl = $diretorioImagem . '/thumb.png';
                                                                    $thumbPath = $_SERVER['DOCUMENT_ROOT'] . $thumbUrl;

                                                                    // Se o arquivo thumb.png existe fisicamente
                                                                    if (file_exists($thumbPath)) {
                                                                        $thumb = [
                                                                            'id' => 'thumb_' . $produto_id, // ID fictício para identificação
                                                                            'imagem_url' => $thumbUrl
                                                                        ];
                                                                    }
                                                                }
                                                                ?>

                                                                <!-- Seção da Thumb -->
                                                                <?php if ($thumb): ?>
                                                                    <div class="col-12">
                                                                        <h6 class="mb-3 fw-bold text-primary">
                                                                            <i class="ti ti-photo"></i> Imagem Principal (Thumb)
                                                                        </h6>
                                                                        <div class="d-flex justify-content-start">
                                                                            <div class="imagem-card position-relative" 
                                                                                data-imagem-id="<?= $thumb['id'] ?>"
                                                                                data-imagem-url="<?= htmlspecialchars($thumb['imagem_url']) ?>">
                                                                                <div class="card shadow-sm border rounded" style="width: max-content;">
                                                                                    <!-- Badge THUMB -->
                                                                                    <div class="position-absolute top-0 start-0 m-2" style="z-index: 10;">
                                                                                        <span class="badge bg-primary">THUMB</span>
                                                                                    </div>
                                                                                    
                                                                                    <img src="<?= htmlspecialchars($thumb['imagem_url']) ?>?t=<?= time() ?>"
                                                                                        class="card-img-top rounded mx-auto d-block p-2 pb-0"
                                                                                        alt="Thumb do Produto"
                                                                                        style="width: 120px; height: 120px; object-fit: cover;">
                                                                                    
                                                                                    <div class="card-body text-center pt-2 px-2 p-2">
                                                                                        <button type="button" class="btn btn-danger w-100 btn-sm excluir-thumb" 
                                                                                                data-imagem-id="<?= $thumb['id'] ?>">
                                                                                            <i class="ti ti-trash"></i> Remover Thumb
                                                                                        </button>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <hr class="my-4">
                                                                    </div>
                                                                <?php endif; ?>

                                                                <!-- Seção das Demais Imagens -->
                                                                <?php if (!empty($imagensNormais)): ?>
                                                                    <div class="col-12">
                                                                        <h6 class="mb-3 fw-bold">
                                                                            <i class="ti ti-photo-plus"></i> Demais Imagens 
                                                                            <?php if (!$thumb): ?>
                                                                                <small class="text-muted">(Clique na estrela para definir como thumb)</small>
                                                                            <?php endif; ?>
                                                                        </h6>
                                                                    </div>
                                                                    
                                                                    <?php foreach ($imagensNormais as $imagem): ?>
                                                                        <div class="col-6 col-sm-6 col-md-4 col-lg-auto d-flex justify-content-center imagem-card"
                                                                            data-imagem-id="<?= $imagem['id'] ?>"
                                                                            data-imagem-url="<?= htmlspecialchars($imagem['imagem_url']) ?>">
                                                                            <div class="card shadow-sm border rounded position-relative" style="width: max-content;">
                                                                                <!-- Estrela para gerar thumb -->
                                                                                <div class="position-absolute top-0 end-0 m-2" style="z-index: 10;">
                                                                                    <button type="button" class="btn btn-light btn-sm rounded-circle p-1 gerar-thumb" 
                                                                                            data-imagem-url="<?= htmlspecialchars($imagem['imagem_url']) ?>"
                                                                                            title="Gerar thumb desta imagem"
                                                                                            style="width: 30px; height: 30px; background-color: rgba(255,255,255,0.9); border: 1px solid #ddd;">
                                                                                        <i class="ti ti-star" style="font-size: 14px; color: #666;"></i>
                                                                                    </button>
                                                                                </div>
                                                                                
                                                                                <img src="<?= htmlspecialchars($imagem['imagem_url']) ?>"
                                                                                    class="card-img-top rounded mx-auto d-block p-2 pb-0"
                                                                                    alt="Imagem do Produto"
                                                                                    style="width: 100px; height: 100px; object-fit: cover;">
                                                                                
                                                                                <div class="card-body text-center pt-2 px-2 p-2">
                                                                                    <button type="button" class="btn btn-danger w-100 btn-sm excluir-imagem">
                                                                                        <i class="ti ti-trash"></i> Excluir
                                                                                    </button>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php endforeach; ?>
                                                                <?php elseif (!$thumb): ?>
                                                                    <div class="col-12">
                                                                        <p class="alert alert-warning">Nenhuma imagem encontrada para este produto.</p>
                                                                    </div>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12 mt-3">
                                                    <div class="card mb-4">
                                                        <div class="card-header d-flex justify-content-between align-items-center">
                                                            <h5 class="mb-0 card-title">Outros</h5>
                                                        </div>

                                                        <div class="card-body mt-3">
                                                            <div class="row">
                                                                <div class="col-6">
                                                                    <div class="mb-3 col ecommerce-select2-dropdown">
                                                                        <label class="form-label" for="sensivel">Conteúdo sensível?</label>

                                                                        <select class="form-select" name="sensivel" id="sensivel" aria-label="Floating label select example">
                                                                            <option value="0" <?php echo ($produto['sensivel'] == '0') ? 'selected' : ''; ?>>Não</option>
                                                                            <option value="1" <?php echo ($produto['sensivel'] == '1') ? 'selected' : ''; ?>>Sim</option>
                                                                        </select>
                                                                    </div>
                                                                </div>

                                                                <div class="col-6">
                                                                    <div class="mb-3 col ecommerce-select2-dropdown">
                                                                        <label for="categoria_interna" class="form-label">Categoria interna</label>
                                                                        <select class="form-select select2" name="categoria_interna" id="categoria_interna">
                                                                            <option value="" disabled>Selecione uma categoria interna</option> <!-- Placeholder -->
                                                                            <?php
                                                                            $get_InternalCategory = $pdo->prepare("SELECT * FROM categorias WHERE plataforma = 'geral' ORDER BY titulo DESC");
                                                                            $get_InternalCategory->execute();

                                                                            while ($rowInternalCategory = $get_InternalCategory->fetch(PDO::FETCH_ASSOC)) {
                                                                                $categoria_interna = $rowInternalCategory['titulo'];
                                                                                $selected = ($produto['categoria_interna'] == $categoria_interna) ? 'selected' : '';
                                                                            ?>
                                                                                <option value="<?php echo $categoria_interna; ?>" <?php echo $selected; ?>>
                                                                                    <?php echo $categoria_interna; ?>
                                                                                </option>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12 mt-3">
                                                    <div class="card mb-4">
                                                        <div class="card-header d-flex justify-content-between align-items-center">
                                                            <h5 class="mb-0 card-title">Valores</h5>
                                                        </div>
                                                        <div class="card-body mt-3">
                                                            <div class="row">
                                                                <div class="col-6">
                                                                    <label for="preco_custo_forn" class="form-label">Preco de Custo</label>

                                                                    <div class="input-group">
                                                                        <span class="input-group-text" id="basic-addon1">R$</span>
                                                                        <input type="text" class="form-control" step="0.01" name="preco_custo_forn" id="preco_custo_fornEdt" value="<?= htmlspecialchars($produto['preco_custo_forn']) ?>" placeholder="Preco de Custo">
                                                                    </div>
                                                                </div>

                                                                <div class="col-6">
                                                                    <label for="preco_custo" class="form-label">Preco de Venda</label>

                                                                    <div class="input-group">
                                                                        <span class="input-group-text" id="basic-addon1">R$</span>
                                                                        <input type="text" class="form-control" step="0.01" name="preco_custo" id="preco_custoEdt" value="<?= htmlspecialchars($produto['preco_custo']) ?>" placeholder="Preco de Custo">
                                                                    </div>
                                                                </div>

                                                                <div class="col-6">
                                                                    <label for="preco_minimo" class="form-label">Preço Mínimo (Opcional)</label>

                                                                    <div class="input-group">
                                                                        <span class="input-group-text" id="basic-addon1">R$</span>
                                                                        <input type="text" class="form-control" step="0.01" name="preco_minimo" id="preco_minimoEdt" value="<?= htmlspecialchars($produto['preco_minimo'] ?? '') ?>" placeholder="Preço Mínimo">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="col-12 mt-3">
                                                    <div class="card">
                                                        <div class="card-body">
                                                            <div class="w-100 mb-2 d-flex  <?= $produto['is_filho'] == 1 ? 'justify-content-end' : 'justify-content-between' ?> flex-row gap-2">
                                                                
                                                                <?php if ($produto['is_filho'] == 0) { ?>
                                                                    <button type="button" class="btn disabled btn-danger" disabled id="deletar-imagens" data-produto-id="<?= $produto['id'] ?>">Deletar produto</button>
                                                                <?php } ?>

                                                                <button id="salvar-produto" type="button" class="btn btn-primary">Salvar Alterações</button>
                                                            </div>

                                                            <small class="mt-2 text-danger">Botão deletar desabilitado temporariamente, caso precise inativar o produto zere o estoque do mesmo.</small>
                                                        </div>
                                                    </div>
                                                </div>

                                            </form>

                                            <script>
                                                $(document).ready(function() {
                                                    // Enviar imagem via AJAX
                                                    $('#btnEnviarImagem').on('click', function() {
                                                        var formData = new FormData();
                                                        var arquivos = $('#imagem')[0].files; // Captura todos os arquivos selecionados

                                                        // Verificar se há arquivos selecionados
                                                        if (arquivos.length === 0) {
                                                            Swal.fire({
                                                                icon: 'warning',
                                                                title: 'Atenção',
                                                                text: 'Por favor, escolha pelo menos uma imagem.',
                                                            });
                                                            return;
                                                        }

                                                        // Adicionar os arquivos ao FormData
                                                        $.each(arquivos, function(i, arquivo) {
                                                            formData.append('imagem[]', arquivo); // O nome 'imagem[]' indica que são múltiplos arquivos
                                                        });

                                                        formData.append('produto_id', '<?= $produto_id ?>'); // Adiciona o ID do produto para associar as imagens

                                                        $.ajax({
                                                            url: '../../assets/ajax/produtos/adicionar_imagens.php', // Substitua pelo caminho do seu script de upload
                                                            type: 'POST',
                                                            data: formData,
                                                            contentType: false,
                                                            processData: false,
                                                            success: function(response) {
                                                                response = JSON.parse(response);
                                                                if (response.status === 'success') {
                                                                    // Adiciona cada imagem à galeria
                                                                    $.each(response.imagens, function(i, imagem) {
                                                                        var imagemHTML = `
                                                                            <div class="col-6 col-sm-6 col-md-4 col-lg-auto d-flex justify-content-center imagem-card" data-imagem-id="${imagem.id}" data-imagem-url="${imagem.url}">
                                                                                <div class="card shadow-sm border rounded" style="width: max-content;">
                                                                                    <img src="${imagem.url}" class="card-img-top rounded mx-auto d-block p-2 pb-0" alt="Imagem do Produto" style="width: 100px; height: 100px; object-fit: cover;">
                                                                                    <div class="card-body text-center pt-2 px-2 p-2">
                                                                                        <button type="button" class="btn btn-danger w-100 btn-sm excluir-imagem">Excluir</button>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        `;
                                                                        $('.row.g-4').append(imagemHTML); // Adicionar nova imagem à galeria
                                                                    });
                                                                    $('#imagem').val(''); // Limpar o campo de arquivo
                                                                } else {
                                                                    Swal.fire({
                                                                        icon: 'error',
                                                                        title: 'Erro',
                                                                        text: 'Erro ao enviar as imagens: ' + response.message,
                                                                    });
                                                                }
                                                            },
                                                            error: function() {
                                                                Swal.fire({
                                                                    icon: 'error',
                                                                    title: 'Erro',
                                                                    text: 'Erro no envio das imagens. Tente novamente.',
                                                                });
                                                            }
                                                        });
                                                    });
                                                });

                                                // Exclusão de imagem via AJAX
                                            </script>

                                        <?php
                                        } else {
                                            echo 'Você não tem permissão para editar produtos!';
                                        }

                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>

        <div class="modal fade" id="modalVariacao" aria-labelledby="modalVariacaoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalVariacaoLabel">Adicionar Variação</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                    </div>
                    <div class="modal-body">
                        <form id="formVariacao" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="tipo_variacao" class="form-label">Tipo de Variação</label>
                                <select class="form-select" id="tipo_variacao" name="tipo_variacao" required>
                                    <option value="">Selecione o tipo</option>
                                    <option value="cor">Cor</option>
                                    <option value="tamanho">Tamanho</option>
                                    <option value="voltagem">Voltagem</option>
                                </select>
                            </div>
                            <div class="mb-3" id="grupo_valor_variacao">
                                <label for="variacao_valor" class="form-label" id="label_valor_variacao">Valor</label>
                                <div id="wrapper_cor_variacao" class="d-none">
                                    <select class="form-select" id="select_cor_variacao" name="valor_cor">
                                        <option value="">Selecione a cor</option>
                                        <?php foreach ($coresDisponiveis as $cor): ?>
                                            <option value="<?= htmlspecialchars($cor['nome']) ?>"><?= htmlspecialchars($cor['nome']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <select class="form-select d-none" id="select_voltagem_variacao" name="valor_voltagem">
                                    <option value="">Selecione a voltagem</option>
                                    <option>110V</option>
                                    <option>127V</option>
                                    <option>220V</option>
                                    <option>Bivolt</option>
                                    <option>Outros</option>
                                </select>
                                <input type="text" class="form-control d-none" id="input_tamanho_variacao" name="valor_tamanho" placeholder="Digite o tamanho (ex: 38, GG, P, etc)">
                            </div>
                            <div class="mb-3">
                                <label for="variacao_preco" class="form-label">Preço</label>
                                <input type="number" step="0.01" class="form-control" id="variacao_preco" name="preco" required>
                            </div>
                            <div class="mb-3">
                                <label for="variacao_estoque" class="form-label">Estoque</label>
                                <input type="number" class="form-control" id="variacao_estoque" name="estoque" required>
                            </div>
                            <div class="mb-3">
                                <label for="variacao_sku" class="form-label">SKU</label>
                                <input type="text" class="form-control" id="variacao_sku" name="sku" readonly>
                            </div>
                            <div class="mb-3">
                                <label for="variacao_imagem" class="form-label">Imagem da Variação</label>
                                <input type="file" class="form-control" id="variacao_imagem" name="imagem" accept="image/*" required>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="button" class="btn btn-primary" id="btnSalvarVariacao">Adicionar</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Layout wrapper -->

    </div>


    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>

    <script>
        // Impede remoção do sufixo de variação no título
        document.addEventListener('DOMContentLoaded', function() {
            const tituloInput = document.getElementById('titulo');
            const produtoIsVariacao = <?= ($produto['is_filho'] == 1 ? 'true' : 'false') ?>;
            let sufixoVaria = '';
            const MAX_TITULO = 60;
            if (produtoIsVariacao) {
                // Detecta sufixo do título (ex: ' - Cor: Amarelo' ou ' - Tamanho: 38')
                const match = tituloInput.value.match(/( - (Cor|Tamanho): .+)$/i);
                if (match) {
                    sufixoVaria = match[1];
                }
            }
            if (produtoIsVariacao && sufixoVaria) {
                // Limita digitação para não ultrapassar o total permitido
                tituloInput.addEventListener('input', function(e) {
                    let base = this.value.replace(/( - (Cor|Tamanho): .+)?$/i, '');
                    // Limita base para que base+sufixo <= 60
                    let maxBase = MAX_TITULO - sufixoVaria.length;
                    if (base.length > maxBase) {
                        base = base.substring(0, maxBase);
                    }
                    // Não mostra sufixo durante digitação
                    this.value = base;
                });
                // Ao sair do campo, restaura sufixo corretamente
                tituloInput.addEventListener('blur', function(e) {
                    let base = this.value.replace(/( - (Cor|Tamanho): .+)?$/i, '');
                    let maxBase = MAX_TITULO - sufixoVaria.length;
                    if (base.length > maxBase) {
                        base = base.substring(0, maxBase);
                    }
                    if (base.trim() === '') {
                        this.value = '';
                    } else {
                        this.value = base + sufixoVaria;
                    }
                });
                // Impede colar sem o sufixo e já limita
                tituloInput.addEventListener('paste', function(e) {
                    e.preventDefault();
                    let paste = (e.clipboardData || window.clipboardData).getData('text');
                    let base = paste.replace(/( - (Cor|Tamanho): .+)?$/i, '');
                    let maxBase = MAX_TITULO - sufixoVaria.length;
                    if (base.length > maxBase) {
                        base = base.substring(0, maxBase);
                    }
                    if (base.trim() === '') {
                        this.value = '';
                    } else {
                        this.value = base + sufixoVaria;
                    }
                });
                // Ao enviar o formulário, garante o sufixo e o limite
                const form = tituloInput.closest('form');
                if (form) {
                    form.addEventListener('submit', function(e) {
                        let base = tituloInput.value.replace(/( - (Cor|Tamanho): .+)?$/i, '');
                        let maxBase = MAX_TITULO - sufixoVaria.length;
                        if (base.length > maxBase) {
                            base = base.substring(0, maxBase);
                        }
                        if (base.trim() === '') {
                            tituloInput.value = '';
                        } else {
                            tituloInput.value = base + sufixoVaria;
                        }
                    });
                }
            } else {
                // Para produtos normais, só limita a 60 caracteres
                tituloInput.setAttribute('maxlength', MAX_TITULO);
            }
        });
    </script>

    <script>
        // Função para trocar campo valor conforme tipo de variação
        document.addEventListener('DOMContentLoaded', function() {
            const tipoSelect = document.getElementById('tipo_variacao');
            const selectCor = document.getElementById('select_cor_variacao');
            const wrapperCor = document.getElementById('wrapper_cor_variacao');
            const selectVoltagem = document.getElementById('select_voltagem_variacao');
            const inputTamanho = document.getElementById('input_tamanho_variacao');
            const labelValor = document.getElementById('label_valor_variacao');
            const skuInput = document.getElementById('variacao_sku');
            const skuBase = "<?= htmlspecialchars($produto['sku']) ?>";

            // Inicializar Select2 para cores
            $(selectCor).select2({
                dropdownParent: $('#modalVariacao'),
                tags: true,
                placeholder: "Selecione ou digite uma nova cor",
                allowClear: true,
                theme: 'bootstrap-5',
                width: '100%'
            });

            // Atualizar SKU quando Select2 mudar
            $(selectCor).on('change', function() {
                atualizarSKU();
            });

            function atualizarCamposValor() {
                if (tipoSelect.value === 'cor') {
                    wrapperCor.classList.remove('d-none');
                    selectCor.required = true;
                    selectVoltagem.classList.add('d-none');
                    selectVoltagem.required = false;
                    inputTamanho.classList.add('d-none');
                    inputTamanho.required = false;
                    labelValor.textContent = 'Cor';
                } else if (tipoSelect.value === 'tamanho') {
                    wrapperCor.classList.add('d-none');
                    selectCor.required = false;
                    selectVoltagem.classList.add('d-none');
                    selectVoltagem.required = false;
                    inputTamanho.classList.remove('d-none');
                    inputTamanho.required = true;
                    labelValor.textContent = 'Tamanho';
                } else if (tipoSelect.value === 'voltagem') {
                    wrapperCor.classList.add('d-none');
                    selectCor.required = false;
                    selectVoltagem.classList.remove('d-none');
                    selectVoltagem.required = true;
                    inputTamanho.classList.add('d-none');
                    inputTamanho.required = false;
                    labelValor.textContent = 'Voltagem';
                } else {
                    wrapperCor.classList.add('d-none');
                    selectCor.required = false;
                    selectVoltagem.classList.add('d-none');
                    selectVoltagem.required = false;
                    inputTamanho.classList.add('d-none');
                    inputTamanho.required = false;
                    labelValor.textContent = 'Valor';
                }
                atualizarSKU();
            }

            function atualizarSKU() {
                let tipo = tipoSelect.value;
                let valor = '';
                if (tipo === 'cor') {
                    valor = $(selectCor).val();
                } else if (tipo === 'tamanho') {
                    valor = inputTamanho.value;
                } else if (tipo === 'voltagem') {
                    valor = selectVoltagem.value;
                }
                if (tipo && valor) {
                    skuInput.value = skuBase + '_VAR_' + valor.replace(/\s+/g, '').toUpperCase();
                } else {
                    skuInput.value = '';
                }
            }

            tipoSelect.addEventListener('change', atualizarCamposValor);
            selectVoltagem.addEventListener('change', atualizarSKU);
            inputTamanho.addEventListener('input', atualizarSKU);

            // Inicializa campos ao abrir modal
            $('#modalVariacao').on('show.bs.modal', function() {
                tipoSelect.value = '';
                $(selectCor).val('').trigger('change');
                selectVoltagem.value = '';
                inputTamanho.value = '';
                skuInput.value = '';
                atualizarCamposValor();
            });
        });
    </script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
    <script src="../../assets/js/yampi-image-manager.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />

    <script>
        // Inicialize o select2 com tema Bootstrap 5.3
        $(document).ready(function() {
            $('#categoria_interna').select2({
                theme: 'bootstrap-5', // Use o tema do Bootstrap 5
                placeholder: "Selecione uma categoria interna", // Placeholder para o campo
                allowClear: true // Permite limpar a seleção
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#vendas').DataTable({
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese.json"
                },
                "paging": false,
                "responsive": true,
                "searching": false
            });
        });

        function limitarTexto(texto, limite) {
            return texto.length > limite ? texto.substring(0, limite) + '...' : texto;
        }


        $(document).ready(function() {
            // Função para excluir a imagem via AJAX
            $(".excluir-imagem").on("click", function() {
                // Encontra o card da imagem mais próximo
                var imagemCard = $(this).closest(".imagem-card");
                // Obtém os atributos de ID e URL da imagem
                var imagemId = imagemCard.data("imagem-id");
                var imagemUrl = imagemCard.data("imagem-url");

                // Verifica se as variáveis estão sendo corretamente obtidas
                if (!imagemId || !imagemUrl) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Informações da imagem não encontradas.',
                    });
                    return;
                }

                // SweetAlert para confirmar exclusão
                Swal.fire({
                    title: 'Tem certeza?',
                    text: 'Você tem certeza que deseja excluir esta imagem?',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Sim, excluir!',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Requisição AJAX para exclusão
                        $.ajax({
                            url: '../../assets/ajax/produtos/excluir_imagem.php',
                            type: 'POST',
                            data: {
                                id: imagemId,
                                imagem_url: imagemUrl
                            },
                            success: function(response) {
                                response = response.trim(); // Remove espaços em branco
                                if (response === "sucesso") {
                                    // Remove o card da imagem
                                    imagemCard.remove();
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Imagem excluída',
                                        text: 'A imagem foi excluída com sucesso!',
                                    });
                                } else {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Erro',
                                        text: 'Erro ao excluir a imagem. Por favor, tente novamente.',
                                    });
                                }
                            },
                            error: function() {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro',
                                    text: 'Ocorreu um erro ao excluir a imagem. Verifique sua conexão ou tente novamente.',
                                });
                            }
                        });
                    }
                });
            });





            // Função para salvar o produto via AJAX
            $("#salvar-produto").on("click", function() {
                // Crie um objeto FormData a partir do formulário existente
                var formData = new FormData($("#formProduto")[0]);

                // Captura a ordem atual das imagens (baseado no atributo data-imagem-id)
                // Exclui a thumb da ordenação
                var ordemImagens = [];
                $("#imagem-container .imagem-card").each(function() {
                    var imagemId = $(this).data("imagem-id");
                    // Só incluir na ordenação se não for thumb
                    if (imagemId && imagemId.toString().indexOf('thumb_') !== 0) {
                        ordemImagens.push(imagemId); // Adiciona o ID da imagem ao array
                    }
                });

                // Adiciona a ordem das imagens ao FormData
                formData.append("ordem_imagens", JSON.stringify(ordemImagens)); // Serializa o array para enviar ao backend


                // Coleta apenas os atributos que já existem no banco (tem data-atributo-db-id)
                // Inclui tanto INPUTs quanto SELECTs
                var atributos = {};
                $('input[id^="atributo_"], select[id^="atributo_"]').each(function() {
                    var dbId = $(this).data('atributo-db-id');
                    var atributoId = $(this).attr('id').replace('atributo_', '');
                    var valor = $(this).val();
                    
                    // Se tem dbId, atualiza atributo existente
                    if (dbId) {
                        atributos[dbId] = valor;
                        console.log(`Atualizando atributo DB ID ${dbId}: ${atributoId} = ${valor}`);
                    } 
                    // Se não tem dbId mas tem valor, é um novo atributo
                    else if (valor && valor.trim() !== '') {
                        // Marca como novo com prefixo "new_"
                        atributos['new_' + atributoId] = valor;
                        console.log(`Novo atributo ${atributoId} = ${valor}`);
                    }
                });
                formData.append("atributos", JSON.stringify(atributos));

                // Envia o AJAX
                $.ajax({
                    url: '../../assets/ajax/produtos/atualizar_produto.php', // A URL para o script de salvar o produto
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        if (response.trim() === "sucesso") {
                            Swal.fire({
                                icon: 'success',
                                title: 'Produto atualizado com sucesso!',
                                showConfirmButton: false,
                                timer: 1500
                            }).then(() => {
                                window.location.href = window.location.href;
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro ao atualizar produto',
                                text: response.trim(),
                                showConfirmButton: true
                            });
                        }
                    },
                    error: function() {
                        // SweetAlert de erro no AJAX
                        Swal.fire({
                            icon: 'error',
                            title: 'Ocorreu um erro ao salvar o produto.',
                            showConfirmButton: true
                        });
                    }
                });
            });


        });


        $(document).on("click", "#deletar-imagens", function(event) {
            event.preventDefault(); // Impede o comportamento padrão de envio

            const produtoId = $(this).data("produto-id");

            Swal.fire({
                title: 'Tem certeza?',
                text: "Isso excluirá permanentemente o produto!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sim, deletar!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '../../assets/ajax/produtos/deletar_produto.php',
                        type: 'POST',
                        data: {
                            produto_id: produtoId
                        },
                        success: function(response) {
                            const res = JSON.parse(response);

                            if (res.status === 'success') {
                                Swal.fire({
                                    icon: 'success',
                                    title: res.message,
                                    showConfirmButton: false,
                                    timer: 1500
                                }).then(() => {
                                    window.location.href = '/dash/gerenciar_produtos';
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro',
                                    text: res.message,
                                    showConfirmButton: true
                                });
                            }
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro no servidor',
                                text: 'Não foi possível excluir as imagens.',
                                showConfirmButton: true
                            });
                        }
                    });
                }
            });
        });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Inicializar Sortable.js no container de imagens
            var imagemContainer = document.getElementById("imagem-container");

            // Criar Sortable APENAS para elementos que NÃO são thumb
            var elementosArrastaveis = imagemContainer.querySelectorAll('.imagem-card:not([data-imagem-id*="thumb_"])');
            
            Sortable.create(imagemContainer, {
                animation: 150,
                draggable: ".imagem-card:not([data-imagem-id*='thumb_'])", // APENAS não-thumbs
                filter: ".imagem-card[data-imagem-id*='thumb_']", // Excluir thumbs COMPLETAMENTE
                onEnd: function(event) {
                    // Capturar a nova ordem das imagens (excluindo thumbs)
                    var ordemImagens = [];
                    document.querySelectorAll("#imagem-container .imagem-card").forEach(function(card) {
                        var imagemId = card.dataset.imagemId;
                        // Só incluir na ordenação se não for thumb
                        if (imagemId && imagemId.indexOf('thumb_') !== 0) {
                            ordemImagens.push(imagemId); 
                        }
                    });

                    // Enviar a nova ordem ao backend
                    atualizarOrdemImagens(ordemImagens);
                },
            });

            // BLOQUEIO ABSOLUTO - Interceptar QUALQUER tentativa de drag na thumb
            imagemContainer.addEventListener('dragstart', function(event) {
                if (event.target.closest('[data-imagem-id*="thumb_"]')) {
                    event.preventDefault();
                    event.stopImmediatePropagation();
                    return false;
                }
            }, true);

            // Bloquear mousedown que pode iniciar drag (incluindo nos botões)
            imagemContainer.addEventListener('mousedown', function(event) {
                var thumbElement = event.target.closest('[data-imagem-id*="thumb_"]');
                if (thumbElement) {
                    // Se for botão, permitir o clique mas bloquear drag
                    if (event.target.closest('button, .btn')) {
                        event.target.addEventListener('dragstart', function(e) {
                            e.preventDefault();
                            e.stopImmediatePropagation();
                            return false;
                        });
                    } else {
                        // Se não for botão, bloquear tudo
                        event.preventDefault();
                        event.stopImmediatePropagation();
                        return false;
                    }
                }
            }, true);

            // Bloquear especificamente drag nos botões da thumb
            document.addEventListener('dragstart', function(event) {
                if (event.target.closest('[data-imagem-id*="thumb_"] button, [data-imagem-id*="thumb_"] .btn')) {
                    event.preventDefault();
                    event.stopImmediatePropagation();
                    return false;
                }
            }, true);

            // Função para atualizar a ordem das imagens no backend
            function atualizarOrdemImagens(ordemImagens) {
                $.ajax({
                    url: "../../assets/ajax/produtos/atualizar_ordem_imagens.php", // Crie este arquivo PHP no backend
                    type: "POST",
                    data: {
                        ordem_imagens: JSON.stringify(ordemImagens)
                    },

                    error: function() {
                        console.log('Erro ao atualizar a ordem das imagens.');
                    },
                });
            }
        });
    </script>

    <script>
        // Função para renderizar lista de variações
        function renderizarVariacoes(variacoes) {
            const lista = document.getElementById('variacoes-lista');
            lista.innerHTML = '';
            if (!variacoes || variacoes.length === 0) {
                lista.innerHTML = '<div class="text-muted">Nenhuma variação cadastrada.</div>';
                return;
            }
            variacoes.forEach(function(variacao, idx) {
                const col = document.createElement('div');
                col.className = 'col-12 col-md-6';
                col.innerHTML = `
                    <div class="card border shadow-sm mb-2">
                        <div class="card-body p-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <strong>${variacao.nome}</strong> - ${variacao.valor}<br>
                                    <small>Preço: R$ ${parseFloat(variacao.preco).toFixed(2)} | Estoque: ${variacao.estoque} | SKU: ${variacao.sku || '-'} </small>
                                </div>
                                <button class="btn btn-danger btn-sm btnRemoverVariacao" data-id="${variacao.id}"><i class="bi bi-trash"></i></button>
                            </div>
                        </div>
                    </div>
                `;
                lista.appendChild(col);
            });
        }

        // Adicionar variação
        $(document).on('click', '#btnSalvarVariacao', function() {
            var form = $('#formVariacao')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            var formData = new FormData(form);
            formData.append('produto_id', '<?= $produto_id ?>');
            formData.append('produto_pai_id', '<?= $_GET['id'] ?>');
            $.ajax({
                url: '../../assets/ajax/produtos/adicionar_variacao.php',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function(res) {
                    if (res.success) {
                        $('#modalVariacao').modal('hide');
                        $('#formVariacao')[0].reset();
                        Swal.fire({
                            icon: 'success',
                            text: 'Variação adicionada com sucesso!',
                            timer: 1200,
                            showConfirmButton: false
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            text: res.message || 'Erro ao adicionar variação.'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        text: 'Erro ao adicionar variação.'
                    });
                }
            });
        });

        // Remover variação
        $(document).on('click', '.btnRemoverVariacao', function() {
            var id = $(this).data('id');
            Swal.fire({
                title: 'Remover variação?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Sim, remover',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '../../assets/ajax/produtos/remover_variacao.php',
                        type: 'POST',
                        data: {
                            id: id
                        },
                        dataType: 'json',
                        success: function(res) {
                            if (res.success) {
                                Swal.fire({
                                    icon: 'success',
                                    text: 'Variação removida!',
                                    timer: 1000,
                                    showConfirmButton: false
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    text: res.message || 'Erro ao remover variação.'
                                });
                            }
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                text: 'Erro ao remover variação.'
                            });
                        }
                    });
                }
            });
        });
    </script>

    <script>
        // Variáveis para busca de categoria Shopee
        let shopeeSearchTimeout;
        let shopeeCurrentRequest;
        let shopeeDropdownInstance;

        // Variável para ID do produto em edição
        const produtoIdEdit = <?= json_encode($produto_id ?? null) ?>;

        // Seletores para os elementos
        const nomeProdutoShopeeInput = document.getElementById('nome_produto_shopee');
        const shopeeSearchDropdown = document.getElementById('shopee-search-dropdown');
        const shopeeErrorMessage = document.getElementById('shopee-error-message');
        const shopeeInfoDiv = document.getElementById('shopee-info');
        const categoriaHiddenInput = document.getElementById('categoria_shopee');
        const categoriaDisplayInput = document.getElementById('categoria_shopee_display');
        const atributosUl = document.getElementById('atributos-obrigatorios');

        // Initialize Bootstrap dropdown quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            if (nomeProdutoShopeeInput) {
                shopeeDropdownInstance = new bootstrap.Dropdown(nomeProdutoShopeeInput);

                // Event listener para o input de busca
                nomeProdutoShopeeInput.addEventListener('input', function() {
                    const query = this.value.trim();

                    // Clear previous timeout
                    clearTimeout(shopeeSearchTimeout);

                    // Cancel previous request
                    if (shopeeCurrentRequest) {
                        shopeeCurrentRequest.abort();
                    }

                    if (query.length < 2) {
                        shopeeDropdownInstance.hide();
                        return;
                    }

                    // Show loading
                    showShopeeLoading();

                    // Set timeout for search
                    shopeeSearchTimeout = setTimeout(() => {
                        searchShopeeCategories(query);
                    }, 500); // 500ms delay
                });

                // Prevent dropdown from closing when typing
                nomeProdutoShopeeInput.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape') {
                        shopeeDropdownInstance.hide();
                    }
                });
            }

            // Adicionar sincronização bidirecional dos campos de nome
            const nomeProdutoInput = document.getElementById('nome_produto');
            if (nomeProdutoInput && nomeProdutoShopeeInput) {
                // Quando nome_produto_shopee é alterado, mas não está em busca de categoria
                let isTypingForSearch = false;

                nomeProdutoShopeeInput.addEventListener('input', function() {
                    if (!isTypingForSearch) {
                        // Sincroniza com nome_produto apenas se não estiver fazendo busca ativa
                        nomeProdutoInput.value = this.value;
                    }
                });

                // Quando nome_produto é alterado, sempre sincroniza com nome_produto_shopee
                nomeProdutoInput.addEventListener('input', function() {
                    const valor = this.value;
                    nomeProdutoShopeeInput.value = valor;

                    // Disparar busca automática de categoria Shopee se tiver valor
                    if (valor.trim().length >= 2) {
                        console.log('Iniciando busca automática de categoria Shopee para:', valor); // Debug

                        // Clear previous timeout
                        clearTimeout(shopeeSearchTimeout);

                        // Cancel previous request
                        if (shopeeCurrentRequest) {
                            shopeeCurrentRequest.abort();
                        }

                        // Show loading
                        showShopeeLoading();

                        // Set timeout for search
                        shopeeSearchTimeout = setTimeout(() => {
                            searchShopeeCategories(valor.trim());
                        }, 500); // 500ms delay
                    } else if (valor.trim().length === 0) {
                        // Limpar busca se campo estiver vazio
                        shopeeDropdownInstance.hide();
                        clearShopeeSelection();
                    }
                });
            }
        });

        function searchShopeeCategories(keyword) {
            // Create FormData for POST request
            const formData = new FormData();
            formData.append('keyword', keyword);
            formData.append('all_pages', '0'); // Primeira página apenas

            // Create AJAX request
            shopeeCurrentRequest = new XMLHttpRequest();
            shopeeCurrentRequest.open('POST', '../../get-produtos/api.php', true);

            shopeeCurrentRequest.onload = function() {
                if (this.status === 200) {
                    try {
                        const response = JSON.parse(this.responseText);

                        if (response.success) {
                            showShopeeResults(response.data.categories);
                            hideShopeeError();
                        } else {
                            showShopeeError(response.error);
                            shopeeDropdownInstance.hide();
                        }
                    } catch (e) {
                        showShopeeError('Erro ao processar resposta do servidor');
                        shopeeDropdownInstance.hide();
                    }
                } else {
                    showShopeeError('Erro na requisição: ' + this.status);
                    shopeeDropdownInstance.hide();
                }
                shopeeCurrentRequest = null;
            };

            shopeeCurrentRequest.onerror = function() {
                showShopeeError('Erro de conexão');
                shopeeDropdownInstance.hide();
                shopeeCurrentRequest = null;
            };

            shopeeCurrentRequest.onabort = function() {
                shopeeCurrentRequest = null;
            };

            shopeeCurrentRequest.send(formData);
        }

        function showShopeeLoading() {
            shopeeSearchDropdown.innerHTML = `
                <li class="dropdown-item-text p-3 text-center">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="spinner-border spinner-border-sm text-primary me-2" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <span class="text-muted">Buscando categorias Shopee...</span>
                    </div>
                </li>
            `;
            shopeeDropdownInstance.show();
        }

        function showShopeeResults(categories) {
            if (!categories || categories.length === 0) {
                shopeeSearchDropdown.innerHTML = `
                    <li class="dropdown-item-text p-3 text-center text-muted fst-italic">
                        <i class="bi bi-search me-2"></i>
                        Nenhuma categoria encontrada
                    </li>
                `;

                // Preenche o campo nome_produto_shopee com o título do produto e dispara evento para buscar atributos

                tituloProduto = document.getElementById('titulo').value;
                nomeProdutoShopeeInput.value = tituloProduto;
                // Dispara evento de input para acionar a busca de categorias/atributos
                nomeProdutoShopeeInput.dispatchEvent(new Event('input', {
                    bubbles: true
                }));

                shopeeDropdownInstance.show();
                return;
            }

            let html = '';
            categories.forEach((category, index) => {
                const fullTitle = category.full_title || category.name;
                const pathText = category.full_path_text || '';

                html += `
                    <li>
                        <a class="dropdown-item py-3" href="#" onclick="selectShopeeCategory('${category.id}', '${escapeHtml(fullTitle)}'); return false;">
                            <div class="fw-semibold text-dark mb-1">
                                <i class="bi bi-tag-fill text-primary me-2"></i>
                                ${escapeHtml(category.name)}
                            </div>
                            ${pathText ? `<div class="small text-muted mb-1"><i class="bi bi-arrow-right me-1"></i>${escapeHtml(pathText)}</div>` : ''}
                            <div class="small">
                                <span class="badge bg-secondary">ID: ${category.id}</span>
                            </div>
                        </a>
                    </li>
                `;
            });

            shopeeSearchDropdown.innerHTML = html;
            shopeeDropdownInstance.show();

            // Auto-selecionar a primeira categoria por padrão (após delay para melhor UX)
            if (categories.length > 0) {
                console.log('Auto-selecionando primeira categoria:', categories[0].name); // Debug log
                const firstCategory = categories[0];
                const fullTitle = firstCategory.full_title || firstCategory.name;

                // Delay de 1 segundo para o usuário ver as opções antes da seleção automática
                setTimeout(() => {
                    selectShopeeCategory(firstCategory.id, fullTitle, true); // true = auto-selecionada
                }, 1000);
            }
        }

        function selectShopeeCategory(categoryId, categoryName, isAutoSelected = false) {
            console.log('Categoria selecionada:', categoryId, categoryName, isAutoSelected ? '(auto-selecionada)' : '(manual)'); // Debug log

            // Fill the hidden input with ID
            categoriaHiddenInput.value = categoryId;

            // Update display input with category name
            categoriaDisplayInput.value = categoryName;

            // Update search input with category name
            nomeProdutoShopeeInput.value = categoryName;

            // Hide dropdown
            shopeeDropdownInstance.hide();

            // Hide error if any
            hideShopeeError();

            // Se foi auto-selecionada, adicionar indicação visual temporária
            if (isAutoSelected) {
                categoriaDisplayInput.style.backgroundColor = '#e3f2fd';
                categoriaDisplayInput.setAttribute('title', 'Categoria selecionada automaticamente - clique para pesquisar outras opções');
                setTimeout(() => {
                    categoriaDisplayInput.style.backgroundColor = '';
                    categoriaDisplayInput.removeAttribute('title');
                }, 3000);
            }

            // Buscar atributos da categoria selecionada
            console.log('Iniciando busca de atributos para categoria:', categoryId); // Debug log
            // Verifica se estamos em modo de edição (se produtoIdEdit existe)
            if (typeof produtoIdEdit !== 'undefined' && produtoIdEdit) {
                buscarAtributosShopeeEdit(categoryId, produtoIdEdit);
            } else {
                buscarAtributosShopee(categoryId);
            }
        }

        function clearShopeeSelection() {
            categoriaHiddenInput.value = '';
            categoriaDisplayInput.value = '';
            nomeProdutoShopeeInput.value = '';
            shopeeDropdownInstance.hide();
            hideShopeeError();

            // Limpar atributos
            document.querySelectorAll('.atributo-dinamico-group').forEach(el => el.remove());
            if (atributosUl) atributosUl.innerHTML = '';
        }

        function showShopeeError(message) {
            const errorText = document.getElementById('shopee-error-text');
            errorText.textContent = message;
            shopeeErrorMessage.classList.remove('d-none');
        }

        function hideShopeeError() {
            shopeeErrorMessage.classList.add('d-none');
        }

        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }

        // Manter as funções existentes de busca de atributos
        async function buscarAtributosShopee(categoryId) {
            console.log('Buscando atributos para categoria:', categoryId); // Debug log

            // Remover campos de atributos dinâmicos antigos
            document.querySelectorAll('.atributo-dinamico-group').forEach(el => el.remove());
            if (atributosUl) atributosUl.innerHTML = 'Buscando atributos Shopee...'; // Feedback

            try {
                // Ajustar o caminho para o script PHP
                const response = await fetch('../../assets/ajax/plataformas/shopee/fetch_attributes_edit.php?category_id=' +
                    encodeURIComponent(categoryId) + '&produto_id=<?= $produto_id ?>');

                console.log('Response completo: ' + response); // Debug log
                console.log('Resposta da API de atributos:', response.status, response.ok); // Debug log

                if (!response.ok) {
                    throw new Error('Erro de rede (' + response.status + ') ao buscar atributos Shopee.');
                }
                const data = await response.json();

                console.log('Dados de atributos recebidos:', data); // Debug log

                if (data.error && data.error !== '') {
                    let errorMsg = data.message || data.error;
                    if (data.http_code) errorMsg += ` (HTTP ${data.http_code})`;
                    if (data.request_id) errorMsg += ` (Request ID: ${data.request_id})`;
                    throw new Error('Erro API Shopee: ' + errorMsg);
                }

                if (!data.response || !data.response.attribute_list) {
                    console.warn("Resposta inesperada de buscar_atributos.php:", data);
                    throw new Error('Resposta inesperada do servidor (atributos Shopee).');
                }

                console.log('Gerando campos para', data.response.attribute_list.length, 'atributos'); // Debug log
                gerarCamposAtributosShopee(data.response.attribute_list);

            } catch (error) {
                console.error("Erro ao buscar atributos Shopee:", error);
                if (atributosUl) atributosUl.innerHTML = `<li style="color:red;">Erro: ${error.message}</li>`;
                else if (shopeeInfoDiv) {
                    // Se UL não existir, mostra erro na div principal
                    const errorP = document.createElement('p');
                    errorP.style.color = 'red';
                    errorP.textContent = `Erro ao buscar atributos: ${error.message}`;
                    // Limpa a div antes de adicionar o erro
                    while (shopeeInfoDiv.firstChild) {
                        if (shopeeInfoDiv.firstChild.nodeName !== 'P' || !shopeeInfoDiv.firstChild.textContent.includes(
                                'Atributos')) {
                            // Não remove o título <p><strong>Atributos...</strong></p>
                            shopeeInfoDiv.removeChild(shopeeInfoDiv.firstChild);
                        }
                    }
                    shopeeInfoDiv.appendChild(errorP);
                }
            }
        }

        function gerarCamposAtributosShopee(atributos) {
            console.log('Gerando campos de atributos. Total de atributos:', atributos.length); // Debug log
            console.log('Atributos recebidos:', atributos); // Debug log

            if (atributosUl) atributosUl.innerHTML = ''; // Limpa o status de carregamento
            // Remover campos de atributos DINÂMICOS antigos (incluindo o de homologação)
            document.querySelectorAll('.atributo-dinamico-group').forEach(el => el.remove());

            let homologacaoEncontrado = false;
            let fabricanteEncontrado = false;
            let atributosObrigatoriosRenderizados = 0;

            if (!shopeeInfoDiv) {
                console.error('shopeeInfoDiv não encontrado!'); // Debug log
                return; // Sai se a div principal não existe
            }

            // 1. Iterar para encontrar e criar os campos específicos (Homologação e Fabricante)
            atributos.forEach(attr => {
                let campoEspecificoCriado = false;
                let divGroup;

                // Verifica Homologação
                if (attr.attribute_id === 101197) {
                    homologacaoEncontrado = true;
                    divGroup = document.createElement('div');
                    divGroup.className = 'form-group atributo-dinamico-group mb-3'; // Classe e margem

                    const label = document.createElement('label');
                    label.className = 'form-label';
                    label.textContent = `${attr.display_attribute_name || attr.original_attribute_name}:`;
                    label.htmlFor = `attribute_${attr.attribute_id}`;

                    const input = document.createElement('input');
                    input.type = 'text';
                    input.className = 'form-control';
                    input.id = `attribute_${attr.attribute_id}`;
                    input.name = `attributes[${attr.attribute_id}]`; // Nome correto para POST
                    // input.required = attr.is_mandatory;

                    // >> ADICIONAR input hidden para o NOME do atributo
                    const hiddenNameInput = document.createElement('input');
                    hiddenNameInput.type = 'hidden';
                    hiddenNameInput.name = `attributes_meta[${attr.attribute_id}][name]`; // Nome para metadados
                    hiddenNameInput.value = attr.display_attribute_name || attr.original_attribute_name ||
                        ''; // Pegar o nome real

                    divGroup.appendChild(label);
                    divGroup.appendChild(input);
                    divGroup.appendChild(hiddenNameInput); // Adiciona o input hidden
                    campoEspecificoCriado = true;
                }
                // Verifica Fabricante
                else if (attr.attribute_id === 101237) {
                    fabricanteEncontrado = true;
                    divGroup = document.createElement('div');
                    divGroup.className = 'form-group atributo-dinamico-group mb-3';

                    const label = document.createElement('label');
                    label.className = 'form-label d-none';
                    label.textContent = `${attr.display_attribute_name || attr.original_attribute_name}:`;
                    label.htmlFor = `attribute_${attr.attribute_id}`;

                    const input = criarCampoInputAtributoShopee(attr);

                    // >> DEFINIR VALOR PADRÃO PARA FABRICANTE <<
                    input.value = '<?php echo Config::get('site_configs.name'); ?>'; // Pré-preenche o campo
                    input.classList.add('d-none');


                    // >> ADICIONAR input hidden para o NOME do atributo
                    const hiddenNameInput = document.createElement('input');
                    hiddenNameInput.type = 'hidden';
                    hiddenNameInput.name = `attributes_meta[${attr.attribute_id}][name]`;
                    hiddenNameInput.value = attr.display_attribute_name || attr.original_attribute_name || '';

                    divGroup.appendChild(label);
                    divGroup.appendChild(input);
                    divGroup.appendChild(hiddenNameInput); // Adiciona o input hidden
                    // Se for COMBO_BOX, pode precisar adicionar o datalist ao DOM
                    if (input.tagName === 'INPUT' && input.getAttribute('list')) {
                        const dataListId = input.getAttribute('list');
                        const dataList = document.getElementById(dataListId);
                        if (dataList) divGroup.appendChild(dataList); // Anexa ao grupo
                    }
                    campoEspecificoCriado = true;
                }

                // Insere o campo específico criado no DOM, dentro de shopeeInfoDiv
                if (campoEspecificoCriado && divGroup) {
                    shopeeInfoDiv.appendChild(divGroup);
                }
            });

            // 2. Iterar novamente para criar campos para OUTROS atributos obrigatórios
            const outrosAtributosObrigatorios = atributos.filter(
                attr => attr.is_mandatory &&
                attr.attribute_id !== 101197 &&
                attr.attribute_id !== 101237
            );

            if (outrosAtributosObrigatorios.length > 0) {
                outrosAtributosObrigatorios.forEach(attr => {
                    atributosObrigatoriosRenderizados++;
                    const divGroup = document.createElement('div');
                    divGroup.className = 'form-group atributo-dinamico-group mb-3';

                    const label = document.createElement('label');
                    label.className = 'form-label';
                    label.textContent =
                        `${attr.display_attribute_name || attr.original_attribute_name}: *`; // Indica obrigatório
                    label.htmlFor = `attribute_${attr.attribute_id}`;

                    const input = criarCampoInputAtributoShopee(attr);
                    if (input) input.required = true; // Garante que seja marcado como obrigatório

                    // >> ADICIONAR input hidden para o NOME do atributo
                    const hiddenNameInput = document.createElement('input');
                    hiddenNameInput.type = 'hidden';
                    hiddenNameInput.name = `attributes_meta[${attr.attribute_id}][name]`;
                    hiddenNameInput.value = attr.display_attribute_name || attr.original_attribute_name || '';

                    divGroup.appendChild(label);
                    divGroup.appendChild(input);
                    divGroup.appendChild(hiddenNameInput); // Adiciona o input hidden
                    // Se for COMBO_BOX, anexa datalist ao grupo
                    if (input.tagName === 'INPUT' && input.getAttribute('list')) {
                        const dataListId = input.getAttribute('list');
                        const dataList = document.getElementById(dataListId);
                        if (dataList) divGroup.appendChild(dataList);
                    }

                    shopeeInfoDiv.appendChild(divGroup);
                });
            }

            // Mensagem se nenhum atributo for encontrado/renderizado
            if (!homologacaoEncontrado && !fabricanteEncontrado && atributosObrigatoriosRenderizados === 0) {
                const noAttrMsg = document.createElement('p');
                noAttrMsg.className = 'text-muted atributo-dinamico-group';
                noAttrMsg.textContent =
                    'Nenhum atributo obrigatório ou específico (Homologação, Fabricante) encontrado para esta categoria Shopee.';
                shopeeInfoDiv.appendChild(noAttrMsg);
            }
        }

        // Função auxiliar para criar diferentes tipos de input baseados no atributo Shopee
        function criarCampoInputAtributoShopee(attr) {
            let input;
            const inputId = `attribute_${attr.attribute_id}`;
            const inputName = `attributes[${attr.attribute_id}]`; // Nome para POST

            switch (attr.input_type) {
                case 'DROP_DOWN':
                    input = document.createElement('select');
                    input.className = 'form-select';
                    input.id = inputId;
                    input.name = inputName;
                    // input.required = attr.is_mandatory; // Será definido no loop principal se for obrigatório

                    const defaultOption = document.createElement('option');
                    defaultOption.value = '';
                    defaultOption.textContent = '-- Selecione --';
                    defaultOption.disabled = true;
                    defaultOption.selected = true;
                    input.appendChild(defaultOption);

                    if (attr.attribute_value_list) {
                        attr.attribute_value_list.forEach(val => {
                            const option = document.createElement('option');
                            option.value = val.value_id; // Enviar value_id
                            option.textContent = val.original_value_name || `ID: ${val.value_id}`;
                            input.appendChild(option);
                        });
                    }
                    break;

                case 'MULTIPLE_SELECT_COMBO_BOX': // Tratar como select múltiplo se necessário
                case 'COMBO_BOX':
                    input = document.createElement('input');
                    input.type = 'text';
                    input.className = 'form-control';
                    input.id = inputId;
                    input.name = inputName;
                    // input.required = attr.is_mandatory;
                    input.setAttribute('list', `datalist_${attr.attribute_id}`);

                    // Cria o datalist, mas não anexa aqui, será anexado no loop principal
                    const dataList = document.createElement('datalist');
                    dataList.id = `datalist_${attr.attribute_id}`;
                    if (attr.attribute_value_list) {
                        attr.attribute_value_list.forEach(val => {
                            const option = document.createElement('option');
                            option.value = val.original_value_name || `ID: ${val.value_id}`;
                            dataList.appendChild(option);
                        });
                    }
                    // Anexa ao body para garantir que esteja disponível
                    // document.body.appendChild(dataList);
                    break;

                case 'TEXT_FILED': // Corrigido typo potencial (FIELD)
                case 'TEXT_FIELD':
                default:
                    input = document.createElement('input');
                    input.type = 'text';
                    input.className = 'form-control';
                    input.id = inputId;
                    input.name = inputName;
                    // input.required = attr.is_mandatory;
                    break;
            }
            return input;
        }

        // --- Função para BUSCAR ATRIBUTOS SHOPEE EDIT (escopo global) ---
        async function buscarAtributosShopeeEdit(categoryId, prodId) {
            document.querySelectorAll('#shopee-info-edit .atributo-dinamico-group').forEach(el => el.remove());
            const atributosContainer = document.getElementById('atributos-obrigatorios-edit');
            if (!atributosContainer) return;

            try {
                const formData = new FormData();
                formData.append('category_id', categoryId);
                formData.append('produto_id', prodId);

                const response = await fetch('../../assets/ajax/plataformas/shopee/fetch_attributes_edit.php', {
                    method: 'POST',
                    body: formData
                });

                if (!response.ok) {
                    throw new Error('Erro de rede (' + response.status + ') ao buscar atributos Shopee.');
                }

                // Sempre insere o resultado no id 'atributos-obrigatorios-edit'
                let htmlResult = await response.text();
                if (!htmlResult || htmlResult.trim() === '') {
                    htmlResult = '<div class="text-muted">Não há atributos obrigatórios para a categoria.</div>';
                }
                // INSERE O RESULTADO NO CONTAINER
                atributosContainer.innerHTML = htmlResult;
                atributosContainer.classList.remove('d-none');

            } catch (error) {
                console.error("Erro ao buscar/processar atributos Shopee (Edit):", error);
                if (atributosContainer) atributosContainer.innerHTML = `<p style="color:red;">Erro ao carregar atributos Shopee: ${error.message}</p>`;
            }
        }
    </script>
    <!-- FIM NOVO SCRIPT -->

    <script>
        // Ao carregar a página, preenche o campo nome_produto_shopee de uma vez e dispara eventos para acionar a busca
        window.addEventListener('DOMContentLoaded', function() {
            var tituloInput = document.getElementById('categoria_shopee');
            var shopeeInput = document.getElementById('nome_produto_shopee');
            if (tituloInput && shopeeInput) {
                var valor = tituloInput.value;
                shopeeInput.value = valor;
                // Dispara eventos de input e keyup para acionar listeners
                shopeeInput.dispatchEvent(new Event('input', {
                    bubbles: true
                }));
                shopeeInput.dispatchEvent(new KeyboardEvent('keyup', {
                    bubbles: true,
                    key: ''
                }));
            }
        });
    </script>
    <script>
        // Force Zero handler (isolated)
        (function(){
            function checkForceStatusEditar(pid, cb){ $.get('', {get_force_status:1, produto_id:pid}, function(r){ cb(r); }, 'json').fail(function(){ cb({success:false}); }); }
            $(document).on('click','#btnForceZeroEditar', function(){
                const pid = '<?= htmlspecialchars($produto_id) ?>';
                const $btn = $(this);
                $btn.prop('disabled',true).text('Verificando...');
                checkForceStatusEditar(pid, function(status){
                    if(!status || !status.success){ $btn.prop('disabled',false).text('Forçar Zerar'); alert('Falha ao checar cooldown.'); return; }
                    if(!status.can_force){ $btn.prop('disabled',false).text('Forçar Zerar'); alert('Aguarde '+status.wait_minutes+' min para usar novamente.'); return; }
                    if(!confirm('Zerar estoque agora nas plataformas para produto '+pid+'?')){ $btn.prop('disabled',false).text('Forçar Zerar'); return; }
                    $btn.text('Iniciando...');
                    $.post('', {force_zero:1, produto_id:pid}, function(r){
                        if(r.success){ $btn.text('Executando...'); setTimeout(()=>{ $btn.prop('disabled',false).text('Forçar Zerar'); },4000); alert('Processo iniciado. Pode levar alguns minutos.'); }
                        else { alert(r.message||'Falha ao iniciar.'); $btn.prop('disabled',false).text('Forçar Zerar'); }
                    },'json').fail(()=>{ alert('Erro de rede.'); $btn.prop('disabled',false).text('Forçar Zerar'); });
                });
            });
        })();
    </script>
    
    <script>
        // Inicialização do Yampi Image Manager
        $(document).ready(function() {
            // Verificar se há produtos Yampi na sessão ou URL
            const urlParams = new URLSearchParams(window.location.search);
            const yamlProductId = urlParams.get('yampi_id') || '<?= isset($_GET["yampi_id"]) ? htmlspecialchars($_GET["yampi_id"]) : "" ?>';
            
            if (yamlProductId) {
                console.log('Produto Yampi detectado:', yamlProductId);
                
                // Adicionar classe para identificar plataforma Yampi
                $('#imagem-container').addClass('yampi-platform');
                
                // Definir ID do produto no gerenciador
                if (typeof setYampiProductId === 'function') {
                    setYampiProductId(yamlProductId);
                }
                
                // Substituir o Sortable padrão pelo do Yampi
                setTimeout(function() {
                    if (typeof yampiImageManager !== 'undefined') {
                        yampiImageManager.initializeSortable();
                    }
                }, 1000);
            }
        });
        
        // Hook para quando imagens forem carregadas via AJAX
        $(document).on('DOMNodeInserted', '#imagem-container .imagem-card', function() {
            const urlParams = new URLSearchParams(window.location.search);
            const yamlProductId = urlParams.get('yampi_id') || '<?= isset($_GET["yampi_id"]) ? htmlspecialchars($_GET["yampi_id"]) : "" ?>';
            
            if (yamlProductId && typeof yampiImageManager !== 'undefined') {
                // Reinicializar sortable quando novas imagens são adicionadas
                setTimeout(function() {
                    yampiImageManager.initializeSortable();
                }, 500);
            }
        });
    </script>

    <script>
        // Funcionalidades da Thumb
        $(document).ready(function() {
            // Gerar thumb a partir de uma imagem
            $(document).on('click', '.gerar-thumb', function() {
                const imagemUrl = $(this).data('imagem-url');
                const produtoId = '<?= $produto_id ?>';
                
                Swal.fire({
                    title: 'Gerar Thumb',
                    text: 'Deseja gerar uma thumb (400x400) desta imagem?',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Sim, gerar!',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        gerarThumb(imagemUrl, produtoId);
                    }
                });
            });

            // Excluir thumb
            $(document).on('click', '.excluir-thumb', function() {
                const imagemId = $(this).data('imagem-id');
                // Pegar a URL da imagem do container pai
                const imagemCard = $(this).closest('.imagem-card');
                const imagemUrl = imagemCard.data('imagem-url') || imagemCard.find('img').attr('src');
                
                Swal.fire({
                    title: 'Excluir Thumb',
                    text: 'Tem certeza que deseja remover a thumb do produto?',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sim, excluir!',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        excluirThumb(imagemId, imagemUrl);
                    }
                });
            });
        });

        // Função para gerar thumb
        function gerarThumb(imagemUrl, produtoId) {
            const loadingAlert = Swal.fire({
                title: 'Gerando Thumb...',
                text: 'Aguarde enquanto redimensionamos a imagem.',
                allowOutsideClick: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: '/assets/ajax/produtos/gerar_thumb.php',
                type: 'POST',
                data: {
                    imagem_url: imagemUrl,
                    produto_id: produtoId
                },
                dataType: 'text', // Mudar para text para capturar qualquer resposta
                success: function(data) {
                    loadingAlert.close();
                    
                    try {
                        // Tentar fazer parse do JSON
                        const response = JSON.parse(data);
                        
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Thumb Gerada!',
                                text: response.message || 'Thumb criada com sucesso.',
                                timer: 2000,
                                showConfirmButton: false
                            }).then(() => {
                                // Recarregar a seção de imagens
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message || 'Erro ao gerar thumb.'
                            });
                        }
                    } catch (e) {
                        // Se não conseguir fazer parse do JSON, mostrar resposta bruta
                        console.log('Resposta do servidor:', data);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro de formato!',
                            text: 'Resposta inválida do servidor. Verifique o console.'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    loadingAlert.close();
                    console.log('Erro AJAX:', xhr.responseText);
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro de conexão: ' + error
                    });
                }
            });
        }

        // Função para excluir thumb
        function excluirThumb(imagemId, imagemUrl) {
            const loadingAlert = Swal.fire({
                title: 'Removendo Thumb...',
                allowOutsideClick: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: '/assets/ajax/produtos/excluir_imagem.php',
                type: 'POST',
                data: {
                    imagem_id: imagemId,
                    imagem_url: imagemUrl,
                    is_thumb: true
                },
                dataType: 'json',
                success: function(response) {
                    loadingAlert.close();
                    
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Thumb Removida!',
                            text: 'Thumb removida com sucesso.',
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            // Recarregar a seção de imagens
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao remover thumb.'
                        });
                    }
                },
                error: function() {
                    loadingAlert.close();
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro de conexão ao remover thumb.'
                    });
                }
            });
        }
    </script>
</body>

</html>