<?php
session_start();
require '../../class/configClass.php';
require '../../vendor/autoload.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
require '../../class/pagarVendaUsuarioClass.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'] ?? null;
    $titulo = $_POST['titulo'] ?? null;
    $descricao = $_POST['descricao'] ?? null;
    $preco_custo = isset($_POST['preco_custo']) ? str_replace(',', '.', $_POST['preco_custo']) : null;
    $preco_minimo = isset($_POST['preco_minimo']) && $_POST['preco_minimo'] !== '' ? str_replace(',', '.', $_POST['preco_minimo']) : null;
    $preco_custo_forn = isset($_POST['preco_custo_forn']) ? str_replace(',', '.', $_POST['preco_custo_forn']) : null;
    $atributos = $_POST['atributos'] ?? null;
    $estoque = $_POST['estoque'] ?? null;
    $fornecedor_id = $_POST['fornecedor'] ?? null;
    $ordem_imagens = $_POST['ordem_imagens'] ?? null;

    $sku_fornecedor = $_POST['sku_fornecedor'] ?? null;
    $ncm = $_POST['ncm'] ?? null;
    $altura = $_POST['altura'] ?? null;
    $largura = $_POST['largura'] ?? null;
    $comprimento = $_POST['comprimento'] ?? null;

    $categoria_interna = $_POST['categoria_interna'] ?? null;
    $sensivel = $_POST['sensivel'] ?? null;

    $peso = $_POST['peso'] ?? null;
    $unidade = $_POST['unidade'] ?? null;

    $peso_completo = trim($peso . ' ' . $unidade); // Trim potential extra space if unit is empty

    $category_domain = $_POST['category_domain'] ?? null;
    $categoria_shopee = $_POST['categoria_shopee'] ?? null;

    if (!$id || empty($titulo) || empty($descricao) || empty($preco_custo) || empty($fornecedor_id)) {
        echo "Todos os campos obrigatórios devem ser preenchidos.";
        exit;
    }

    try {
        $pdo->beginTransaction();

        $sql = "UPDATE drophub_global.produtos SET 
                titulo = :titulo, 
                descricao = :descricao, 
                preco_custo = :preco_custo, 
                preco_minimo = :preco_minimo,
                preco_custo_forn = :preco_custo_forn, 
                estoque = :estoque, 
                sku_for = :sku_fornecedor, 
                ncm = :ncm, 
                altura = :altura, 
                largura = :largura, 
                comprimento = :comprimento, 
                peso = :peso_completo, 
                sensivel = :sensivel, 
                categoria_interna = :categoria_interna, 
                fornecedor = :fornecedor_id
            WHERE id = :id";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':titulo', $titulo, PDO::PARAM_STR);
        $stmt->bindParam(':descricao', $descricao, PDO::PARAM_STR);
        $stmt->bindParam(':preco_custo', $preco_custo, PDO::PARAM_STR);
        $stmt->bindParam(':preco_minimo', $preco_minimo, $preco_minimo === null ? PDO::PARAM_NULL : PDO::PARAM_STR);
        $stmt->bindParam(':preco_custo_forn', $preco_custo_forn, PDO::PARAM_STR);
        $stmt->bindParam(':estoque', $estoque, PDO::PARAM_INT);
        $stmt->bindParam(':sku_fornecedor', $sku_fornecedor, PDO::PARAM_STR);
        $stmt->bindParam(':ncm', $ncm, PDO::PARAM_INT);
        $stmt->bindParam(':altura', $altura, PDO::PARAM_INT);
        $stmt->bindParam(':largura', $largura, PDO::PARAM_INT);
        $stmt->bindParam(':comprimento', $comprimento, PDO::PARAM_INT);
        $stmt->bindParam(':peso_completo', $peso_completo, PDO::PARAM_STR);
        $stmt->bindParam(':sensivel', $sensivel, PDO::PARAM_STR);
        $stmt->bindParam(':categoria_interna', $categoria_interna, PDO::PARAM_STR);
        $stmt->bindParam(':fornecedor_id', $fornecedor_id, PDO::PARAM_INT);

        if (!$stmt->execute()) {
            throw new Exception("Erro ao atualizar os dados do produto.");
        }

        // Propaga atualização de estoque para todos os registros vinculados em produtos_cadastrados
        if ($estoque !== null && $estoque !== '') {
            $sql_pc = "UPDATE drophub_global.produtos_cadastrados SET estoque = :estoque WHERE produto_id = :produto_id";
            $stmt_pc = $pdo->prepare($sql_pc);
            if (!$stmt_pc->execute([':estoque' => $estoque, ':produto_id' => $id])) {
                throw new Exception("Erro ao atualizar estoque em produtos_cadastrados.");
            }
        }

        // Atualizar os atributos normais (se houver)
        if ($atributos) {
            $atributos_array = json_decode($atributos, true);
            if (is_array($atributos_array)) {
                foreach ($atributos_array as $id_atributo => $valor_atributo) {
                    // Verifica se é um novo atributo (prefixo "new_")
                    if (strpos($id_atributo, 'new_') === 0) {
                        // Novo atributo - INSERIR
                        $atributo_ml_id = str_replace('new_', '', $id_atributo);
                        
                        // Busca o nome do atributo (pode estar vazio, depois será preenchido)
                        $nome_atributo = $atributo_ml_id; // Fallback
                        
                        $sql_insert = "INSERT INTO drophub_global.produtos_atributos 
                                      (id_produto, id_atributo, nome_atributo, valor_atributo) 
                                      VALUES (:id_produto, :id_atributo, :nome_atributo, :valor_atributo)";
                        $stmt_insert = $pdo->prepare($sql_insert);
                        $stmt_insert->bindParam(':id_produto', $id, PDO::PARAM_STR);
                        $stmt_insert->bindParam(':id_atributo', $atributo_ml_id, PDO::PARAM_STR);
                        $stmt_insert->bindParam(':nome_atributo', $nome_atributo, PDO::PARAM_STR);
                        $stmt_insert->bindParam(':valor_atributo', $valor_atributo, PDO::PARAM_STR);
                        
                        if (!$stmt_insert->execute()) {
                            throw new Exception("Erro ao inserir novo atributo: " . $atributo_ml_id);
                        }
                    } else {
                        // Atributo existente - UPDATE
                        $sql_atributo = "UPDATE drophub_global.produtos_atributos 
                                        SET valor_atributo = :valor_atributo 
                                        WHERE id = :id";
                        $stmt_atributo = $pdo->prepare($sql_atributo);
                        $stmt_atributo->bindParam(':valor_atributo', $valor_atributo, PDO::PARAM_STR);
                        $stmt_atributo->bindParam(':id', $id_atributo, PDO::PARAM_INT);
                        
                        if (!$stmt_atributo->execute()) {
                            throw new Exception("Erro ao atualizar atributo ID: " . $id_atributo);
                        }
                    }
                }
                // Atualiza drophub_global_produtos
                $sql_global = "UPDATE drophub_global.produtos SET 
                titulo = :titulo, 
                descricao = :descricao, 
                preco_custo = :preco_custo, 
                preco_custo_forn = :preco_custo_forn, 
                estoque = :estoque, 
                sku_for = :sku_fornecedor, 
                ncm = :ncm, 
                altura = :altura, 
                largura = :largura, 
                comprimento = :comprimento, 
                peso = :peso_completo, 
                sensivel = :sensivel, 
                categoria_interna = :categoria_interna, 
                fornecedor = :fornecedor_id
            WHERE id = :id";
                $stmt_global = $pdo->prepare($sql_global);
                $stmt_global->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt_global->bindParam(':titulo', $titulo, PDO::PARAM_STR);
                $stmt_global->bindParam(':descricao', $descricao, PDO::PARAM_STR);
                $stmt_global->bindParam(':preco_custo', $preco_custo, PDO::PARAM_STR);
                $stmt_global->bindParam(':preco_custo_forn', $preco_custo_forn, PDO::PARAM_STR);
                $stmt_global->bindParam(':estoque', $estoque, PDO::PARAM_INT);
                $stmt_global->bindParam(':sku_fornecedor', $sku_fornecedor, PDO::PARAM_STR);
                $stmt_global->bindParam(':ncm', $ncm, PDO::PARAM_INT);
                $stmt_global->bindParam(':altura', $altura, PDO::PARAM_INT);
                $stmt_global->bindParam(':largura', $largura, PDO::PARAM_INT);
                $stmt_global->bindParam(':comprimento', $comprimento, PDO::PARAM_INT);
                $stmt_global->bindParam(':peso_completo', $peso_completo, PDO::PARAM_STR);
                $stmt_global->bindParam(':sensivel', $sensivel, PDO::PARAM_STR);
                $stmt_global->bindParam(':categoria_interna', $categoria_interna, PDO::PARAM_STR);
                $stmt_global->bindParam(':fornecedor_id', $fornecedor_id, PDO::PARAM_INT);
                if (!$stmt_global->execute()) {
                    throw new Exception("Erro ao atualizar os dados do produto na tabela drophub_global_produtos.");
                }
            }
        }

        // Atualizar/Inserir atributos Shopee (Nova Estrutura - Adaptado de adicionar_produtos.php)
        $submitted_shopee_attribute_ids = []; // Keep track of submitted attributes
        $shopeeAttributesInput = isset($_POST['attributes']) && is_array($_POST['attributes']) ? $_POST['attributes'] : [];

        if (!empty($shopeeAttributesInput)) {
            foreach ($shopeeAttributesInput as $attrId => $attrValue) {
                $validAttrId = filter_var($attrId, FILTER_VALIDATE_INT);
                // Sanitizar valor bruto (pode ser string ou array para multi-select, mas aqui esperamos string)
                $sanitizedAttrValue = is_array($attrValue) ? null : trim(htmlspecialchars($attrValue ?? ''));

                // Só processa se tiver ID válido e um valor (mesmo que seja '0' para selects não selecionados)
                if ($validAttrId !== false && $sanitizedAttrValue !== null) { // Não checa mais se é '' para permitir '0'
                    $submitted_shopee_attribute_ids[] = $validAttrId; // Track this ID

                    // Recuperar o NOME real do atributo enviado pelo JS/PHP
                    $attribute_name = isset($_POST['attributes_meta'][$validAttrId]['name'])
                        ? trim(htmlspecialchars($_POST['attributes_meta'][$validAttrId]['name']))
                        : "Atributo ID " . $validAttrId; // Fallback

                    // Determinar se o valor é um ID numérico (value_id) ou texto (original_value_name)
                    $isDigit = ctype_digit($sanitizedAttrValue);
                    $value_id_to_save = null; // Inicia como null
                    $original_value_name_to_save = null;
                    $attribute_value_to_save = null; // Manter sempre NULL como no adicionar_produtos
                    $value_unit_to_save = null; // Placeholder - buscar se necessário

                    // Tratar IDs específicos como texto se necessário (Ex: Homologação 101197)
                    if ($validAttrId === 101197 || $validAttrId === 101237 /* Fabricante */) {
                        $isDigit = false; // Força a tratar como texto
                    }

                    if ($isDigit) { // Assume ser um value_id de select
                        $value_id_to_save = intval($sanitizedAttrValue);
                        $original_value_name_to_save = null; // Forçar NULL como no adicionar_produtos
                    } else { // Assume ser um valor de texto livre
                        $value_id_to_save = 0; // Forçar 0 como no adicionar_produtos
                        $original_value_name_to_save = $sanitizedAttrValue;
                    }

                    // Check if attribute already exists for this product
                    $sql_check = "SELECT id FROM drophub_global.produtos_atributos_shopee WHERE id_produto = :id_produto AND attribute_id = :attribute_id";
                    $stmt_check = $pdo->prepare($sql_check);
                    $stmt_check->execute([
                        ':id_produto' => $id,
                        ':attribute_id' => $validAttrId
                    ]);
                    $exists = $stmt_check->fetchColumn(); // Pega o ID se existir, ou false

                    if ($exists) {
                        // Update existing attribute
                        $sql_update = "UPDATE drophub_global.produtos_atributos_shopee SET 
                                            attribute_name = :attribute_name, 
                                            attribute_value = :attribute_value, 
                                            value_id = :value_id, 
                                            original_value_name = :original_value_name, 
                                            value_unit = :value_unit
                                        WHERE id = :existing_id"; // Usar o ID existente para update
                        $stmt_update = $pdo->prepare($sql_update);
                        $stmt_update->execute([
                            ':attribute_name' => $attribute_name,
                            ':attribute_value' => $attribute_value_to_save,
                            ':value_id' => $value_id_to_save,
                            ':original_value_name' => $original_value_name_to_save,
                            ':value_unit' => $value_unit_to_save, // Placeholder
                            ':existing_id' => $exists // ID da linha existente
                        ]);
                        $lastAttributeId = $exists; // ID para a API global
                    } else {
                        // Insert new attribute
                        $sql_insert = "INSERT INTO drophub_global.produtos_atributos_shopee 
                                            (id_produto, attribute_id, attribute_name, attribute_value, value_id, original_value_name, value_unit) 
                                        VALUES 
                                            (:id_produto, :attribute_id, :attribute_name, :attribute_value, :value_id, :original_value_name, :value_unit)";
                        $stmt_insert = $pdo->prepare($sql_insert);
                        $stmt_insert->execute([
                            ':id_produto' => $id,
                            ':attribute_id' => $validAttrId,
                            ':attribute_name' => $attribute_name,
                            ':attribute_value' => $attribute_value_to_save,
                            ':value_id' => $value_id_to_save,
                            ':original_value_name' => $original_value_name_to_save,
                            ':value_unit' => $value_unit_to_save // Placeholder
                        ]);
                        $lastAttributeId = $pdo->lastInsertId(); // ID para a API global
                    }

                    // --- Chamada API Global ---
                    // Adapta os dados enviados para a API Global
                    $urlGlobal = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos_shopee.php";
                    $dataGlobal = json_encode([
                        "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                        'db_id' => $lastAttributeId, // Enviar ID do banco local se a API precisar
                        'id_produto' => $id,
                        'attribute_id' => $validAttrId,
                        'attribute_name' => $attribute_name,
                        'attribute_value' => $attribute_value_to_save,
                        'value_id' => $value_id_to_save,
                        'original_value_name' => $original_value_name_to_save,
                        'value_unit' => $value_unit_to_save
                    ]);

                    try {
                        $chGlobal = curl_init($urlGlobal);
                        curl_setopt_array($chGlobal, [
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_POST => true,
                            CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                            CURLOPT_POSTFIELDS => $dataGlobal,
                            CURLOPT_TIMEOUT => 10
                        ]);
                        // Não fazer echo da resposta aqui para não interferir no 'sucesso' final
                        curl_exec($chGlobal);
                        if (curl_errno($chGlobal)) {
                            error_log("Erro cURL API Global Atributo Shopee (ID: $validAttrId): " . curl_error($chGlobal));
                        }
                        curl_close($chGlobal);
                    } catch (Exception $e) {
                        error_log("Erro Exception API Global Atributo Shopee (ID: $validAttrId): " . $e->getMessage());
                    }
                    // --- Fim Chamada API Global ---

                } // Fim if $validAttrId
            } // Fim foreach
        } // Fim if !empty($shopeeAttributesInput)


        /* // Comentando Loop Antigo
        foreach ($_POST as $key => $value) {
            // ... (código antigo que procurava por shopee_attr_) ...
        }
        */


        // Atualiza a ordem das imagens
        if ($ordem_imagens) {
            $ordem_array = json_decode($ordem_imagens, true);
            if (is_array($ordem_array)) {
                foreach ($ordem_array as $index => $imagem_id) {
                    $sql_ordem = "UPDATE drophub_global.produtos_imagens SET ordem = :ordem WHERE id = :id AND produto_id = :produto_id";
                    $stmt_ordem = $pdo->prepare($sql_ordem);
                    $stmt_ordem->bindValue(':ordem', $index, PDO::PARAM_INT);
                    $stmt_ordem->bindValue(':id', $imagem_id, PDO::PARAM_STR);
                    $stmt_ordem->bindValue(':produto_id', $id, PDO::PARAM_INT);
                    $stmt_ordem->execute();
                }
            }
        }

        // Commit
        $pdo->commit();
        echo "sucesso";

        // Envia para API global (Consider moving this outside the transaction or ensuring it doesn't affect rollback)
        $url = "https://api-hom.codefly.site/api/v1/alteracao/produtos.php"; // Use a constant or config variable for the URL

        $data = json_encode([
            "id" => $id,
            "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed", // Consider storing token securely
            'sensivel' => $sensivel,
            'titulo' => $titulo,
            'qtd_vendido' => 0, // Is this always 0 on update?
            'descricao' => $descricao,
            'category_domain' => $category_domain,
            'categoria_interna' => $categoria_interna,
            'fornecedor' => $fornecedor_id,
            'sku_for' => $sku_fornecedor,
            'categoria_shopee' => $categoria_shopee,
            'preco_custo' => $preco_custo,
            'preco_custo_forn' => $preco_custo_forn,
            'estoque' => $estoque,
            'ncm' => $ncm,
            'altura' => $altura,
            'largura' => $largura,
            'comprimento' => $comprimento,
            'peso' => $peso_completo,
        ]);

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_TIMEOUT => 10 // Add a timeout for the API call
        ]);

        $api_response = curl_exec($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);

        // Optionally log API response/error
        // if ($curl_error) { error_log("API Global Error: " . $curl_error); }
        // else { error_log("API Global Response: " . $api_response); }
        // Don't echo the API response directly to the user unless intended
        // echo $api_response;


    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Erro ao atualizar produto ID $id: " . $e->getMessage()); // Log the error
        echo "Erro ao atualizar o produto. Por favor, tente novamente. Detalhes: " . $e->getMessage(); // Provide more specific feedback if possible/safe
    }
} else {
    http_response_code(405); // Method Not Allowed
    echo "Método não permitido.";
}
