<?php
session_start();
header('Content-Type: application/json');

require '../../../class/configClass.php';
Config::load('../../../config/config.php');
include_once('../../../conexao/conexao.php');
require '../../../class/user_refresh_token_shopee.php';

// Verifica se está logado
if (!isset($_SESSION['usuario']['email'])) {
    echo json_encode(['success' => false, 'error' => 'Usuário não logado']);
    exit();
}

try {
    $id_produto = $_GET['id_ml'] ?? $_GET['id_produto'] ?? '';
    $id_loja = $_GET['id_loja'] ?? '';
    
    if (empty($id_produto) || empty($id_loja)) {
        echo json_encode(['success' => false, 'error' => 'Dados insuficientes']);
        exit();
    }
    
    $user_id = $_SESSION['usuario']['id_usuario'];
    $whitelabel = Config::get('database.dbname');
    
    // Busca dados da loja
    $sql_loja = "SELECT * FROM drophub_global.usuarios_api_contas WHERE seller_id = :id_loja AND user_id = :user_id AND whitelabel = :whitelabel";
    $stmt_loja = $pdo->prepare($sql_loja);
    $stmt_loja->execute([':id_loja' => $id_loja, ':user_id' => $user_id, ':whitelabel' => $whitelabel]);
    $loja = $stmt_loja->fetch(PDO::FETCH_ASSOC);
    
    if (!$loja) {
        echo json_encode(['success' => false, 'error' => 'Loja não encontrada']);
        exit();
    }
    
    // Se não tem credenciais, retorna dados simulados
    if (empty($loja['access_token']) || empty($loja['client_id']) || empty($loja['client_secret'])) {
        echo json_encode([
            'success' => true,
            'imagens' => [], 
            'produto_info' => [
                'title' => 'Produto Shopee (sem API configurada)',
                'price' => 0,
                'stock' => 0
            ],
            'titulo' => 'Produto Shopee (sem API)',
            'preco' => 0,
            'estoque' => 0
        ]);
        exit();
    }
    
    // Tenta fazer refresh do token se necessário
    $tokenUpdater = new ShopeeTokenUpdaterUser($pdo, (int) $loja['client_id'], $loja['client_secret'], $loja['seller_id'], $loja['code']);
    $tokenUpdater->getAccessToken();

    
    // Busca novamente os dados da loja com token atualizado
    $stmt_loja->execute([':id_loja' => $id_loja, ':user_id' => $user_id]);
    $loja = $stmt_loja->fetch(PDO::FETCH_ASSOC);
    
    // Dados para API da Shopee
    $partner_id = $loja['client_id'];
    $partner_key = $loja['client_secret'];
    $access_token = $loja['access_token'];
    $shop_id = $loja['seller_id'];
    $timestamp = time();
    $item_id = $id_produto;
    
    // Endpoint para buscar detalhes do item
    $path = "/api/v2/product/get_item_base_info";
    $base_string = trim(trim($partner_id) . trim($path) . trim($timestamp) . trim($access_token) . trim($shop_id));
    $sign = hash_hmac('sha256', $base_string, $partner_key);
    
    // URL da API completa
    $uri = 'https://partner.shopeemobile.com/api/v2/product/get_item_base_info?item_id_list='.$item_id.'&need_complaint_policy=true&need_tax_info=true&partner_id=' . $partner_id . '&sign=' . $sign . '&timestamp=' . $timestamp . '&access_token=' . $access_token . '&shop_id=' . $shop_id;
    
    // Faz a requisição
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $uri,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
    ));
    
    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $curlError = curl_error($curl);
    curl_close($curl);
    
    // Debug logs
    error_log("SHOPEE API: URL: " . $uri);
    error_log("SHOPEE API: Base string: " . $base_string);
    error_log("SHOPEE API: Sign: " . $sign);
    error_log("SHOPEE API: HTTP Code: $httpCode");
    error_log("SHOPEE API: Response: " . substr($response, 0, 1000));
    
    if ($curlError) {
        echo json_encode(['success' => false, 'error' => 'Erro de conexão: ' . $curlError]);
        exit();
    }
    
    if ($httpCode == 200) {
        $data = json_decode($response, true);
        
        if (isset($data['response']['item_list']) && !empty($data['response']['item_list'])) {
            $item = $data['response']['item_list'][0];
            
            // Processa imagens
            $imagens = [];
            if (isset($item['image']['image_id_list'])) {
                foreach ($item['image']['image_id_list'] as $imageId) {
                    $imagens[] = [
                        'id' => $imageId,
                        'url' => "https://cf.shopee.com.br/file/{$imageId}"
                    ];
                }
            }
            
            echo json_encode([
                'success' => true,
                'imagens' => $imagens,
                'produto_info' => [
                    'title' => $item['item_name'] ?? '',
                    'price' => $item['price_info']['current_price'] ?? 0,
                    'stock' => $item['stock_info']['current_stock'] ?? 0,
                    'description' => $item['description'] ?? ''
                ],
                'titulo' => $item['item_name'] ?? '',
                'preco' => $item['price_info']['current_price'] ?? 0,
                'estoque' => $item['stock_info']['current_stock'] ?? 0
            ]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Produto não encontrado']);
        }
    } else {
        $data = json_decode($response, true);
        $errorMsg = $data['message'] ?? $data['error'] ?? "HTTP $httpCode";
        echo json_encode(['success' => false, 'error' => 'Erro da Shopee: ' . $errorMsg]);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Erro interno: ' . $e->getMessage()]);
}
?>
