<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

require '../../class/configClass.php';
require '../../vendor/autoload.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
// include_once('../../funcoes/general.php');

if (!isset($_GET['id'])) {
    echo json_encode(['error' => 'ID do produto não informado']);
    exit;
}

$id = $_GET['id'];

// Busca os dados principais do produto, incluindo todos os campos obrigatórios
$stmt = $pdo->prepare('SELECT p.id, p.titulo, p.descricao, p.categoria_ml, p.category_domain, p.id_cat_ml, p.tipo_anuncio, p.sku, p.codigo_universal, p.estoque, p.preco_custo, p.peso, p.ncm, p.altura, p.largura, p.comprimento, p.categoria_shopee, p.variacao_cor, p.variacao_tamanho, f.nome AS fornecedor_nome FROM drophub_global.produtos p INNER JOIN drophub_global.fornecedores f ON p.fornecedor = f.id WHERE p.id = ? LIMIT 1');
$stmt->execute([$id]);

$produto = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$produto) {
    echo json_encode(['error' => 'Produto não encontrado']);
    exit;
}

// Adiciona campos obrigatórios que não estão na tabela produtos
$produto['preco_calc_base'] = null;
$produto['loja_selecionada'] = null;
$produto['id_usuario'] = isset($_SESSION['usuario']['id_usuario']) ? $_SESSION['usuario']['id_usuario'] : null;
$produto['preco_sugerido'] = null;
$produto['client_id'] = null;
$produto['client_secret'] = null;
$produto['access_token'] = null;
$produto['refresh_token'] = null;
$produto['imagem_capa'] = null;
$produto['imagens'] = [];

// Busca atributos do produto
$stmtAttr = $pdo->prepare('SELECT nome_atributo, id_atributo, valor_atributo FROM drophub_global.produtos_atributos WHERE id_produto = ?');
$stmtAttr->execute([$id]);
$atributos = $stmtAttr->fetchAll(PDO::FETCH_ASSOC);
$produto['atributos'] = $atributos;

// Busca imagens do produto na tabela global
$stmtImg = $pdo->prepare('SELECT imagem_url FROM drophub_global.produtos_imagens WHERE produto_id = ?');
$stmtImg->execute([$id]);
$imagens = $stmtImg->fetchAll(PDO::FETCH_COLUMN);
$produto['imagens'] = $imagens;
// Adiciona imagem_capa
if (count($imagens) > 0) {
    $produto['imagem_capa'] = $imagens[0];
}


$produto['usuario'] = $_SESSION['usuario']['email'] ?? 'Desconhecido';


echo json_encode($produto);
exit;
