<?php
session_start();
date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

// Carrega traduções
$traducao = require '../../custom/translations/pt-br.php';


require '../../class/walletClass.php';
require '../../class/refresh_token_shopee.php';
require '../../class/getPlanosConfig.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';

require '../../class/usuariosApiContasbyUser.php';
require '../../class/getTokens.php';


// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

if ($_SESSION['usuario']['is_adm'] != '1') {
    header('Location: /dash/dashboard');
    exit();
}

$is_supplier = $_SESSION['usuario']['is_supplier'];
$id_usuario = $_SESSION['usuario']['id_usuario'];

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);

$whitelabel_prefixo = config::get('site_configs.prefixo');
?>


<!DOCTYPE html>
<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr"
    data-theme="theme-default" data-assets-path="../../assets/"
    data-template="vertical-menu-template-no-customizer-starter" >
<head>
<?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>"
                                    width="<?php echo Config::get('site_configs.icon_width'); ?>"
                                    height="<?php echo Config::get('site_configs.icon_height'); ?>"
                                    style="object-fit: contain;">
                            </span>
                            <span
                                class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>"
                                    width="<?php echo Config::get('site_configs.icon_width'); ?>"
                                    height="<?php echo Config::get('site_configs.icon_height'); ?>"
                                    style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme"
                    id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->

                

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="mt-3">
                                <div class="card border-none p-2 shadow-none rounded bg-transparent">

                                    <div class="col-12">
                                        <div class="card p-2">
                                            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                                                <h5 class="mb-0 card-title">Gerenciar Produtos</h5>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="card-body px-0">
                                        <form method="POST" class="w-100" enctype="multipart/form-data">
                                            <!-- Content wrapper -->
                                            <div class="content-wrapper">
                                                <!-- Content -->

                                                <div class="app-ecommerce">
                                                    <!-- Add Product -->
                                                    <div class="row">
                                                        <!-- First column-->
                                                        <div class="col-12 col-lg-8">

                                                            <div class="card mb-4">
                                                                <div
                                                                    class="card-header d-flex justify-content-between align-items-center">
                                                                    <h5 class="mb-0 card-title">Importar usando o
                                                                        Mercado Livre <small
                                                                            class="text-muted">[URL]</small></h5>
                                                                </div>
                                                                <div class="card-body mt-3">
                                                                    <form method="post" enctype="multipart/form-data">
                                                                        <input type="text" class="form-control"
                                                                            placeholder="https://produto.mercadolivre.com.br/MLB-2356315936-produto-ficticio..."
                                                                            id="product_id" name="product_id">

                                                                        <button type="button"
                                                                            class="btn float-end mt-2 btn-primary submit_button"
                                                                            id="processBtn" data-timeout="2000">
                                                                            <span id="buttonText">Buscar
                                                                                Informações</span>
                                                                        </button>

                                                                    </form>
                                                                </div>
                                                            </div>

                                                            <div class="card mb-4">
                                                                <div class="card-header">
                                                                    <h5 class="card-tile mb-0">Informações do produto
                                                                    </h5>
                                                                </div>


                                                                <div class="card-body mt-3">
                                                                    <div class="mb-3">
                                                                        <label class="form-label"
                                                                            for="ecommerce-product-name">Nome</label>
                                                                        <input type="text" maxlength="60"
                                                                            id="nome_produto"
                                                                            oninput="buscarCategoria()" name="titulo"
                                                                            placeholder="Nome do produto"
                                                                            class="form-control"
                                                                            aria-label="Nome do produto" />
                                                                    </div>
                                                                    <div class="row mb-3">
                                                                        <div class="col d-none">
                                                                            <label class="form-label"
                                                                                for="sku">SKU</label>
                                                                            <input type="text" class="form-control"
                                                                                disabled name="sku" id="sku"
                                                                                placeholder="SKU"
                                                                                aria-label="Product SKU" />
                                                                        </div>
                                                                        <div class="col">
                                                                            <label class="form-label"
                                                                                for="sku">Estoque</label>
                                                                            <input type="text" class="form-control"
                                                                                value="500" min="0" id="estoque"
                                                                                name="estoque"
                                                                                placeholder="Produtos em estoque"
                                                                                aria-label="Product SKU" />
                                                                        </div>
                                                                        <div class="col">
                                                                            <label class="form-label"
                                                                                for="codigo_universal">GTIN EAN</label>
                                                                            <div class="d-flex">
                                                                                <input type="text"
                                                                                    name="codigo_universal"
                                                                                    class="form-control codigo_universal gtinValid"
                                                                                    id="codigo_universal"
                                                                                    aria-label="Product barcode" />
                                                                                <div class="btn btn-light ms-2"
                                                                                    id="gerarCodigo"><i
                                                                                        class="ti ti-barcode"></i></div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row mb-3">
                                                                        <?php
                                                                        try {
                                                                            if ($is_supplier == 1) {
                                                                                $query = "SELECT id, nome FROM fornecedores WHERE id = :id_usuario";
                                                                                $stmt = $pdo->prepare($query);
                                                                                $stmt->bindValue(':id_usuario', pegaPrefixo() . $id_usuario, PDO::PARAM_STR);
                                                                            } else {
                                                                                $query = "SELECT id, nome FROM fornecedores";
                                                                                $stmt = $pdo->prepare($query);
                                                                            }
                                                                            $stmt->execute();
                                                                            $fornecedores = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                                                        } catch (PDOException $e) {
                                                                            echo "Erro de conexão: " . $e->getMessage();
                                                                        }
                                                                        ?>
                                                                        <div class="col">
                                                                            <label class="form-label"
                                                                                for="fornecedor">Fornecedor</label>
                                                                            <select required class="form-select"
                                                                                name="fornecedor" id="fornecedor">
                                                                                <option disabled value="">Selecione
                                                                                </option>
                                                                                <?php foreach ($fornecedores as $fornecedor): ?>
                                                                                    <option
                                                                                        value="<?= htmlspecialchars($fornecedor['id']) ?>">
                                                                                        <?= htmlspecialchars($fornecedor['nome']) ?>
                                                                                    </option>
                                                                                <?php endforeach; ?>
                                                                            </select>
                                                                        </div>
                                                                        <div class="col">
                                                                            <label class="form-label"
                                                                                for="sku_fornecedoru">Ref.
                                                                                Fornecedor</label>
                                                                            <input type="text" class="form-control"
                                                                                name="sku_fornecedor"
                                                                                id="sku_fornecedor"
                                                                                placeholder="sku fornecedor" />
                                                                        </div>
                                                                        <div class="col">
                                                                            <label class="form-label"
                                                                                for="ncm">NCM</label>
                                                                            <input type="text" maxlength="8"
                                                                                class="form-control" name="ncm" id="ncm"
                                                                                placeholder="NCM"
                                                                                oninput="this.value = this.value.replace(/[^0-9]/g, '')" />
                                                                        </div>
                                                                        <div class="col d-none">
                                                                            <label class="form-label"
                                                                                for="categoria_shopee">Categoria
                                                                                Shopee</label>
                                                                            <input type="text" class="form-control"
                                                                                required name="categoriaShopee"
                                                                                id="id_shopee"
                                                                                placeholder="categoria shopee" />
                                                                        </div>
                                                                    </div>
                                                                    <div class="row mb-3">
                                                                        <div class="row">
                                                                            <div class="col">
                                                                                <label class="form-label"
                                                                                    for="altura">Altura <small
                                                                                        class="text-muted">(cm)</small></label>
                                                                                <input type="number" max="999" min="1"
                                                                                    class="form-control" required
                                                                                    name="altura" id="altura"
                                                                                    placeholder="Altura do pacote" />
                                                                            </div>
                                                                            <div class="col">
                                                                                <label class="form-label"
                                                                                    for="largura">Largura <small
                                                                                        class="text-muted">(cm)</small></label>
                                                                                <input type="number" max="999" min="1"
                                                                                    class="form-control" required
                                                                                    name="largura" id="largura"
                                                                                    placeholder="Largura do pacote" />
                                                                            </div>
                                                                            <div class="col">
                                                                                <label class="form-label"
                                                                                    for="comprimento">Comprimento <small
                                                                                        class="text-muted">(cm)</small></label>
                                                                                <input type="number" max="999" min="1"
                                                                                    class="form-control" required
                                                                                    name="comprimento" id="comprimento"
                                                                                    placeholder="Comprimento do pacote" />
                                                                            </div>
                                                                        </div>
                                                                        <div class="mt-3 d-none">
                                                                            <label class="form-label"
                                                                                for="dimensoes">Dimensões</label>
                                                                            <input type="text" class="form-control"
                                                                                name="atributo_100942*label_AxLxC"
                                                                                id="dimensoes" readonly
                                                                                placeholder="Resultado: A x L x C">
                                                                        </div>
                                                                        <div class="mb-3 mt-3">
                                                                            <label class="form-label" for="peso">Peso do
                                                                                pacote</label>
                                                                            <div class="input-group mb-3">
                                                                                <input type="number" step="0.2"
                                                                                    max="999" class="form-control"
                                                                                    name="peso" id="peso"
                                                                                    placeholder="Digite o peso"
                                                                                    aria-label="Peso do pacote">
                                                                                <select class="form-select"
                                                                                    name="unidade" id="unidade"
                                                                                    aria-label="Selecionar unidade">
                                                                                    <option value="KG">KG</option>
                                                                                    <option value="G/GR">G</option>
                                                                                    <option value="CM">CM</option>
                                                                                    <option value="M">M</option>
                                                                                    <option value="Dozen">DZ</option>
                                                                                    <option value="Piece">PC</option>
                                                                                    <option value="Pack">PCT</option>
                                                                                    <option value="Set">CJ</option>
                                                                                    <option value="Box">CX</option>
                                                                                </select>
                                                                            </div>
                                                                            <input type="hidden" class="form-control"
                                                                                name="atributo_101029*label_Peso_Pacote"
                                                                                id="value_peso_pacote" readonly
                                                                                placeholder="Resultado">
                                                                        </div>
                                                                    </div>

                                                                    <!-- FIM VARIAÇÕES PRODUTO -->
                                                                    <div class="row mb-3">
                                                                        <div class="col">
                                                                            <label for="descricao">Descrição do
                                                                                produto</label>
                                                                            <textarea class="form-control"
                                                                                placeholder="Descrição do produto"
                                                                                style="height: 250px;" name="descricao"
                                                                                id="descricao" maxlength="5000"
                                                                                oninput="updateCounter()"></textarea>
                                                                            <small id="charCount">0/5000</small>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <script>
                                                                    // Lógica para adicionar/remover variações
                                                                    $(document).ready(function() {
                                                                        let variacaoIndex = 0;
                                                                        $('#adicionar_variacao').click(function() {
                                                                            variacaoIndex++;
                                                                            const html = `
                                                                                <div class="variacao-item border rounded p-3 mb-3" data-index="${variacaoIndex}">
                                                                                    <button type="button" class="btn btn-danger float-end btn-sm remover-variacao " title="Remover" style="margin-top: -30px; margin-right: -30px;"><span aria-hidden="true">&times;</span></button>
                                                                                    <div class="row g-2 align-items-end">
                                                                                        <div class="col-md-6 mb-2">
                                                                                            <label class="form-label mb-1">Tipo</label>
                                                                                            <select name="variacoes[${variacaoIndex}][tipo]" class="form-select tipo-variacao-select" data-index="${variacaoIndex}" required>
                                                                                                <option value="">Selecione</option>
                                                                                                <option value="Tamanho">Tamanho</option>
                                                                                                <option value="Cor">Cor</option>
                                                                                                <option value="Voltagem">Voltagem</option>
                                                                                            </select>
                                                                                        </div>
                                                                                        <div class="col-md-6 mb-2 valor-variacao-container" id="valor-variacao-container-${variacaoIndex}">
                                                                                            <label class="form-label mb-1">Valor</label>
                                                                                            <input type="text" name="variacoes[${variacaoIndex}][valor]" class="form-control valor-variacao-input" placeholder="Ex: M, G, Azul..." required>
                                                                                        </div>
                                                                                        <div class="col-md-4 mb-2">
                                                                                            <label class="form-label mb-1">Estoque</label>
                                                                                            <input type="number" name="variacoes[${variacaoIndex}][estoque]" class="form-control" min="0" placeholder="Estoque" required>
                                                                                        </div>
                                                                                        <div class="col-md-4 mb-2">
                                                                                            <label class="form-label mb-1">Preço de Venda</label>
                                                                                            <input type="text" name="variacoes[${variacaoIndex}][preco_custo]" class="form-control" placeholder="Preço de venda" required>
                                                                                        </div>
                                                                                        <div class="col-md-4 mb-2">
                                                                                            <label class="form-label mb-1">Imagem da Variação</label>
                                                                                            <input type="file" name="variacoes[${variacaoIndex}][imagem]" accept="image/*" class="form-control" required>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            `;
                                                                            $('#variacoes_container').append(html);
                                                                        });

                                                                        // Troca o input de valor conforme o tipo selecionado
                                                                        $(document).on('change', '.tipo-variacao-select', function() {
                                                                            const index = $(this).data('index');
                                                                            const tipo = $(this).val();
                                                                            const container = $(`#valor-variacao-container-${index}`);
                                                                            if (tipo === 'Cor') {
                                                                                const cores = [
                                                                                    'Vermelho', 'Azul', 'Verde', 'Amarelo', 'Preto', 'Branco', 'Cinza', 'Rosa', 'Laranja', 'Marrom', 'Roxo', 'Bege', 'Dourado', 'Prata', 'Nude', 'Outros'
                                                                                ];
                                                                                let selectHtml = `<label class="form-label mb-1">Valor</label><select name="variacoes[${index}][valor]" class="form-select valor-variacao-input" required>`;
                                                                                selectHtml += '<option value="">Selecione a cor</option>';
                                                                                cores.forEach(cor => {
                                                                                    selectHtml += `<option value="${cor}">${cor}</option>`;
                                                                                });
                                                                                selectHtml += '</select>';
                                                                                container.html(selectHtml);
                                                                            } else if (tipo === 'Voltagem') {
                                                                                const voltagens = [
                                                                                    '110V', '127V', '220V', 'Bivolt', 'Outros'
                                                                                ];
                                                                                let selectHtml = `<label class="form-label mb-1">Valor</label><select name="variacoes[${index}][valor]" class="form-select valor-variacao-input" required>`;
                                                                                selectHtml += '<option value="">Selecione a voltagem</option>';
                                                                                voltagens.forEach(voltagem => {
                                                                                    selectHtml += `<option value="${voltagem}">${voltagem}</option>`;
                                                                                });
                                                                                selectHtml += '</select>';
                                                                                container.html(selectHtml);
                                                                            } else if (tipo === 'Tamanho') {
                                                                                container.html(`<label class="form-label mb-1">Valor</label><input type="text" name="variacoes[${index}][valor]" class="form-control valor-variacao-input" placeholder="Ex: M, G, 38..." required>`);
                                                                            } else {
                                                                                container.html(`<label class="form-label mb-1">Valor</label><input type="text" name="variacoes[${index}][valor]" class="form-control valor-variacao-input" required>`);
                                                                            }
                                                                        });
                                                                    });
                                                                    // Remover variação
                                                                    $(document).on('click', '.remover-variacao',
                                                                        function() {
                                                                            $(this).closest(
                                                                                    '.variacao-item')
                                                                                .remove();
                                                                        });
                                                                </script>
                                                            </div>

                                                            <div class="card mb-4">
                                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                                    <h5 class="mb-0 card-title">Variações</h5>
                                                                </div>

                                                                <div class="card-body mt-3">
                                                                    <!-- INÍCIO VARIAÇÕES PRODUTO -->
                                                                    <div class="mb-4">
                                                                        <div id="variacoes_container">
                                                                            <!-- Variações serão adicionadas aqui -->
                                                                        </div>
                                                                        <button type="button" class="btn btn-outline-primary btn-sm mt-2" id="adicionar_variacao">Adicionar Variação</button>
                                                                        <small class="text-muted d-block mt-1">Exemplo: Tamanho, Cor, etc.</small>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <!-- Media -->
                                                            <div class="card mb-4">
                                                                <div
                                                                    class="card-header d-flex justify-content-between align-items-center">
                                                                    <h5 class="mb-0 card-title">Imagem</h5>
                                                                </div>
                                                                <div class="card-body">
                                                                    <div class="card-body">
                                                                        <div class="form-floating">
                                                                            <div class="row gap-2">

                                                                                <div class="p-2" id="imgs_container">
                                                                                    <div id="images_container">

                                                                                    </div>
                                                                                </div>

                                                                                <div id="img_preview"></div>

                                                                                <input type="hidden" name="produto_id"
                                                                                    id="produto_id">
                                                                                <input class="form-control" type="file"
                                                                                    id="formFileMultipleAdd"
                                                                                    name="imagens[]" id="imagens"
                                                                                    multiple accept="image/*">
                                                                                <small
                                                                                    class="text-secondary text-center"
                                                                                    id="formFileAddSmall">Mínimo:
                                                                                    500x500 pixels | Máximo:
                                                                                    1200x1200
                                                                                    pixels</small>

                                                                                <div id="img-info-add"></div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <!-- FIM Media -->

                                                            <!-- NOVA Seção para Categoria e Atributos Shopee (baseada em shopee_dynamic.php) -->
                                                            <div class="card mb-4">
                                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                                    <h5 class="mb-0 card-title">
                                                                        <i class="bi bi-search"></i>
                                                                        Categoria e Atributos Shopee
                                                                    </h5>
                                                                </div>
                                                                <div class="card-body mt-3">
                                                                    <!-- Search Input with Dropdown -->
                                                                    <div class="mb-4">
                                                                        <label for="nome_produto_shopee" class="form-label fw-semibold">
                                                                            Buscar Categoria Shopee
                                                                        </label>
                                                                        <div class="dropdown w-100">
                                                                            <input
                                                                                type="text"
                                                                                id="nome_produto_shopee"
                                                                                class="form-control form-control dropdown-toggle"
                                                                                placeholder="Digite para buscar categorias (ex: chinelo, camiseta, smartphone)..."
                                                                                autocomplete="off"
                                                                                data-bs-toggle="dropdown"
                                                                                data-bs-auto-close="false"
                                                                                required>
                                                                            <ul class="dropdown-menu w-100" id="shopee-search-dropdown" style="max-height: 400px; overflow-y: auto;">
                                                                                <!-- Dynamic content will be inserted here -->
                                                                            </ul>
                                                                        </div>
                                                                    </div>

                                                                    <!-- Error Alert -->
                                                                    <div id="shopee-error-message" class="alert alert-danger d-none" role="alert">
                                                                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                                                                        <span id="shopee-error-text"></span>
                                                                    </div>

                                                                    <!-- Result Input -->
                                                                    <div class="mb-3 d-none">
                                                                        <label for="id_shopee" class="form-label fw-semibold">
                                                                            <i class="bi bi-tag me-2"></i>Categoria Selecionada
                                                                        </label>
                                                                        <div class="input-groupe">
                                                                            <span class="input-group-text">
                                                                                <i class="bi bi-hash"></i>
                                                                            </span>
                                                                            <input
                                                                                type="text"
                                                                                id="categoria_shopee_display"
                                                                                class="form-control"
                                                                                placeholder="Nenhuma categoria selecionada"
                                                                                readonly>
                                                                            <button class="btn btn-outline-secondary" type="button" onclick="clearShopeeSelection()">
                                                                                <i class="bi bi-x-lg"></i>
                                                                            </button>
                                                                        </div>
                                                                        <!-- Input oculto para armazenar o ID da categoria selecionada -->
                                                                        <input type="hidden" name="categoria_shopee" id="id_shopee">
                                                                    </div>

                                                                    <hr />

                                                                    <div id="shopee-info" class="info-section">
                                                                        <p><strong>Atributos Específicos / Obrigatórios Shopee:</strong></p>
                                                                        <!-- Campos de atributos dinâmicos serão inseridos aqui pelo JS -->
                                                                        <ul id="atributos-obrigatorios" class="d-none2">
                                                                            <!-- Lista apenas para referência interna do JS, se necessário -->
                                                                        </ul>

                                                                        <div id="attributesResult"></div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- FIM NOVA Seção -->

                                                            <!-- Comentando seções antigas -->
                                                            <!-- 
                                                            <div id="pesq-shopee"></div> 
                                                            <div class="card mb-4">
                                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                                    <h5 class="mb-0 card-title">Pesquisar Categoria Shopee</h5>
                                                                </div>
                                                                <div class="card-body">
                                                                    <div class="mb-3">
                                                                        <input type="text" class="form-control" id="titulo_pesquisa_shopee" onkeyup="pesquisarCategorias()" placeholder="Digite um título para pesquisa...">
                                                                    </div>
                                                                    <div id="resultado"></div>
                                                                    <div id="lista_categorias"></div>
                                                                </div>
                                                            </div>
                                                             -->
                                                            <!-- 
                                                            <div class="card mb-4">
                                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                                    <h5 class="mb-0 card-title">Buscar Atributos Obrigatórios <small class="text-muted">[Shopee]</small></h5>
                                                                </div>
                                                                <div class="card-body">
                                                                    <button type="button" class="btn btn-primary d-none atributos_shopee" id="processBtnShopeeAttr" data-timeout="1">
                                                                        <span id="buttonTextShopeeAttr">Buscar atributos</span>
                                                                    </button>
                                                                    <div id="attributesResult"></div>
                                                                </div>
                                                            </div>
                                                             -->

                                                            <!-- Valores -->
                                                            <div class="card mb-4">
                                                                <div class="card-header">
                                                                    <h5 class="card-title mb-0">Valores</h5>
                                                                </div>
                                                                <div class="card-body mt-3">
                                                                    <div class="row">
                                                                        <!-- Options -->
                                                                        <div class="w-100">
                                                                            <div class="row">
                                                                                <div class="col-6">
                                                                                    <div class="mb-3">
                                                                                        <label for="preco_custo_forn"
                                                                                            class="form-label">Preço de
                                                                                            Custo</label>
                                                                                        <div class="input-group">
                                                                                            <span
                                                                                                class="input-group-text">R$</span>
                                                                                            <input type="text"
                                                                                                class="form-control"
                                                                                                step="0.01"
                                                                                                name="preco_custo_forn"
                                                                                                id="preco_custo_fornadd"
                                                                                                placeholder="Preço de Custo">
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="col-6">
                                                                                    <div class="mb-3">
                                                                                        <label for="preco_custo"
                                                                                            class="form-label">Preço de
                                                                                            Venda</label>
                                                                                        <div class="input-group">
                                                                                            <span
                                                                                                class="input-group-text">R$</span>
                                                                                            <input type="text"
                                                                                                class="form-control"
                                                                                                step="0.01"
                                                                                                name="preco_custo"
                                                                                                id="preco_custoadd"
                                                                                                placeholder="Preço de Venda">
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <!-- /Options-->
                                                                    </div>
                                                                </div>

                                                            </div>

                                                            <div class="card mb-4">
                                                                <div class="card-body">
                                                                    <div class="row">
                                                                        <!-- Options -->
                                                                        <div class="w-100">
                                                                            <div
                                                                                class="d-flex flex-row float-end flex-wrap gap-2">
                                                                                <button type="submit" name="action"
                                                                                    value="ADD" class="btn btn-primary"
                                                                                    id="processBtn" data-name="ADD"
                                                                                    data-timeout="0">
                                                                                    <span
                                                                                        id="buttonText">Adicionar</span>
                                                                                </button>
                                                                            </div>

                                                                        </div>
                                                                        <!-- /Options-->
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>


                                                        <!-- /Second column -->

                                                        <!-- Second column -->
                                                        <div class="col-12 col-lg-4">
                                                            <!-- Pricing Card -->
                                                            <div class="alert alert-danger" role="alert">
                                                                <b>Atenção:</b> Certifique-se de preencher todos os
                                                                campos obrigatórios abaixo para evitar problemas ao
                                                                anunciar o produto no Mercado Livre.
                                                            </div>

                                                            <div class="card mb-4">
                                                                <div class="card-header">
                                                                    <h5 class="card-title mb-0">Atributos Obrigatórios
                                                                        <small class="text-muted">[ML]</small>
                                                                    </h5>
                                                                </div>
                                                                <div class="card-body">
                                                                    <div class="mb-2">
                                                                        <div class=" d-none">
                                                                            <label class="form-label" for="domain_id">Id
                                                                                domínio</label>
                                                                            <input type="text" class="form-control"
                                                                                name="domain_id" id="domain_id"
                                                                                placeholder="domain_id">
                                                                        </div>
                                                                    </div>

                                                                    <div class="mb-2">
                                                                        <div class="">
                                                                            <label class="form-label"
                                                                                for="domain_name">Dominio</label>
                                                                            <input type="text" class="form-control"
                                                                                name="domain_name" id="domain_name"
                                                                                placeholder="domain_name">
                                                                        </div>
                                                                    </div>

                                                                    <div class="mb-2 d-none">
                                                                        <div class="">
                                                                            <label class="form-label"
                                                                                for="category_id">ID Categoria</label>
                                                                            <input type="text" class="form-control"
                                                                                name="categoria_id" id="category_id"
                                                                                placeholder="ID categoria">
                                                                        </div>
                                                                    </div>

                                                                    <div class="mb-2">
                                                                        <div class="">
                                                                            <label class="form-label"
                                                                                for="category_name">Categoria</label>
                                                                            <input type="text" class="form-control"
                                                                                name="categoria_nome" id="category_name"
                                                                                placeholder="Categoria">
                                                                        </div>
                                                                    </div>

                                                                    <div class="mb-2">
                                                                        <div class="">
                                                                            <div id="atributos_obrigatorios"
                                                                                class="gap-2">

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <!-- <div class="card mb-4">
                                                                <div class="card-header">
                                                                    <h5 class="card-title mb-0">Categoria Shopee</h5>
                                                                </div>

                                                                <div class="card-body w-100 align-items-end">
                                                                    <?php
                                                                    $query = "SELECT * FROM tokens_sistema WHERE plataforma = :plataforma";
                                                                    $stmt = $pdo->prepare($query);
                                                                    $plataforma = "shopee";
                                                                    $stmt->bindParam(':plataforma', $plataforma, PDO::PARAM_STR);
                                                                    $stmt->execute();
                                                                    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                                                    foreach ($resultados as $linha) {
                                                                        $partner_key = $linha['partner_key'];
                                                                        $partner_id = (int) $linha['partner_id'];
                                                                        $shop_id = (int) $linha['shop_id'];
                                                                        $access_token = $linha['access_token'];
                                                                        $refresh_token = $linha['refresh_token'];

                                                                        $tokenUpdater = new ShopeeTokenUpdater($pdo, $partner_id, $partner_key, $shop_id, $refresh_token);
                                                                        $tokenUpdater->getAccessToken();
                                                                    }
                                                                    ?>

                                                                    <form id="searchForm" class="mb-4 w-100 text-end">
                                                                        <div class="input-group justify-content-end">
                                                                            <button class="btn btn-primary" type="button" onclick="searchCategory()">Buscar categoria</button>
                                                                        </div>
                                                                    </form>

                                                                    <div id="load_cat"></div>
                                                                </div>

                                                            </div> -->

                                                            <!-- /Pricing Card -->
                                                            <div class="card mb-4">
                                                                <div class="card-header">
                                                                    <h5 class="card-title mb-0">Outros</h5>
                                                                </div>
                                                                <div class="card-body mt-3">
                                                                    <!-- Vendor -->
                                                                    <div class="mb-3 col ecommerce-select2-dropdown">
                                                                        <label class="form-label"
                                                                            for="sensivel">Conteúdo sensível?</label>

                                                                        <select class="form-select" name="sensivel"
                                                                            id="sensivel"
                                                                            aria-label="Floating label select example">
                                                                            <option value="0">Não</option>
                                                                            <option value="1">Sim</option>
                                                                        </select>
                                                                    </div>

                                                                    <!-- Category -->
                                                                    <div class="mb-3 col ecommerce-select2-dropdown">
                                                                        <label for="categoria_interna"
                                                                            class="form-label">Categoria interna</label>
                                                                        <select class="form-select select2"
                                                                            name="categoria_interna"
                                                                            id="categoria_interna">
                                                                            <option value="" disabled selected>Selecione
                                                                                uma categoria interna</option>
                                                                            <!-- Placeholder -->
                                                                            <?php
                                                                            $get_InternalCategory = $pdo->prepare("SELECT * FROM categorias WHERE plataforma = 'geral' ORDER BY titulo DESC");
                                                                            $get_InternalCategory->execute();

                                                                            while ($rowInternalCategory = $get_InternalCategory->fetch(PDO::FETCH_ASSOC)) {
                                                                                $categoria_interna = $rowInternalCategory['titulo'];
                                                                            ?>
                                                                                <option
                                                                                    value="<?php echo $categoria_interna; ?>">
                                                                                    <?php echo $categoria_interna; ?>
                                                                                </option>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                        </div>
                                                        <!-- /Second column -->
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->


    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/general.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <link rel="stylesheet"
        href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>


    <script>
        // Inicialize o select2 com tema Bootstrap 5.3
        $(document).ready(function() {
            $('#categoria_interna').select2({
                theme: 'bootstrap-5', // Use o tema do Bootstrap 5
                placeholder: "Selecione uma categoria interna", // Placeholder para o campo
                allowClear: true // Permite limpar a seleção
            });
        });

        function updateCounter() {
            const textarea = document.getElementById('descricao');
            const counter = document.getElementById('charCount');
            counter.textContent = `${textarea.value.length}/5000`;
        }

        // Atualiza ao carregar a página também
        document.addEventListener('DOMContentLoaded', updateCounter);
    </script>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelector(".gtinValid").addEventListener("blur", function() {
                let gtin = this.value.trim();
                if (validarGTIN13(gtin)) {
                    this.style.borderColor = "light";
                } else {
                    this.style.borderColor = "light";
                    Swal.fire({
                        icon: "error",
                        title: "GTIN-13 inválido!",
                        text: "O código deve começar com 789 e ter 13 dígitos.",
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        showConfirmButton: false, // Desativamos o botão padrão para criar um novo container
                        didOpen: () => {
                            const modal = Swal.getHtmlContainer();

                            // Criar um container para os botões
                            const btnContainer = document.createElement("div");
                            btnContainer.style.display = "flex";
                            btnContainer.style.gap = "10px";
                            btnContainer.style.justifyContent = "center";
                            btnContainer.style.marginTop = "10px";

                            // Botão "Corrigir"
                            const corrigirBtn = document.createElement("button");
                            corrigirBtn.innerText = "Corrigir";
                            corrigirBtn.classList.add("swal2-confirm", "swal2-styled");
                            corrigirBtn.style.backgroundColor = "#d33";
                            corrigirBtn.style.border = "none";
                            corrigirBtn.addEventListener("click", function() {
                                Swal.close();
                            });

                            // Botão "Gerar EAN"
                            const gerarBtn = document.createElement("button");
                            gerarBtn.innerText = "Gerar EAN";
                            gerarBtn.id = "gerarCodigo";
                            gerarBtn.classList.add("swal2-confirm", "swal2-styled");
                            gerarBtn.style.backgroundColor = "#28a745";
                            gerarBtn.style.border = "none";

                            gerarBtn.addEventListener("click", function() {
                                gerarEAN();
                                Swal.close(); // Fecha o modal após gerar o código
                            });

                            // Adicionar botões ao container e ao modal
                            btnContainer.appendChild(corrigirBtn);
                            btnContainer.appendChild(gerarBtn);
                            modal.appendChild(btnContainer);
                        }
                    });
                }
            });
        });

        function validarGTIN13(gtin) {
            return gtin.length === 13 && gtin.startsWith("789") && /^\d{13}$/.test(gtin);
        }

        function gerarEAN() {
            let novoEAN = "789" + Math.floor(1000000000 + Math.random() * 9000000000);
            document.querySelector(".gtinValid").value = novoEAN;
        }
    </script>


    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const alturaInput = document.getElementById('altura');
            const larguraInput = document.getElementById('largura');
            const comprimentoInput = document.getElementById('comprimento');
            const resultadoInput = document.getElementById('dimensoes');

            function atualizarResultado() {
                const altura = alturaInput.value;
                const largura = larguraInput.value;
                const comprimento = comprimentoInput.value;

                // Atualiza o input com as dimensões se todos os campos forem preenchidos
                if (altura && largura && comprimento) {
                    resultadoInput.value = `${altura} x ${largura} x ${comprimento}`;
                } else {
                    resultadoInput.value = ''; // Limpa o resultado se faltar algum valor
                }
            }

            // Adiciona eventos para atualizar o valor do input de resultado
            alturaInput.addEventListener('input', atualizarResultado);
            larguraInput.addEventListener('input', atualizarResultado);
            comprimentoInput.addEventListener('input', atualizarResultado);
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const pesoInput = document.getElementById('peso');
            const unidadeSelect = document.getElementById('unidade');
            const resultadoInput = document.getElementById('value_peso_pacote');

            function atualizarResultado() {
                const peso = pesoInput.value;
                const unidade = unidadeSelect.value;

                // Atualiza o input com o peso e a unidade se ambos forem preenchidos
                resultadoInput.value = peso && unidade ? `${peso} ${unidade}` : '';
            }

            // Adiciona eventos para atualizar o valor do input de resultado
            pesoInput.addEventListener('input', atualizarResultado);
            unidadeSelect.addEventListener('change', atualizarResultado);
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.querySelector('form');
            const submitButton = form.querySelector('button[type="submit"]');
            const validationInterval = 2000; // Intervalo em milissegundos (2 segundos)

            function validateInputs() {
                let isValid = true;

                const requiredInputs = form.querySelectorAll('[required], #atributos_obrigatorios input[required]');

                requiredInputs.forEach(input => {
                    const parent = input.parentElement;
                    const errorMessage = parent.querySelector('.error-message');

                    if (errorMessage) {
                        errorMessage.remove();
                    }

                    if (!input.value.trim()) {
                        isValid = false;

                        input.style.borderColor = 'red';

                        const error = document.createElement('div');
                        error.className = 'error-message text-danger mt-1';
                        error.textContent = 'Campo obrigatório';

                        parent.appendChild(error);
                    } else {
                        input.style.borderColor = '';
                    }
                });

                submitButton.disabled = !isValid;
            }

            validateInputs();

            setInterval(validateInputs, validationInterval);
        });
    </script>


    <script>
        $(document).ready(function() {
            $('#vendas').DataTable({
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese.json"
                },
                "paging": false,
                "responsive": true,
                "searching": false
            });
        });


        function limitarTexto(texto, limite) {
            return texto.length > limite ? texto.substring(0, limite) + '...' : texto;
        }


        $('.submit_button').click(function() {
            // Obtém o ID do produto
            var product_id = $('#product_id').val();

            // Verifica se o ID do produto foi inserido antes de iniciar a solicitação AJAX
            if (!product_id) {
                Swal.fire({
                    title: "Atenção!",
                    text: "Insira o ID do produto do Mercado Livre para continuar!",
                    icon: "warning"
                });
                return; // Sai da função caso o ID do produto não esteja presente
            }

            console.log("Antes da solicitação AJAX");

            $.ajax({
                url: '../../assets/ajax/produtos/get_product_info.php',
                type: 'POST',
                data: {
                    product_id: product_id
                },
                dataType: 'json',
                success: function(response) {
                    console.log("Resposta recebida:", response);

                    // Verifica se a resposta possui os dados esperados
                    if (typeof response === 'object' && response.hasOwnProperty('name') && response
                        .hasOwnProperty('description')) {
                        // Define os valores dos campos com os dados do produto
                        $('#nome_produto').val(response.name);
                        // Preenche automaticamente o campo de busca Shopee com o nome do produto
                        $('#nome_produto_shopee').val(response.name);

                        // Disparar evento input manualmente para acionar a busca de categoria Shopee
                        const nomeProdutoEvent = new Event('input', {
                            bubbles: true
                        });
                        document.getElementById('nome_produto').dispatchEvent(nomeProdutoEvent);

                        $('#descricao').val(formatarTextoCompleto(response.description));
                        buscarCategoria(response.attributes); // Passa os atributos para buscarCategoria

                        // Limpa a visualização e os inputs de imagens anteriores
                        $('#img_preview').empty();
                        $('#images_container').empty(); // Limpa o container principal
                        $('#images_container').removeClass(
                            'border rounded p-3'); // Remove classes se não houver imagens

                        // Verifica se há imagens disponíveis e adiciona ao container
                        if (response.pictures && response.pictures.length > 0) {
                            $('#images_container').addClass(
                                'border rounded p-3 mb-3'); // Adiciona margem inferior
                            // $('#images_container').append('<h5>Imagens Carregadas Automaticamente</h5>'); // Título opcional

                            response.pictures.forEach(function(picture_url, index) {
                                const imageCardHtml = `
                                    <div class="imagem-card-add position-relative d-inline-block me-2 mb-2 border rounded p-1 align-top" style="width: 120px;">
                                        <img src="${picture_url}" class="img-fluid rounded" style="width: 100px; height: 100px; object-fit: cover; cursor: grab;">
                                        <button type="button" class="btn btn-danger btn-sm position-absolute top-0 end-0 m-1 p-0 d-flex justify-content-center align-items-center" style="width: 20px; height: 20px; line-height: 1;" onclick="removerImagemAdicionar(this)">
                                            <i class="ti ti-x" style="font-size: 0.8rem;"></i>
                                        </button>
                                        <input type="hidden" name="ordered_ml_images[]" value="${picture_url}">
                                    </div>
                                `;
                                $('#images_container').append(imageCardHtml);
                            });


                            // Se houver 9 imagens ou mais, esconde os inputs de upload
                            if ($('#images_container .imagem-card-add').length >= 9) {
                                $('#formFileMultipleAdd, #formFileAddSmall').hide();
                            } else {
                                $('#formFileMultipleAdd, #formFileAddSmall').show();
                            }
                        } else {
                            // Garante que os inputs de upload fiquem visíveis se não houver imagens do ML
                            $('#formFileMultipleAdd, #formFileAddSmall').show();
                        }

                        // Agora vamos preencher os inputs com base nos atributos
                        // O setTimeout foi removido daqui. O preenchimento será feito em buscarAtributosObrigatorios.
                    } else {
                        alert('Resposta inválida. Verifique o formato dos dados retornados.');
                    }
                },

                error: function(xhr, status, error) {
                    // Caso ocorra um erro na solicitação AJAX
                    Swal.fire({
                        title: "Erro!",
                        text: "Erro ao obter informações do produto. Por favor, verifique o ID do produto e tente novamente!",
                        icon: "error"
                    });
                }
            });

            // console.log("Após a solicitação AJAX");
        });

        function formatarTextoCompleto(texto) {
            // Corrige espaços, remove asteriscos e quebra onde faz sentido
            texto = texto
                .replace(/\*/g, '') // remove asteriscos
                .replace(/\s*\.\s*/g, '.\n\n') // quebra em parágrafos após pontos finais
                .replace(/\n{3,}/g, '\n\n') // evita quebras demais
                .replace(/(CARACTERÍSTICAS:)/i, '\n\n$1\n') // separa a seção de características
                .replace(/([^\n])\s*(Marca:)/i, '\n$1\n$2') // quebra antes das specs
                .replace(/(Modelo:|Potência:|Temperatura da cor:|Tensão:|Dimensões:|Profundidade:|Materiais:)/g,
                    '\n$1') // quebra cada item

            // Capitaliza o início de cada parágrafo (opcional)
            texto = texto.split('\n').map(linha => {
                return linha.trim().charAt(0).toUpperCase() + linha.trim().slice(1)
            }).join('\n')

            return texto.trim()
        }

        $('#nome_produto').on('input', function() {
            buscarCategoria();
        });

        // Garante validação ao voltar do histórico do navegador
        window.addEventListener('pageshow', function(event) {
            // Só executa se não for um carregamento inicial (persisted indica back/forward cache)
            if (event.persisted || performance.getEntriesByType('navigation')[0]?.type === 'back_forward') {
                buscarCategoria();
            }
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#pegarInputs').click(function() {
                var productId = $('#product_id').val();
                var atributosObrigatorios = [];

                $('#atributos_obrigatorios input').each(function() {
                    var idCompleto = $(this).attr('id');
                    var idSemPrefixo = idCompleto.replace('atributo_', '');
                    var idSemSufixo = idSemPrefixo.replace('_input', '');
                    atributosObrigatorios.push(idSemSufixo);
                });

                // Envia os dados via AJAX
                $.ajax({
                    url: '../../assets/ajax/produtos/get_product_obrigatorio_info.php',
                    method: 'POST',
                    data: {
                        productId: productId,
                        atributosObrigatorios: atributosObrigatorios
                    },
                    success: function(response) {
                        //console.log('Dados enviados com sucesso!');
                        //console.log('Resposta do servidor:', response);

                        var data = JSON.parse(response);
                        for (var i = 0; i < data.atributosObrigatorios.length; i++) {
                            var atributo = data.atributosObrigatorios[i];
                            var inputId = atributo.split(':')[0];
                            var inputValue = atributo.split(':')[1];
                            $('#' + inputId).val(inputValue);

                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Erro ao enviar dados:', error);
                    }
                });
            });
        });
    </script>

    <script>
        let originModal = null;
        let selectedCategory = null;
        let selectedSubcategory = null;

        const nomeProdutoInput = document.getElementById('nome_produto');
        const domainIdInput = document.getElementById('domain_id');
        const domainNameInput = document.getElementById('domain_name');
        const categoryIdInput = document.getElementById('category_id');
        const categoryNameInput = document.getElementById('category_name');
        const atributosObrigatoriosDiv = document.getElementById('atributos_obrigatorios');

        function buscarCategoria(mlAttributesToFill) { // Aceita mlAttributesToFill
            <?php
            // Pega dados de token do fornecedor
            $user_id = $_SESSION['usuario']['id_usuario'];

            $tokenFetcher = new TokenFetcher($pdo);
            $dados = $tokenFetcher->getTokenByPlataforma('MercadoLivre', ['client_id', 'client_secret']);

            if ($dados) {
                $client_id = $dados['client_id'];
                $client_secret = $dados['client_secret'];
            }

            $usuarioApiConta = new UsuarioApiConta($pdo);
            $resultados_tokens = $usuarioApiConta->buscarUsuariosApiContas($user_id, 'fornecedor_ml');

            $access_token = null;
            $shop_id = null;
            $refresh_token = null;
            if (!empty($resultados_tokens)) {
                $conta = $resultados_tokens[0];
                $access_token = $conta['access_token'];
                $shop_id = $conta['seller_id'];
                $refresh_token = $conta['refresh_token'];
            }


            $url = 'https://api.mercadolibre.com/oauth/token';

            $post_fields = http_build_query([
                'grant_type'    => 'refresh_token',
                'client_id'     => $client_id,
                'client_secret' => $client_secret,
                'refresh_token' => $refresh_token,
            ]);

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $post_fields,
                CURLOPT_HTTPHEADER => array(
                    'accept: application/json',
                    'content-type: application/x-www-form-urlencoded'
                ),
            ));

            $response = curl_exec($ch);
            curl_close($ch);

            $data = json_decode($response, true);
            $new_access_token = $data['access_token'];
            $new_refresh_token = $data['refresh_token'];

            // Atualiza os tokens no banco de dados
            $sqlUpdate = "UPDATE usuarios_api_contas 
                            SET access_token = :access_token, code = :refresh_token
                            WHERE seller_id = :seller_id AND plataforma = 'fornecedor_ml'";
            $stmtUpdate = $pdo->prepare($sqlUpdate);
            $stmtUpdate->execute([
                'access_token' => $new_access_token,
                'refresh_token' => $new_refresh_token,
                'seller_id' => $shop_id
            ]);


            // busca os dados atualizados
            $usuarioApiConta = new UsuarioApiConta($pdo);
            $resultados_tokens = $usuarioApiConta->buscarUsuariosApiContas($user_id, 'fornecedor_ml');

            $access_token = null;
            $shop_id = null;
            $refresh_token = null;
            if (!empty($resultados_tokens)) {
                $accessToken = $conta['access_token'];
            }
            ?>

            const nomeProduto = nomeProdutoInput.value.trim();
            const accessToken = '<?= $accessToken ?>'; // Mantido caso precise para outras chamadas, NÃO usar em query string

            // Importante: NÃO envie access_token na query string (ML bloqueia por políticas de segurança - PolicyAgent 403).
            // O endpoint domain_discovery funciona sem autenticação.
            const url =
                `https://api.mercadolibre.com/sites/MLB/domain_discovery/search?limit=1&q=${encodeURIComponent(nomeProduto)}`;

            // Fazer uma chamada AJAX para a API do Mercado Livre (sem token na URL).
            fetch(url)
                .then(response => response.json())
                .then(data => {
                    if (data && data.length > 0) {
                        const category = data[0];

                        domainIdInput.value = category.domain_id;
                        domainNameInput.value = category.domain_name;
                        categoryIdInput.value = category.category_id;
                        categoryNameInput.value = category.category_name;

                        // Se houver um category_id, faça uma segunda chamada para buscar os atributos obrigatórios.
                        if (category.category_id) {
                            buscarAtributosObrigatorios(category.category_id, accessToken,
                                mlAttributesToFill); // Passa mlAttributesToFill
                        }
                    } else {
                        domainIdInput.value = "";
                        domainNameInput.value = "";
                        categoryIdInput.value = "";
                        categoryNameInput.value = "";
                        atributosObrigatoriosDiv.innerHTML = "";
                    }
                })
                .catch(error => {
                    console.error('Erro ao buscar categoria:', error);
                });
        }


        function buscarAtributosObrigatorios(categoryId, accessToken, mlAttributesToFill) { // Aceita mlAttributesToFill
            const url = '/assets/ajax/plataformas/mercado_livre/buscar_atributos.php';

            const formData = new FormData();
            formData.append('category_id', categoryId);
            if (accessToken) {
                formData.append('access_token', accessToken);
            }

            fetch(url, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    atributosObrigatoriosDiv.innerHTML = "";

                    // Tratamento para erro de integração Mercado Livre
                    if (data && data.status === 403 && data.code === "PA_UNAUTHORIZED_RESULT_FROM_POLICIES") {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Integração Mercado Livre necessária',
                            text: 'O fornecedor precisa conectar a uma integração do Mercado Livre e tentar novamente.',
                            confirmButtonText: 'Integrar agora',
                            allowOutsideClick: false,
                            allowEscapeKey: false
                        }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href = '/dash/configuracoes';
                            }
                        });
                        // Remove o botão processBtn se existir
                        const processBtn = document.getElementById('processBtn');
                        if (processBtn) {
                            processBtn.remove();
                        }
                        return;
                    }

                    if (data && data.length > 0) {
                        data.forEach(attribute => {
                            // Filtra apenas atributos realmente obrigatórios (required === true)
                            if (
                                (attribute.tags && attribute.tags.required === true) ||
                                attribute.hierarchy === "PARENT_PK"
                            ) {
                                const div = document.createElement('div');
                                div.className = 'd-flex flex-wrap gap-2 mb-3';

                                const label = document.createElement('label');
                                label.textContent = attribute.name;
                                label.className = 'form-label';
                                label.htmlFor = 'atributo_' + attribute.id;

                                const inputGroup = document.createElement('div');
                                inputGroup.className = 'input-group';

                                const inputElement = document.createElement('input');
                                inputElement.type = 'text';
                                inputElement.className = 'form-control';
                                inputElement.id = 'atributo_' + attribute.id + '_input';
                                inputElement.name = 'atributo_' + attribute.id + '*' + 'label_' + attribute.name;
                                inputElement.placeholder = attribute.name;
                                inputElement.required = true;

                                // Preenche o input com o valor de mlAttributesToFill, se existir.
                                // Este valor pode ser sobrescrito pela lógica específica de MODEL/BRAND abaixo.
                                if (mlAttributesToFill && typeof mlAttributesToFill === 'object' && mlAttributesToFill.hasOwnProperty(attribute.name)) {
                                    inputElement.value = mlAttributesToFill[attribute.name];
                                }

                                if (attribute.id === 'MODEL') {
                                    inputElement.value = document.getElementById('nome_produto').value;
                                    inputElement.readOnly = true;
                                } else if (attribute.id === 'BRAND') {
                                    // Se o input de Marca ainda não foi preenchido por mlAttributesToFill ou estiver vazio,
                                    // usa o nome do site como fallback.
                                    if (!inputElement.value) {
                                        inputElement.value = <?php echo json_encode(Config::get('site_configs.name')); ?>;
                                    }
                                    inputElement.readOnly = false;
                                }

                                inputGroup.appendChild(inputElement);

                                if (attribute.values) {
                                    const selectElement = document.createElement('select');
                                    selectElement.className = 'form-select';
                                    selectElement.id = 'atributo_' + attribute.id;
                                    selectElement.name = 'atributo_' + attribute.id;

                                    const defaultOption = document.createElement('option');
                                    defaultOption.textContent = 'Selecione uma opção';
                                    defaultOption.disabled = true;
                                    defaultOption.selected = true;
                                    selectElement.appendChild(defaultOption);

                                    attribute.values.forEach(value => {
                                        const option = document.createElement('option');
                                        option.value = value.name;
                                        option.textContent = value.name;
                                        selectElement.appendChild(option);
                                    });

                                    selectElement.addEventListener('change', function() {
                                        const selectedValue = this.value;
                                        const associatedInput = document.getElementById('atributo_' + attribute.id + '_input');
                                        const currentValue = associatedInput.value;
                                        associatedInput.value = '';
                                        associatedInput.value = selectedValue;
                                    });

                                    inputGroup.appendChild(selectElement);
                                }

                                if (attribute.allowed_units && attribute.allowed_units.length > 0) {
                                    const unitSelect = document.createElement('select');
                                    unitSelect.className = 'form-select';
                                    unitSelect.id = 'atributo_' + attribute.id + '_unit';
                                    unitSelect.name = 'atributo_' + attribute.id + '_unit';

                                    attribute.allowed_units.forEach(unit => {
                                        const option = document.createElement('option');
                                        option.value = unit.name;
                                        option.textContent = unit.name;
                                        unitSelect.appendChild(option);
                                    });

                                    unitSelect.addEventListener('change', function() {
                                        const selectedUnit = this.value;
                                        const associatedInput = document.getElementById('atributo_' + attribute.id + '_input');
                                        const currentValue = associatedInput.value;
                                        associatedInput.value = currentValue ? currentValue.replace(/\s*\S+$/, '') + selectedUnit : selectedUnit;
                                    });

                                    inputGroup.appendChild(unitSelect);
                                }

                                div.appendChild(label);
                                div.appendChild(inputGroup);
                                atributosObrigatoriosDiv.appendChild(div);
                            }
                        });
                    } else {
                        const noAttributesMessage = document.createElement('p');
                        noAttrMsg.className = 'text-muted atributo-dinamico-group';
                        noAttrMsg.textContent =
                            'Nenhum atributo obrigatório ou específico (Homologação, Fabricante) encontrado para esta categoria Shopee.';
                        shopeeInfoDiv.appendChild(noAttrMsg);
                    }
                })
                .catch(error => {
                    console.error('Erro ao buscar atributos obrigatórios:', error);
                });
        }


        function gerarCodigoEAN() {
            let codigo = '789';
            for (let i = 0; i < 9; i++) {
                codigo += Math.floor(Math.random() * 10);
            }
            const digitoVerificador = calcularDigitoVerificador(codigo);
            return codigo + digitoVerificador;
        }


        function calcularDigitoVerificador(codigo) {
            const digits = codigo.split('').map(Number);
            let sum = 0;

            for (let i = 0; i < digits.length; i++) {
                sum += (i % 2 === 0) ? digits[i] : digits[i] * 3;
            }

            const checksum = (10 - (sum % 10)) % 10;
            return String(checksum);
        }

        var _URL = window.URL || window.webkitURL;

        $("#formFileMultipleAdd").change(function(e) {
            var input = this; // Referência ao input file
            var files = input.files;
            var mensagemDiv = document.getElementById("img-info-add");

            // Limpar mensagens anteriores
            mensagemDiv.innerHTML = "";

            var erros = [];
            var imagensCarregadas = 0; // Contador de imagens carregadas

            for (var i = 0; i < files.length; i++) {
                (function(file) {
                    var img = new Image();

                    img.onload = function() {
                        imagensCarregadas++;

                        if (this.width < 500 || this.height < 500 || this.width > 1200 || this.height >
                            1200) {
                            erros.push('A imagem "' + file.name + '" tem o tamanho de: ' + this.width +
                                'x' + this.height);
                        }

                        // Verifique se todas as imagens foram carregadas
                        if (imagensCarregadas === files.length) {
                            exibirErros();
                        }
                    };

                    img.onerror = function() {
                        alert("Não é um arquivo válido: " + file.type);
                    };

                    img.src = _URL.createObjectURL(file);
                })(files[i]);
            }

            function exibirErros() {
                if (erros.length > 0) {
                    var mensagem = document.createElement("div");
                    mensagem.className = "alert alert-danger";
                    mensagem.style.marginTop = "10px"; // Espaçamento entre alertas

                    var closeButton = document.createElement("button");
                    closeButton.className = "btn-close float-end";
                    closeButton.setAttribute("data-bs-dismiss", "alert");
                    closeButton.setAttribute("aria-label", "Close");

                    mensagem.appendChild(document.createTextNode("Erros nas imagens:"));
                    mensagem.appendChild(closeButton);

                    var erroTexto = "<ul>";
                    for (var i = 0; i < erros.length; i++) {
                        erroTexto += "<li>" + erros[i] + "</li>";
                    }
                    erroTexto += "</ul>";

                    mensagem.innerHTML += erroTexto;

                    mensagemDiv.appendChild(mensagem);

                    // Limpar o input file se houver erros
                    input.value = "";
                }
            }
        });

        $("#formFileMultipleEdt").change(function(e) {
            var input = this; // Referência ao input file
            var files = input.files;
            var mensagemDiv = document.getElementById("img-info-edt");

            // Limpar mensagens anteriores
            mensagemDiv.innerHTML = "";

            var erros = [];
            var imagensCarregadas = 0; // Contador de imagens carregadas

            for (var i = 0; i < files.length; i++) {
                (function(file) {
                    var img = new Image();

                    img.onload = function() {
                        imagensCarregadas++;

                        if (this.width < 500 || this.height < 500 || this.width > 1200 || this.height >
                            1200) {
                            erros.push('A imagem "' + file.name + '" tem o tamanho de: ' + this.width +
                                'x' + this.height);
                        }

                        // Verifique se todas as imagens foram carregadas
                        if (imagensCarregadas === files.length) {
                            exibirErros();
                        }
                    };

                    img.onerror = function() {
                        alert("Não é um arquivo válido: " + file.type);
                    };

                    img.src = _URL.createObjectURL(file);
                })(files[i]);
            }

            function exibirErros() {
                if (erros.length > 0) {
                    var mensagem = document.createElement("div");
                    mensagem.className = "alert alert-danger";
                    mensagem.style.marginTop = "10px"; // Espaçamento entre alertas

                    var closeButton = document.createElement("button");
                    closeButton.className = "btn-close float-end";
                    closeButton.setAttribute("data-bs-dismiss", "alert");
                    closeButton.setAttribute("aria-label", "Close");

                    mensagem.appendChild(document.createTextNode("Erros nas imagens:"));
                    mensagem.appendChild(closeButton);

                    var erroTexto = "<ul>";
                    for (var i = 0; i < erros.length; i++) {
                        erroTexto += "<li>" + erros[i] + "</li>";
                    }
                    erroTexto += "</ul>";

                    mensagem.innerHTML += erroTexto;

                    mensagemDiv.appendChild(mensagem);

                    // Limpar o input file se houver erros
                    input.value = "";
                }
            }
        });


        $(document).ready(function() {
            $('#gerarCodigo').click(function() {
                const codigoGerado = gerarCodigoEAN();
                $('.codigo_universal').val(codigoGerado);
                //console.log(codigoGerado);
            });

            const codigoGerado = gerarCodigoEAN();
            $('.codigo_universal').val(codigoGerado);

            $('#gerarCodigoEDT').click(function() {
                const codigoGerado = gerarCodigoEAN();
                $('.codigo_universalEDT').val(codigoGerado);
                //console.log(codigoGerado);
            });

            $('input[name="produtos_para_deletar[]"]').change(function() {
                const algumSelecionado = $('input[name="produtos_para_deletar[]"]:checked').length > 0;
                $('#excluirSelecionados').toggleClass("d-none", !algumSelecionado)
            });

        });
    </script>

    <script>
        function pesquisarCategorias() {
            var titulo = document.getElementById("titulo").value;
            var resultado = document.getElementById("resultado");

            if (titulo.length < 3) {
                resultado.innerHTML = "Digite pelo menos 3 caracteres...";
                resultado.style.display = "block";
                return;
            }

            var xhr = new XMLHttpRequest();
            xhr.open("GET", "../../assets/ajax/produtos/get_shopee_category.php?titulo=" + encodeURIComponent(titulo) +
                "&pagina=1", true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    resultado.innerHTML = xhr.responseText;
                    resultado.style.display = "block";
                }
            };
            xhr.send();
        }

        function mudarPagina(pagina) {
            var titulo = document.getElementById("titulo").value;
            var resultado = document.getElementById("resultado");

            var xhr = new XMLHttpRequest();
            xhr.open("GET", "../../assets/ajax/produtos/get_shopee_category.php?titulo=" + encodeURIComponent(titulo) +
                "&pagina=" + pagina, true);
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    resultado.innerHTML = xhr.responseText; // Atualiza apenas a parte do conteúdo da listagem
                    resultado.style.display = "block";
                }
            };
            xhr.send();
        }

        function selecionarCategoria(id, nome) {
            var listaCategorias = document.querySelectorAll('.card');
            listaCategorias.forEach(function(card) {
                card.classList.remove('border-primary');
            });

            var categoriaSelecionada = event.target.closest('.card');
            categoriaSelecionada.classList.add('border-primary');

            document.getElementById("lista_categorias").style.display = "none";
            var resultado = document.getElementById("resultado");
            resultado.innerHTML = '<div class="text-primary fw-bold">' + nome + '</div>';
            resultado.style.display = "block";
            document.getElementById("id_shopee").value = id;
            document.getElementsByClassName("atributos_shopee")[0].click();
        }
    </script>

    <script>
        $(document).ready(function() {
            $('.atributos_shopee').on('click', function(e) {
                e.preventDefault();
                const categoryId = $('#id_shopee').val();

                $.ajax({
                    url: '../../assets/ajax/plataformas/shopee/fetch_attributes.php',
                    type: 'POST',
                    data: {
                        category_id: categoryId
                    },
                    success: function(response) {
                        $('#attributesResult').html(response);
                    },
                    error: function() {
                        $('#attributesResult').html(
                            '<p style="color:red">Erro ao buscar atributos.</p>');
                    }
                });
            });
        });
    </script>

    <?php
    if ($_POST && isset($_POST['ADD'])) {
        $titulo = mb_convert_case($_POST["titulo"], MB_CASE_TITLE, 'UTF-8');
        $fornecedor = pegaPrefixo() . $_SESSION['usuario']['id_usuario'];

        $checkQuery = "SELECT COUNT(*) FROM produtos WHERE titulo = :titulo and fornecedor = :fornecedor";
        $checkStmt = $pdo->prepare($checkQuery);
        $checkStmt->execute([':titulo' => $titulo, ':fornecedor' => $fornecedor]);
        $productExists = $checkStmt->fetchColumn();

        if ($productExists > 0) {
            sendAlert("Produto com o mesmo nome já existe!", "error", "/dash/adicionar_produtos");
            exit();
        }

        $prefixo = 'DPX';

        define("INFERIOR", 1000000000);
        define("SUPERIOR", 9999999999);
        define("INFE", 100);
        define("SUPE", 999);

        do {
            $codigorandom = rand(INFERIOR, SUPERIOR);
            $codigorandom2 = rand(INFE, SUPE);

            $codigorandom_sem_prefixo = 'DPX' . $codigorandom;
            $sql = "SELECT sku FROM produtos WHERE sku = :sku";
            $selectProds = $pdo->prepare($sql);
            $selectProds->bindParam(':sku', $codigorandom_sem_prefixo, PDO::PARAM_STR);
            $selectProds->execute();

            $resultProds = $selectProds->fetch(PDO::FETCH_ASSOC);

            if (!$resultProds) {
                $randcode = $codigorandom;
                break;
            } else {
                $randcode = $codigorandom . $codigorandom2;
                break;
            }
        } while (true);

        $sku = $prefixo . $randcode;
        $descricao = $_POST["descricao"];
        $sensivel = $_POST["sensivel"];
        $ncm = $_POST["ncm"];

        $altura = $_POST['altura'] ?? null;
        $largura = $_POST['largura'] ?? null;
        $comprimento = $_POST['comprimento'] ?? null;

        $peso = $_POST['peso'] ?? null;
        $unidade = $_POST['unidade'] ?? null;

        $peso_completo = $peso . ' ' . $unidade;

        $categoria_ml = $_POST["categoria_nome"];
        $categoria_ml_id = $_POST["categoria_id"];
        $category_domain = $_POST["domain_name"];
        $estoque = $_POST["estoque"];
        $categoria_interna = $_POST["categoria_interna"] ?? null;
        $codigo_universal = $_POST["codigo_universal"];
        $fornecedor = $_POST["fornecedor"];
        $sku_fornecedor = $_POST["sku_fornecedor"];
        $categoria_shopee = $_POST["categoriaShopee"];
        $preco_custo_original = $_POST["preco_custo"];
        $preco_custo_forn_original = $_POST["preco_custo_forn"];
        $preco_custo = str_replace(",", ".", $preco_custo_original);
        $preco_custo_forn = str_replace(",", ".", $preco_custo_forn_original);


        $query = "INSERT INTO produtos (sensivel, titulo, descricao, categoria_ml, id_cat_ml, category_domain, categoria_interna, sku, fornecedor, sku_for, categoria_shopee, sku_ml, codigo_universal, preco_custo, add_data, estoque, ncm, altura, largura, comprimento, peso, preco_custo_forn, is_filho) 
              VALUES (:sensivel, :titulo, :descricao, :categoria_ml, :id_cat_ml, :category_domain, :categoria_interna, :sku, :fornecedor, :sku_for, :categoria_shopee, :sku_ml, :codigo_universal, :preco_custo, NOW(), :estoque, :ncm, :altura, :largura, :comprimento, :peso, :preco_custo_forn, :is_filho)";
        $stmt = $pdo->prepare($query);
        $stmt->execute([
            ':sensivel' => $sensivel,
            ':titulo' => $titulo,
            ':descricao' => $descricao,
            ':categoria_ml' => $categoria_ml,
            ':id_cat_ml' => $categoria_ml_id,
            ':category_domain' => $category_domain,
            ':categoria_interna' => $categoria_interna,
            ':sku' => $sku,
            ':fornecedor' => $fornecedor,
            ':sku_for' => $sku_fornecedor,
            ':categoria_shopee' => $categoria_shopee,
            ':sku_ml' => $sku,
            ':codigo_universal' => $codigo_universal,
            ':preco_custo' => $preco_custo,
            ':estoque' => $estoque,
            ':ncm' => $ncm,
            ':altura' => $altura,
            ':largura' => $largura,
            ':comprimento' => $comprimento,
            ':peso' => $peso_completo,
            ':preco_custo_forn' => $preco_custo_forn,
            ':is_filho' => 0,
        ]);


        $id_ai = $pdo->lastInsertId();
        $novo_id = pegaPrefixo() . $id_ai;

        // Atualiza a linha com o novo ID
        $updateQuery = "UPDATE produtos SET id = :novo_id WHERE id_ai = :id_ai";
        $updateStmt = $pdo->prepare($updateQuery);
        $updateStmt->execute([
            ':novo_id' => $novo_id,
            ':id_ai' => $id_ai,
        ]);


        // Adicionando os dados na tabela global
        $url = "https://api-hom.codefly.site/api/v1/alteracao/produtos.php";

        $data = json_encode([
            "id" => $novo_id,
            "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
            'sensivel' => $sensivel,
            'titulo' => $titulo,
            'marca' => '',
            'modelo' => '',
            'subcategoria_ml' => '',
            'id_subcat_ml' => '',
            'tipo_anuncio' => '',
            'porcentagem_extra' => '',
            'qtd_vendido' => 0,
            'descricao' => $descricao,
            'categoria_ml' => $categoria_ml,
            'id_cat_ml' => $categoria_ml_id,
            'category_domain' => $category_domain,
            'categoria_interna' => $categoria_interna,
            'sku' => $sku,
            'fornecedor' => $fornecedor,
            'sku_for' => $sku_fornecedor,
            'categoria_shopee' => $categoria_shopee,
            'sku_ml' => $sku,
            'codigo_universal' => $codigo_universal,
            'preco_custo' => $preco_custo,
            'preco_custo_forn' => $preco_custo_forn,
            'estoque' => $estoque,
            'ncm' => $ncm,
            'altura' => $altura,
            'largura' => $largura,
            'comprimento' => $comprimento,
            'peso' => $peso_completo,
            'is_filho' => 0,
        ]);

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
            CURLOPT_POSTFIELDS => $data
        ]);

        echo curl_exec($ch);
        curl_close($ch);

        function resizeImageToSquare($source_path, $destination_path, $target_size = 1080)
        {
            // Force target size to be 1080
            $target_size = 1080;

            // Get image dimensions and type
            $image_info = @getimagesize($source_path); // Adicionado @ para suprimir erros diretos
            if (!$image_info) {
                error_log("[Resize Error] getimagesize failed for: " . $source_path . ". Error: " . print_r(error_get_last(), true));
                return false;
            }
            list($width, $height, $image_type) = $image_info;

            error_log("[Resize Info] Source: {$source_path}, Width: {$width}, Height: {$height}, Type: {$image_type}");

            // Create image resource based on file type
            $source_image = null; // Inicializa para evitar warning se o tipo não for suportado
            switch ($image_type) {
                case IMAGETYPE_JPEG:
                    $source_image = @imagecreatefromjpeg($source_path);
                    break;
                case IMAGETYPE_PNG:
                    $source_image = @imagecreatefrompng($source_path);
                    break;
                case IMAGETYPE_GIF:
                    $source_image = @imagecreatefromgif($source_path);
                    break;
                case IMAGETYPE_WEBP: // Adicionar suporte a WEBP
                    if (function_exists('imagecreatefromwebp')) {
                        $source_image = @imagecreatefromwebp($source_path);
                    } else {
                        error_log("[Resize Error] imagecreatefromwebp function does not exist. GD WebP support missing?");
                        return false;
                    }
                    break;
                default:
                    error_log("[Resize Error] Unsupported image type: {$image_type} for source: {$source_path}");
                    return false; // Unsupported image type
            }

            if (!$source_image) {
                error_log("[Resize Error] Failed to create image resource from: {$source_path}. Type detected: {$image_type}. GD error: " . print_r(error_get_last(), true));
                return false; // Failed to create image resource
            }
            error_log("[Resize Info] Successfully created source image resource from: {$source_path}");

            // Create a new square image with the target dimensions (1080x1080)
            $new_image = @imagecreatetruecolor($target_size, $target_size);
            if (!$new_image) {
                @imagedestroy($source_image);
                error_log("[Resize Error] imagecreatetruecolor failed. GD error: " . print_r(error_get_last(), true));
                return false;
            }
            error_log("[Resize Info] Successfully created new true color image resource.");


            // For PNG and WEBP (if it supports alpha), maintain alpha channel
            if ($image_type == IMAGETYPE_PNG || ($image_type == IMAGETYPE_WEBP && function_exists('imagepalettetotruecolor'))) { // WebP alpha
                @imagealphablending($new_image, false);
                @imagesavealpha($new_image, true);
                $transparent = @imagecolorallocatealpha($new_image, 255, 255, 255, 127);
                if ($transparent === false) {
                    error_log("[Resize Warning] Failed to allocate transparent color for alpha channel. GD error: " . print_r(error_get_last(), true) . " Filling with white as fallback.");
                    $background_color = @imagecolorallocate($new_image, 255, 255, 255); // Fallback to white
                    if ($background_color !== false) @imagefill($new_image, 0, 0, $background_color);
                } else {
                    @imagefilledrectangle($new_image, 0, 0, $target_size, $target_size, $transparent);
                    error_log("[Resize Info] Alpha channel handling for PNG/WEBP set up.");
                }
            } else {
                // Fill with white background for other images
                $background_color = @imagecolorallocate($new_image, 255, 255, 255);
                if ($background_color === false) {
                    error_log("[Resize Error] Failed to allocate white background color. GD error: " . print_r(error_get_last(), true));
                    @imagedestroy($source_image);
                    @imagedestroy($new_image);
                    return false;
                }
                @imagefill($new_image, 0, 0, $background_color);
                error_log("[Resize Info] White background set for non-PNG/WEBP or non-alpha image.");
            }

            // Calculate scaling and positioning to maintain aspect ratio
            $scale = min($target_size / $width, $target_size / $height);
            $new_width = round($width * $scale);
            $new_height = round($height * $scale);

            // Center the image
            $x_offset = round(($target_size - $new_width) / 2);
            $y_offset = round(($target_size - $new_height) / 2);

            // Copy and resize the image
            $resample_success = @imagecopyresampled(
                $new_image,       // Destination image
                $source_image,    // Source image
                $x_offset,        // Destination X
                $y_offset,        // Destination Y
                0,
                0,             // Source X, Y
                $new_width,       // Destination width
                $new_height,      // Destination height
                $width,
                $height   // Source width, height
            );

            if (!$resample_success) {
                @imagedestroy($source_image);
                @imagedestroy($new_image);
                error_log("[Resize Error] imagecopyresampled failed. GD error: " . print_r(error_get_last(), true));
                return false;
            }
            error_log("[Resize Info] Image resampled successfully.");

            // Save the image as JPEG (destination is always .jpg)
            $result = @imagejpeg($new_image, $destination_path, 90); // 90% quality

            if (!$result) {
                error_log("[Resize Error] imagejpeg failed for destination: {$destination_path}. GD error: " . print_r(error_get_last(), true));
            } else {
                error_log("[Resize Info] Image saved as JPEG to: {$destination_path}");
            }

            // Free up memory
            @imagedestroy($source_image);
            @imagedestroy($new_image);

            if ($result) {
                $final_sizes = @getimagesize($destination_path);
                if (!$final_sizes) {
                    error_log("[Resize Verify Error] getimagesize failed for final destination: {$destination_path}. Error: " . print_r(error_get_last(), true));
                } elseif ($final_sizes[0] != $target_size || $final_sizes[1] != $target_size) {
                    error_log("[Resize Verify Warning] Final image dimensions ({$final_sizes[0]}x{$final_sizes[1]}) are not target ({$target_size}x{$target_size}). Path: {$destination_path}. Attempting to force dimensions.");
                    $temp_img_jpeg = @imagecreatefromjpeg($destination_path);
                    if ($temp_img_jpeg) {
                        error_log("[Resize Verify] Successfully re-created image from potentially mis-dimensioned JPEG: {$destination_path}");
                        $fixed_img = @imagecreatetruecolor($target_size, $target_size);
                        if ($fixed_img) {
                            $white = @imagecolorallocate($fixed_img, 255, 255, 255);
                            if ($white !== false) @imagefill($fixed_img, 0, 0, $white);
                            else error_log("[Resize Verify Error] Failed to allocate white for fixed_img. GD error: " . print_r(error_get_last(), true));

                            $copy_fixed_success = @imagecopyresampled($fixed_img, $temp_img_jpeg, 0, 0, 0, 0, $target_size, $target_size, $final_sizes[0], $final_sizes[1]);
                            if (!$copy_fixed_success) {
                                error_log("[Resize Verify Error] imagecopyresampled failed for fixed_img. GD error: " . print_r(error_get_last(), true));
                            }
                            $result_fixed = @imagejpeg($fixed_img, $destination_path, 90);
                            if ($result_fixed) {
                                error_log("[Resize Verify] Successfully force-resized and re-saved JPEG to: {$destination_path}");
                            } else {
                                error_log("[Resize Verify Error] Failed to re-save force-resized JPEG: {$destination_path}. GD error: " . print_r(error_get_last(), true));
                            }
                            @imagedestroy($fixed_img);
                        } else {
                            error_log("[Resize Verify Error] imagecreatetruecolor failed for fixed_img. GD error: " . print_r(error_get_last(), true));
                        }
                        @imagedestroy($temp_img_jpeg);
                    } else {
                        error_log("[Resize Verify Error] imagecreatefromjpeg failed for temp_img_jpeg from {$destination_path}. GD error: " . print_r(error_get_last(), true));
                    }
                } else {
                    error_log("[Resize Verify] Final image dimensions are correct for: {$destination_path}");
                }
            }

            return $result;
        }

        $produto_id = $novo_id;
        $image_file_counter = 1; // Contador unificado para nomes de arquivo de imagem

        // DEFININDO O CAMINHO RAIZ - SUBSTITUINDO pegarRaiz()
        $document_root = $_SERVER['DOCUMENT_ROOT'];
        error_log("[Adicionar Produto] Document Root: " . $document_root);

        // CORREÇÃO: Remover a parte duplicada do caminho.
        // $document_root já é /var/www/whitelabels/homolog, então adicionamos apenas /images/produtos_imagens/
        $produtos_dir = $document_root . "/images/produtos_imagens/";
        $upload_dir = $produtos_dir . $produto_id . "/";
        error_log("[Adicionar Produto] Upload Dir corrigido: " . $upload_dir);

        if (!file_exists($upload_dir)) {
            if (!mkdir($upload_dir, 0777, true)) {
                error_log("[Adicionar Produto] FALHA AO CRIAR DIRETÓRIO: " . $upload_dir);
                // Considerar parar o script ou não tentar salvar imagens se o diretório não puder ser criado
            } else {
                error_log("[Adicionar Produto] Diretório criado: " . $upload_dir);
            }
        } else {
            error_log("[Adicionar Produto] Diretório já existe: " . $upload_dir);
        }

        // 1. Processar ordered_ml_images (imagens de URL que foram importadas e ordenadas)
        if (isset($_POST["ordered_ml_images"]) && is_array($_POST["ordered_ml_images"])) {
            error_log("[Adicionar Produto] Processando ordered_ml_images: " . print_r($_POST["ordered_ml_images"], true));
            // Usar $key_ml como contador específico para imagens de URL para garantir nomes únicos
            foreach ($_POST["ordered_ml_images"] as $key_ml => $url_imagem_ml) {
                $current_image_index_ml = $key_ml + 1; // Usar índice baseado em 1 para nomes de arquivo e logs

                error_log("[Adicionar Produto] URL ML recebida (Índice Loop: {$current_image_index_ml}): " . $url_imagem_ml);
                if (!empty($url_imagem_ml)) {
                    // Usar $current_image_index_ml para nome de arquivo de imagem final e temporário
                    // O nome final será $produto_id . "_" . (índice da imagem salva no DB) . ".jpg"
                    // O $image_file_counter global será usado para a ordem e para o nome da imagem final.
                    // Para o arquivo temporário, usamos $current_image_index_ml para evitar colisões no loop.
                    $image_name_final_jpg = $produto_id . "_" . $image_file_counter . ".jpg"; // Nome do arquivo final usa o contador global
                    $dest_file_ml = $upload_dir . $image_name_final_jpg;
                    $id_unico_ml = uniqid('', true);
                    // Nome temporário usa o índice do loop para garantir unicidade DENTRO deste loop
                    $temp_file_ml_download = $upload_dir . 'temp_ml_' . $current_image_index_ml . '.tmp';

                    error_log("[Adicionar Produto] Tentando baixar (Índice Loop: {$current_image_index_ml}): {$url_imagem_ml} para {$temp_file_ml_download}. Destino final planejado: {$dest_file_ml}");
                    $image_data_ml = @file_get_contents($url_imagem_ml);

                    if ($image_data_ml) {
                        error_log("[Adicionar Produto] Sucesso ao baixar imagem de URL (Índice Loop: {$current_image_index_ml}). Bytes: " . strlen($image_data_ml));
                        if (file_put_contents($temp_file_ml_download, $image_data_ml) === false) {
                            error_log("[Adicionar Produto] FALHA ao salvar arquivo temporário (Índice Loop: {$current_image_index_ml}): {$temp_file_ml_download}. Error: " . print_r(error_get_last(), true));
                            continue; // Pula para a próxima imagem se não puder salvar o temporário
                        }
                        error_log("[Adicionar Produto] Arquivo temporário salvo (Índice Loop: {$current_image_index_ml}): {$temp_file_ml_download}");

                        error_log("[Adicionar Produto] Tentando redimensionar (Índice Loop: {$current_image_index_ml}): {$temp_file_ml_download} para {$dest_file_ml}");
                        if (resizeImageToSquare($temp_file_ml_download, $dest_file_ml)) {
                            error_log("[Adicionar Produto] Sucesso ao redimensionar imagem de URL (Índice Loop: {$current_image_index_ml}): {$dest_file_ml}");
                            // O arquivo redimensionado existe, prossiga para salvar no DB
                        } else {
                            error_log("[Adicionar Produto] FALHA ao redimensionar imagem de URL (Índice Loop: {$current_image_index_ml}) para o produto {$produto_id}: {$url_imagem_ml}. Source: {$temp_file_ml_download}, Destino: {$dest_file_ml}");
                            if (file_exists($temp_file_ml_download)) {
                                unlink($temp_file_ml_download);
                                error_log("[Adicionar Produto] Arquivo temporário {$temp_file_ml_download} removido após falha no redimensionamento.");
                            }
                            // Mesmo que o redimensionamento falhe, o arquivo de destino $dest_file_ml pode não existir ou estar corrompido.
                            // Não continuamos para a inserção no DB se o redimensionamento falhou.
                            continue; // Pula para a próxima imagem
                        }

                        // Remove o arquivo temporário após o redimensionamento (bem-sucedido ou não, se o destino foi criado)
                        if (file_exists($temp_file_ml_download)) {
                            unlink($temp_file_ml_download);
                            error_log("[Adicionar Produto] Arquivo temporário {$temp_file_ml_download} removido após tentativa de redimensionamento.");
                        }

                        if (file_exists($dest_file_ml)) {
                            error_log("[Adicionar Produto] Arquivo final da URL existe (Índice Loop: {$current_image_index_ml}): {$dest_file_ml}");
                            $protocol_ml = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
                            $dominio_ml = $_SERVER['HTTP_HOST'];
                            // O caminho da URL deve refletir o nome do arquivo salvo, que usa $image_file_counter
                            $final_image_url_ml = $protocol_ml . '://' . $dominio_ml . "/images/produtos_imagens/{$produto_id}/{$image_name_final_jpg}";
                            error_log("[Adicionar Produto] URL final para DB (ML - Índice Loop: {$current_image_index_ml}, Ordem DB: {$image_file_counter}): {$final_image_url_ml}");

                            try {
                                $insertQueryMl = "INSERT INTO produtos_imagens (id, produto_id, imagem_url, ordem) VALUES (:id, :produto_id, :imagem_url, :ordem)";
                                $insertStmtMl = $pdo->prepare($insertQueryMl);
                                $insertStmtMl->execute([
                                    ':id' => $id_unico_ml,
                                    ':produto_id' => $produto_id,
                                    ':imagem_url' => $final_image_url_ml,
                                    ':ordem' => $image_file_counter // Ordem no DB usa o contador global
                                ]);
                                error_log("[Adicionar Produto] Imagem de URL inserida no DB. ID Unico: {$id_unico_ml}, Produto ID: {$produto_id}, Ordem DB: {$image_file_counter}, URL: {$final_image_url_ml}");
                                $image_file_counter++; // Incrementar contador global APÓS inserção bem sucedida
                            } catch (PDOException $e) {
                                error_log("[Adicionar Produto] ERRO PDO ao inserir imagem de URL (Índice Loop: {$current_image_index_ml}, Ordem DB: {$image_file_counter}): " . $e->getMessage());
                            }
                        } else {
                            error_log("[Adicionar Produto] ARQUIVO FINAL DA URL NÃO EXISTE após redimensionamento (Índice Loop: {$current_image_index_ml}): {$dest_file_ml}");
                        }
                    } else {
                        error_log("[Adicionar Produto] FALHA ao baixar imagem de URL (Índice Loop: {$current_image_index_ml}): {$url_imagem_ml}. file_get_contents retornou falso. Error: " . print_r(error_get_last(), true));
                    }
                } else {
                    error_log("[Adicionar Produto] URL ML vazia encontrada (Índice Loop: {$current_image_index_ml}).");
                }
            }
        } else {
            error_log("[Adicionar Produto] Nenhuma ordered_ml_images encontrada no POST.");
        }

        // 2. Processar imagens de upload local
        if (isset($_FILES["imagens"]) && !empty($_FILES["imagens"]["name"][0])) {
            error_log("[Adicionar Produto] Processando _FILES[imagens]: " . print_r($_FILES["imagens"], true));
            foreach ($_FILES["imagens"]["tmp_name"] as $key => $tmp_name) {
                error_log("[Adicionar Produto] Upload Local - Key: {$key}, TmpName: {$tmp_name}, Name: {$_FILES["imagens"]["name"][$key]}, Error: {$_FILES["imagens"]["error"][$key]}");
                if ($_FILES["imagens"]["error"][$key] === UPLOAD_ERR_OK && !empty($_FILES["imagens"]["name"][$key])) {
                    $size = @getimagesize($tmp_name);
                    if ($size && $size[0] >= 500 && $size[1] >= 500 && $size[0] <= 1200 && $size[1] <= 1200) {
                        $image_name_upload = $produto_id . "_" . $image_file_counter . ".jpg";
                        $dest_file_upload = $upload_dir . $image_name_upload;
                        $id_unico_upload = uniqid('', true);

                        error_log("[Adicionar Produto] Upload Local - Tentando redimensionar: {$tmp_name} para {$dest_file_upload}");
                        if (resizeImageToSquare($tmp_name, $dest_file_upload)) {
                            error_log("[Adicionar Produto] Upload Local - Sucesso ao redimensionar: {$dest_file_upload}");
                            if (file_exists($dest_file_upload)) {
                                $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
                                $dominio = $_SERVER['HTTP_HOST'];
                                $url_atual = $protocol . '://' . $dominio . '/';
                                $final_image_url_upload = $url_atual . "images/produtos_imagens/{$produto_id}/{$image_name_upload}";
                                error_log("[Adicionar Produto] Upload Local - URL final para DB: {$final_image_url_upload}");

                                try {
                                    $insertQueryUpload = "INSERT INTO produtos_imagens (id, produto_id, imagem_url, ordem) VALUES (:id, :produto_id, :imagem_url, :ordem)";
                                    $insertStmtUpload = $pdo->prepare($insertQueryUpload);
                                    $insertStmtUpload->execute([
                                        ':id' => $id_unico_upload,
                                        ':produto_id' => $produto_id,
                                        ':imagem_url' => $final_image_url_upload,
                                        ':ordem' => $image_file_counter
                                    ]);
                                    error_log("[Adicionar Produto] Upload Local - Imagem inserida no DB. ID: {$id_unico_upload}, Produto ID: {$produto_id}, Ordem: {$image_file_counter}");
                                    $image_file_counter++;
                                } catch (PDOException $e) {
                                    error_log("[Adicionar Produto] Upload Local - ERRO PDO ao inserir imagem: " . $e->getMessage());
                                }
                            } else {
                                error_log("[Adicionar Produto] Upload Local - ARQUIVO FINAL NÃO EXISTE após redimensionamento: {$dest_file_upload}");
                            }
                        } else {
                            error_log("[Adicionar Produto] Upload Local - FALHA ao redimensionar imagem: {$_FILES["imagens"]["name"][$key]}. Destino: {$dest_file_upload}");
                        }
                    } else {
                        $filename = $_FILES["imagens"]["name"][$key];
                        $filesize_w = $size ? $size[0] : 'N/A';
                        $filesize_h = $size ? $size[1] : 'N/A';
                        error_log("[Adicionar Produto] Upload Local - Imagem '$filename' para produto {$produto_id} não atende requisitos de dimensão ou não é imagem. Dimensões: {$filesize_w}x{$filesize_h}");
                    }
                } elseif ($_FILES["imagens"]["error"][$key] !== UPLOAD_ERR_NO_FILE) {
                    error_log("[Adicionar Produto] Upload Local - Erro no upload: {$_FILES["imagens"]["name"][$key]} - Código: {$_FILES["imagens"]["error"][$key]}");
                }
            }
        } else {
            error_log("[Adicionar Produto] Nenhuma _FILES[imagens] com arquivo válido encontrada.");
        }

        // Remover o loop antigo que processava image_url_X
        /*
        for ($i = 0; $i <= 9; $i++) {
            $input_name = "image_url_" . $i;
            if (isset($_POST[$input_name]) && !empty($_POST[$input_name])) {
                // ... lógica antiga ...
            }
        }
        */

        // Seleciona todas as imagens do produto para enviar à API global, já ordenadas pelo image_file_counter
        $selectQuery = "SELECT id, imagem_url, ordem FROM produtos_imagens WHERE produto_id = :produto_id ORDER BY ordem ASC";
        $selectStmt = $pdo->prepare($selectQuery);
        $selectStmt->execute([':produto_id' => $produto_id]);
        $imagens = $selectStmt->fetchAll(PDO::FETCH_ASSOC);

        // Envia cada imagem para a API
        foreach ($imagens as $imagem) {
            $url = "https://api-hom.codefly.site/api/v1/alteracao/produtos_imagens.php";

            $data = json_encode([
                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                "id" => $imagem['id'],
                "imagem_url" => $imagem['imagem_url'],
                "produto_id" => $produto_id,
                "ordem" => $imagem['ordem']
            ]);

            $ch = curl_init($url);
            curl_setopt_array($ch, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                CURLOPT_POSTFIELDS => $data
            ]);

            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($response === false) {
                echo "cURL Error: " . $curl_error . "<br>";
            }
        }


        foreach ($_POST as $nome_campo => $valor) {
            if (strpos($nome_campo, 'atributo_') === 0) {
                $atributo = $nome_campo;
                if (!empty($atributo) && isset($_POST[$atributo])) {
                    $valores_separados = explode('*', $atributo);
                    if (count($valores_separados) >= 2) {
                        $atributo_id = substr($valores_separados[0], strlen('atributo_'));
                        $atributo_nome = substr($valores_separados[1], strlen('label_'));

                        $query = "INSERT INTO produtos_atributos (id_produto, nome_atributo, id_atributo, valor_atributo) 
                        VALUES (:id_produto, :nome_atributo, :id_atributo, :valor_atributo)";
                        $stmt = $pdo->prepare($query);
                        $stmt->execute([
                            ':id_produto' => $produto_id,
                            ':nome_atributo' => $atributo_nome,
                            ':id_atributo' => $atributo_id,
                            ':valor_atributo' => $_POST[$atributo]
                        ]);

                        $lastAttributeId = $pdo->lastInsertId();


                        // Adicionando os dados na tabela global
                        $url = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos.php";

                        $data = json_encode([
                            "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                            "id" => $lastAttributeId,
                            "id_produto" => $produto_id,
                            "nome_atributo" => $atributo_nome,
                            "id_atributo" => $atributo_id,
                            "valor_atributo" => $_POST[$atributo]
                        ]);

                        $ch = curl_init($url);
                        curl_setopt_array($ch, [
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_POST => true,
                            CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                            CURLOPT_POSTFIELDS => $data
                        ]);

                        echo curl_exec($ch);
                        curl_close($ch);
                    }
                }
            }
        }

        // NOVA LÓGICA para salvar atributos Shopee (baseada em processa_anuncio.php)
        $shopeeAttributesInput = isset($_POST['attributes']) && is_array($_POST['attributes']) ? $_POST['attributes'] : [];
        if (!empty($shopeeAttributesInput)) {
            foreach ($shopeeAttributesInput as $attrId => $attrValue) {
                $validAttrId = filter_var($attrId, FILTER_VALIDATE_INT);
                // Sanitizar valor bruto (se não for array)
                $sanitizedAttrValue = is_array($attrValue) ? null : trim(htmlspecialchars($attrValue ?? ''));

                if ($validAttrId !== false && $sanitizedAttrValue !== null && $sanitizedAttrValue !== '') {

                    // >> Recuperar o nome real do atributo enviado pelo JS <<
                    $attribute_name = isset($_POST['attributes_meta'][$validAttrId]['name'])
                        ? trim(htmlspecialchars($_POST['attributes_meta'][$validAttrId]['name']))
                        : "Atributo ID " . $validAttrId; // Fallback se o nome não for enviado

                    // Placeholder para unidade - Idealmente buscar do BD ou de dados da API armazenados
                    // Poderia ser enviado via JS também: $_POST['attributes_meta'][$validAttrId]['unit']
                    $value_unit_to_save = null;

                    // Determinar se o valor é um ID numérico ou texto
                    $isDigit = ctype_digit($sanitizedAttrValue);
                    $value_id_to_save = 0;
                    $original_value_name_to_save = null;

                    // Tratar ID 101197 (Nr. Homologação) sempre como texto
                    if ($validAttrId === 101197) {
                        $isDigit = false; // Força a tratar como texto
                    }

                    // Se for numérico E NÃO for ID 101197, assume ser um value_id (de select)
                    if ($isDigit) {
                        $value_id_to_save = intval($sanitizedAttrValue);
                        // Neste caso, o nome original idealmente viria da API, mas salvamos null por enquanto
                        $original_value_name_to_save = null;
                    } else {
                        // Se for texto (ou for ID 101197)
                        $value_id_to_save = 0;
                        $original_value_name_to_save = $sanitizedAttrValue;
                    }

                    // Inserir no banco de dados LOCAL
                    try {
                        $queryLocal = "INSERT INTO produtos_atributos_shopee (id_produto, attribute_id, attribute_name, value_id, original_value_name, value_unit) 
                                   VALUES (:id_produto, :attribute_id, :attribute_name, :value_id, :original_value_name, :value_unit)";
                        $stmtLocal = $pdo->prepare($queryLocal);
                        $stmtLocal->execute([
                            ':id_produto' => $produto_id,
                            ':attribute_id' => $validAttrId,
                            ':attribute_name' => $attribute_name, // Usando Placeholder
                            ':value_id' => $value_id_to_save,
                            ':original_value_name' => $original_value_name_to_save,
                            ':value_unit' => $value_unit_to_save // Usando Placeholder
                        ]);
                    } catch (PDOException $e) {
                        error_log("Erro ao inserir atributo Shopee local (ID: $validAttrId): " . $e->getMessage());
                        // Considerar como tratar o erro (continuar, parar, etc.)
                    }

                    // Adicionando os dados na tabela GLOBAL (Codefly API)
                    try {
                        $urlGlobal = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos_shopee.php";
                        $dataGlobal = json_encode([
                            "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                            'id_produto' => $produto_id,
                            'attribute_id' => $validAttrId,
                            'attribute_name' => $attribute_name, // Usando Placeholder
                            'attribute_value' => null, // Campo pode existir na API global
                            'value_id' => $value_id_to_save,
                            'original_value_name' => $original_value_name_to_save,
                            'value_unit' => $value_unit_to_save // Usando Placeholder
                        ]);

                        $chGlobal = curl_init($urlGlobal);
                        curl_setopt_array($chGlobal, [
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_POST => true,
                            CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                            CURLOPT_POSTFIELDS => $dataGlobal,
                            CURLOPT_TIMEOUT => 10 // Definir timeout para evitar travamentos
                        ]);

                        $responseGlobal = curl_exec($chGlobal);
                        if (curl_errno($chGlobal)) {
                            error_log("Erro cURL API Global Atributo Shopee (ID: $validAttrId): " . curl_error($chGlobal));
                        }
                        curl_close($chGlobal);
                        // Opcional: Logar resposta da API global
                        // error_log("Resposta API Global Atributo Shopee (ID: $validAttrId): " . $responseGlobal);
                    } catch (Exception $e) {
                        error_log("Erro Exception API Global Atributo Shopee (ID: $validAttrId): " . $e->getMessage());
                    }
                } // Fim if $validAttrId
            } // Fim foreach
        } // Fim if !empty($shopeeAttributesInput)
        // FIM NOVA LÓGICA


        // --- INÍCIO: Cadastro das variações como produtos filhos ---
        if (!empty($_POST['variacoes']) && is_array($_POST['variacoes'])) {
            $logfile = __DIR__ . '/log_variacoes.txt';
            // file_put_contents($logfile, "[VARIACAO] INICIOU cadastro de variacoes. Total: " . count($_POST['variacoes']) . "\n", FILE_APPEND);
            foreach ($_POST['variacoes'] as $i => $variacao) {
                $num = $i + 1;
                $sufixo = [];
                // Determina em qual coluna salvar o valor da variação
                $variacao_cor = null;
                $variacao_tamanho = null;
                if (!empty($variacao['tipo']) && !empty($variacao['valor'])) {
                    if (strtolower($variacao['tipo']) === 'cor') {
                        $variacao_cor = $variacao['valor'];
                        $sufixo[] = 'Cor: ' . $variacao_cor;
                    } else if (strtolower($variacao['tipo']) === 'tamanho') {
                        $variacao_tamanho = $variacao['valor'];
                        $sufixo[] = 'Tamanho: ' . $variacao_tamanho;
                    } else {
                        $sufixo[] = $variacao['tipo'] . ': ' . $variacao['valor'];
                    }
                }
                // Monta o sufixo final
                $sufixo_str = count($sufixo) > 0 ? ' - ' . implode(' - ', $sufixo) : '';
                // Calcula o espaço disponível para o título base
                $max_total = 60;
                $sufixo_len = mb_strlen($sufixo_str);
                $titulo_base = $titulo;
                if ($sufixo_len > 0 && mb_strlen($titulo_base) + $sufixo_len > $max_total) {
                    $titulo_base = mb_substr($titulo_base, 0, $max_total - $sufixo_len);
                }
                $titulo_variacao = $titulo_base . $sufixo_str;
                // Garante que não ultrapasse 60 caracteres (proteção extra)
                if (mb_strlen($titulo_variacao) > $max_total) {
                    $titulo_variacao = mb_substr($titulo_variacao, 0, $max_total);
                }
                // file_put_contents($logfile, "[VARIACAO] #$num Titulo: $titulo_variacao\n", FILE_APPEND);
                // preco_custo da variação pode ser individual
                $preco_custo_var = isset($variacao['preco_custo']) && $variacao['preco_custo'] !== '' ? str_replace(",", ".", $variacao['preco_custo']) : $preco_custo;
                $dados_var = [
                    'sensivel' => $sensivel,
                    'titulo' => $titulo_variacao,
                    'descricao' => $descricao,
                    'categoria_ml' => $categoria_ml,
                    'id_cat_ml' => $categoria_ml_id,
                    'category_domain' => $category_domain,
                    'categoria_interna' => $categoria_interna,
                    'sku' => $sku . 'VAR' . $num,
                    'fornecedor' => $fornecedor,
                    'sku_for' => $sku_fornecedor,
                    'categoria_shopee' => $categoria_shopee,
                    'sku_ml' => $sku . 'VAR' . $num,
                    'codigo_universal' => $codigo_universal,
                    'preco_custo' => $preco_custo_var,
                    'add_data' => date('Y-m-d H:i:s'),
                    'estoque' => $variacao['estoque'] ?? 0,
                    'ncm' => $ncm,
                    'altura' => $altura,
                    'largura' => $largura,
                    'comprimento' => $comprimento,
                    'peso' => $peso_completo,
                    'preco_custo_forn' => $preco_custo_forn,
                    'produto_pai' => $novo_id,
                    'is_filho' => 1,
                ];
                // Adiciona a cor ou tamanho na coluna correta
                if ($variacao_cor !== null) {
                    $dados_var['variacao_cor'] = $variacao_cor;
                }
                if ($variacao_tamanho !== null) {
                    $dados_var['variacao_tamanho'] = $variacao_tamanho;
                }
                $campos = array_keys($dados_var);
                $placeholders = array_map(function ($c) {
                    return ':' . $c;
                }, $campos);
                $query_var = "INSERT INTO produtos (" . implode(',', $campos) . ") VALUES (" . implode(',', $placeholders) . ")";
                // file_put_contents($logfile, "[VARIACAO] #$num SQL: $query_var\n", FILE_APPEND);
                // file_put_contents($logfile, "[VARIACAO] #$num Dados: " . json_encode($dados_var) . "\n", FILE_APPEND);
                try {
                    $stmt_var = $pdo->prepare($query_var);
                    $ok = $stmt_var->execute(array_combine($placeholders, array_values($dados_var)));
                    if ($ok) {
                        $id_ai_var = $pdo->lastInsertId();
                        $novo_id_var = pegaPrefixo() . $id_ai_var;
                        $pdo->prepare("UPDATE produtos SET id = :novo_id WHERE id_ai = :id_ai")
                            ->execute([':novo_id' => $novo_id_var, ':id_ai' => $id_ai_var]);
                        // file_put_contents($logfile, "[VARIACAO] #$num INSERIU produto filho com sucesso. ID AI: $id_ai_var, Novo ID: $novo_id_var\n", FILE_APPEND);
                        // echo "<script>console.log('[VARIACAO] #$num INSERIU produto filho com sucesso. ID AI: $id_ai_var, Novo ID: $novo_id_var');</script>";

                        // Enviar produto filho para API global
                        $url_var = "https://api-hom.codefly.site/api/v1/alteracao/produtos.php";
                        $data_var_array = [
                            "id" => $novo_id_var,
                            "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                            'sensivel' => $sensivel,
                            'titulo' => $titulo_variacao,
                            'marca' => '',
                            'modelo' => '',
                            'subcategoria_ml' => '',
                            'id_subcat_ml' => '',
                            'tipo_anuncio' => '',
                            'porcentagem_extra' => '',
                            'qtd_vendido' => 0,
                            'descricao' => $descricao,
                            'categoria_ml' => $categoria_ml,
                            'id_cat_ml' => $categoria_ml_id,
                            'category_domain' => $category_domain,
                            'categoria_interna' => $categoria_interna,
                            'sku' => $sku . 'VAR' . $num,
                            'fornecedor' => $fornecedor,
                            'sku_for' => $sku_fornecedor,
                            'categoria_shopee' => $categoria_shopee,
                            'sku_ml' => $sku . 'VAR' . $num,
                            'codigo_universal' => $codigo_universal,
                            'preco_custo' => $preco_custo_var,
                            'preco_custo_forn' => $preco_custo_forn,
                            'estoque' => $variacao['estoque'] ?? 0,
                            'ncm' => $ncm,
                            'altura' => $altura,
                            'largura' => $largura,
                            'comprimento' => $comprimento,
                            'peso' => $peso_completo,
                            'produto_pai' => $novo_id,
                            'is_filho' => 1,
                        ];
                        if ($variacao_cor !== null) {
                            $data_var_array['variacao_cor'] = $variacao_cor;
                        }
                        if ($variacao_tamanho !== null) {
                            $data_var_array['variacao_tamanho'] = $variacao_tamanho;
                        }
                        $data_var = json_encode($data_var_array);
                        // Envia variacao_cor e variacao_tamanho para API global se existirem
                        if ($variacao_cor !== null || $variacao_tamanho !== null) {
                            $url_var_attr = "https://api-hom.codefly.site/api/v1/alteracao/produtos_variacoes.php";
                            $data_var_attr = [
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                "produto_id" => $novo_id_var,
                            ];
                            if ($variacao_cor !== null) {
                                $data_var_attr['variacao_cor'] = $variacao_cor;
                            }
                            if ($variacao_tamanho !== null) {
                                $data_var_attr['variacao_tamanho'] = $variacao_tamanho;
                            }
                            $ch_var_attr = curl_init($url_var_attr);
                            curl_setopt_array($ch_var_attr, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => json_encode($data_var_attr)
                            ]);
                            curl_exec($ch_var_attr);
                            curl_close($ch_var_attr);
                        }
                        // Enviar imagens da variação para API global (igual ao produto principal)
                        $selectImgsVar = $pdo->prepare("SELECT id, imagem_url, ordem FROM produtos_imagens WHERE produto_id = :produto_id ORDER BY ordem ASC");
                        $selectImgsVar->execute([':produto_id' => $novo_id_var]);
                        $imagensVar = $selectImgsVar->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($imagensVar as $imgVar) {
                            $urlImgVar = "https://api-hom.codefly.site/api/v1/alteracao/produtos_imagens.php";
                            $dataImgVar = json_encode([
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                "id" => $imgVar['id'],
                                "imagem_url" => $imgVar['imagem_url'],
                                "produto_id" => $novo_id_var,
                                "ordem" => $imgVar['ordem']
                            ]);
                            $chImgVar = curl_init($urlImgVar);
                            curl_setopt_array($chImgVar, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => $dataImgVar
                            ]);
                            curl_exec($chImgVar);
                            curl_close($chImgVar);
                        }

                        // Enviar atributos Mercado Livre da variação para API global (igual ao produto principal)
                        $selectAttrVar = $pdo->prepare("SELECT id, nome_atributo, id_atributo, valor_atributo FROM produtos_atributos WHERE id_produto = :id_produto");
                        $selectAttrVar->execute([':id_produto' => $novo_id_var]);
                        $attrsVar = $selectAttrVar->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($attrsVar as $attrVar) {
                            $urlAttrVar = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos.php";
                            $dataAttrVar = json_encode([
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                "id" => $attrVar['id'],
                                "id_produto" => $novo_id_var,
                                "nome_atributo" => $attrVar['nome_atributo'],
                                "id_atributo" => $attrVar['id_atributo'],
                                "valor_atributo" => $attrVar['valor_atributo']
                            ]);
                            $chAttrVar = curl_init($urlAttrVar);
                            curl_setopt_array($chAttrVar, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => $dataAttrVar
                            ]);
                            curl_exec($chAttrVar);
                            curl_close($chAttrVar);
                        }

                        // Enviar atributos Shopee da variação para API global (igual ao produto principal)
                        $selectAttrShVar = $pdo->prepare("SELECT id, attribute_id, attribute_name, value_id, original_value_name, value_unit FROM produtos_atributos_shopee WHERE id_produto = :id_produto");
                        $selectAttrShVar->execute([':id_produto' => $novo_id_var]);
                        $attrsShVar = $selectAttrShVar->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($attrsShVar as $attrShVar) {
                            $urlAttrShVar = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos_shopee.php";
                            $dataAttrShVar = json_encode([
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                'id' => $attrShVar['id'],
                                'id_produto' => $novo_id_var,
                                'attribute_id' => $attrShVar['attribute_id'],
                                'attribute_name' => $attrShVar['attribute_name'],
                                'attribute_value' => null,
                                'value_id' => $attrShVar['value_id'],
                                'original_value_name' => $attrShVar['original_value_name'],
                                'value_unit' => $attrShVar['value_unit']
                            ]);
                            $chAttrShVar = curl_init($urlAttrShVar);
                            curl_setopt_array($chAttrShVar, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => $dataAttrShVar
                            ]);
                            curl_exec($chAttrShVar);
                            curl_close($chAttrShVar);
                        }
                        $ch_var = curl_init($url_var);
                        curl_setopt_array($ch_var, [
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_POST => true,
                            CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                            CURLOPT_POSTFIELDS => $data_var
                        ]);
                        $resp_var = curl_exec($ch_var);
                        curl_close($ch_var);

                        // Copiar atributos do pai para o filho (Mercado Livre)
                        $stmt_attr = $pdo->prepare("SELECT nome_atributo, id_atributo, valor_atributo FROM produtos_atributos WHERE id_produto = :id_pai");
                        $stmt_attr->execute([':id_pai' => $produto_id]);
                        $attrs_pai = $stmt_attr->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($attrs_pai as $attr) {
                            $query_attr = "INSERT INTO produtos_atributos (id_produto, nome_atributo, id_atributo, valor_atributo) VALUES (:id_produto, :nome_atributo, :id_atributo, :valor_atributo)";
                            $stmt_attr_ins = $pdo->prepare($query_attr);
                            $stmt_attr_ins->execute([
                                ':id_produto' => $novo_id_var,
                                ':nome_atributo' => $attr['nome_atributo'],
                                ':id_atributo' => $attr['id_atributo'],
                                ':valor_atributo' => $attr['valor_atributo']
                            ]);
                            // Buscar o último atributo inserido para pegar o ID
                            $lastAttrId = $pdo->lastInsertId();
                            // Enviar para API global
                            $url_attr = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos.php";
                            $data_attr = json_encode([
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                "id" => $lastAttrId,
                                "id_produto" => $novo_id_var,
                                "nome_atributo" => $attr['nome_atributo'],
                                "id_atributo" => $attr['id_atributo'],
                                "valor_atributo" => $attr['valor_atributo']
                            ]);
                            $ch_attr = curl_init($url_attr);
                            curl_setopt_array($ch_attr, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => $data_attr
                            ]);
                            curl_exec($ch_attr);
                            curl_close($ch_attr);
                        }

                        // Copiar atributos Shopee do pai para o filho
                        $stmt_attr_sh = $pdo->prepare("SELECT attribute_id, attribute_name, value_id, original_value_name, value_unit FROM produtos_atributos_shopee WHERE id_produto = :id_pai");
                        $stmt_attr_sh->execute([':id_pai' => $produto_id]);
                        $attrs_shopee_pai = $stmt_attr_sh->fetchAll(PDO::FETCH_ASSOC);
                        foreach ($attrs_shopee_pai as $attr_sh) {
                            $query_attr_sh = "INSERT INTO produtos_atributos_shopee (id_produto, attribute_id, attribute_name, value_id, original_value_name, value_unit) VALUES (:id_produto, :attribute_id, :attribute_name, :value_id, :original_value_name, :value_unit)";
                            $stmt_attr_sh_ins = $pdo->prepare($query_attr_sh);
                            $stmt_attr_sh_ins->execute([
                                ':id_produto' => $novo_id_var,
                                ':attribute_id' => $attr_sh['attribute_id'],
                                ':attribute_name' => $attr_sh['attribute_name'],
                                ':value_id' => $attr_sh['value_id'],
                                ':original_value_name' => $attr_sh['original_value_name'],
                                ':value_unit' => $attr_sh['value_unit']
                            ]);
                            // Buscar o último atributo Shopee inserido para pegar o ID
                            $lastAttrShId = $pdo->lastInsertId();
                            // Enviar para API global Shopee
                            $url_attr_sh = "https://api-hom.codefly.site/api/v1/alteracao/produtos_atributos_shopee.php";
                            $data_attr_sh = json_encode([
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                'id' => $lastAttrShId,
                                'id_produto' => $novo_id_var,
                                'attribute_id' => $attr_sh['attribute_id'],
                                'attribute_name' => $attr_sh['attribute_name'],
                                'attribute_value' => null,
                                'value_id' => $attr_sh['value_id'],
                                'original_value_name' => $attr_sh['original_value_name'],
                                'value_unit' => $attr_sh['value_unit']
                            ]);
                            $ch_attr_sh = curl_init($url_attr_sh);
                            curl_setopt_array($ch_attr_sh, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => $data_attr_sh
                            ]);
                            curl_exec($ch_attr_sh);
                            curl_close($ch_attr_sh);
                        }
                    } else {
                        // file_put_contents($logfile, "[VARIACAO][ERRO] #$num NAO INSERIU produto filho. PDO execute retornou false.\n", FILE_APPEND);
                        // echo "<script>console.log('[VARIACAO][ERRO] #$num NAO INSERIU produto filho. PDO execute retornou false.');</script>";
                    }
                } catch (PDOException $e) {
                    // file_put_contents($logfile, "[VARIACAO][ERRO] #$num Falha ao inserir: " . $e->getMessage() . "\n", FILE_APPEND);
                    // echo "<script>console.log('[VARIACAO][ERRO] #$num Falha ao inserir: " . addslashes($e->getMessage()) . "');</script>";
                    continue;
                }
                // Imagem da variação
                if (isset($_FILES['variacoes']['error'][$i]['imagem']) && $_FILES['variacoes']['error'][$i]['imagem'] === UPLOAD_ERR_OK) {
                    $tmp_name = $_FILES['variacoes']['tmp_name'][$i]['imagem'];
                    $name = $_FILES['variacoes']['name'][$i]['imagem'];
                    $document_root = $_SERVER['DOCUMENT_ROOT'];
                    $produtos_dir = $document_root . "/images/produtos_imagens/";
                    $upload_dir = $produtos_dir . $novo_id_var . "/";
                    if (!file_exists($upload_dir)) {
                        if (mkdir($upload_dir, 0777, true)) {
                            // file_put_contents($logfile, "[VARIACAO] #$num Criou diretório imagem: $upload_dir\n", FILE_APPEND);
                        } else {
                            // file_put_contents($logfile, "[VARIACAO][ERRO] #$num Falha mkdir: $upload_dir\n", FILE_APPEND);
                        }
                    }
                    $image_name = $novo_id_var . "_1.jpg";
                    $dest_file = $upload_dir . $image_name;
                    if (resizeImageToSquare($tmp_name, $dest_file)) {
                        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
                        $dominio = $_SERVER['HTTP_HOST'];
                        $final_image_url = $protocol . '://' . $dominio . "/images/produtos_imagens/{$novo_id_var}/{$image_name}";
                        $id_unico = uniqid('', true);
                        $insertImg = "INSERT INTO produtos_imagens (id, produto_id, imagem_url, ordem) VALUES (:id, :produto_id, :imagem_url, :ordem)";
                        try {
                            $pdo->prepare($insertImg)->execute([
                                ':id' => $id_unico,
                                ':produto_id' => $novo_id_var,
                                ':imagem_url' => $final_image_url,
                                ':ordem' => 1
                            ]);
                            // Enviar imagem para API global imediatamente após inserir
                            $urlImgVar = "https://api-hom.codefly.site/api/v1/alteracao/produtos_imagens.php";
                            $dataImgVar = json_encode([
                                "token" => "api_dropbubctfYv2FBaF2NXp4q!2xrZMXL3/WnDOgZ=a73idhYu!jcmkeKIcJed",
                                "id" => $id_unico,
                                "imagem_url" => $final_image_url,
                                "produto_id" => $novo_id_var,
                                "ordem" => 1
                            ]);
                            $chImgVar = curl_init($urlImgVar);
                            curl_setopt_array($chImgVar, [
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_POST => true,
                                CURLOPT_HTTPHEADER => ["Content-Type: application/json", "Accept: application/json"],
                                CURLOPT_POSTFIELDS => $dataImgVar
                            ]);
                            curl_exec($chImgVar);
                            curl_close($chImgVar);
                            // file_put_contents($logfile, "[VARIACAO] #$num Imagem salva e registrada no banco e enviada para API global. URL: $final_image_url\n", FILE_APPEND);
                            // echo "<script>console.log('[VARIACAO] #$num Imagem salva e registrada no banco e enviada para API global. URL: $final_image_url');</script>";
                        } catch (PDOException $e) {
                            // file_put_contents($logfile, "[VARIACAO][ERRO] #$num Falha ao inserir imagem: " . $e->getMessage() . "\n", FILE_APPEND);
                            // echo "<script>console.log('[VARIACAO][ERRO] #$num Falha ao inserir imagem: " . addslashes($e->getMessage()) . "');</script>";
                        }
                    } else {
                        // file_put_contents($logfile, "[VARIACAO][ERRO] #$num Falha ao redimensionar/salvar imagem: $dest_file\n", FILE_APPEND);
                        // echo "<script>console.log('[VARIACAO][ERRO] #$num Falha ao redimensionar/salvar imagem: $dest_file');</script>";
                    }
                } else {
                    // file_put_contents($logfile, "[VARIACAO] #$num Nenhuma imagem enviada ou erro no upload.\n", FILE_APPEND);
                    // echo "<script>console.log('[VARIACAO] #$num Nenhuma imagem enviada ou erro no upload.');</script>";
                }
            }
            // file_put_contents($logfile, "[VARIACAO] FIM do cadastro de variacoes.\n", FILE_APPEND);
            // echo "<script>console.log('[VARIACAO] FIM do cadastro de variacoes.');</script>";
        }
        // --- FIM: Cadastro das variações ---
        sendAlert("Produto adicionado com sucesso!", "success", "/dash/adicionar_produtos");
        exit();
    }
    ?>

    <script>
        $(document).ready(function() {
            // Função para adicionar o botão de remoção nas imagens carregadas
            // Esta função não é mais necessária aqui, pois o botão é adicionado dinamicamente.
            // function adicionarBotaoRemocao() { ... }

            // Chama a função após carregar as imagens automaticamente
            // $('.submit_button').click(function() { ... });

            // Garante que o botão de remoção seja adicionado ao carregar a página
            // adicionarBotaoRemocao();

            // Inicializar SortableJS no container de imagens
            const imageContainerSortable = document.getElementById('images_container');
            if (imageContainerSortable) {
                Sortable.create(imageContainerSortable, {
                    animation: 150, // Animação durante o arrastar
                    handle: '.imagem-card-add img', // Elemento que pode ser usado para arrastar
                    draggable: '.imagem-card-add', // Especifica quais itens são arrastáveis
                    onEnd: function(evt) {
                        // A ordem dos inputs hidden "ordered_ml_images[]" já é atualizada
                        // automaticamente pela reordenação dos elementos no DOM.
                        // Nenhuma ação extra é necessária aqui para manter a ordem das URLs do ML.
                    }
                });
            }
        });

        // Função para remover imagem (tanto do ML quanto de upload, se adaptada no futuro)
        function removerImagemAdicionar(buttonElement) {
            const card = buttonElement.closest('.imagem-card-add');
            if (card) {
                card.remove();
                // Mostrar inputs de upload se o número de imagens for menor que 9
                if ($('#images_container .imagem-card-add').length < 9) {
                    $('#formFileMultipleAdd, #formFileAddSmall').show();
                }
            }
        }
    </script>

    <!-- NOVO SCRIPT PARA CATEGORIAS/ATRIBUTOS SHOPEE (baseado em shopee_dynamic.php) -->
    <script>
        // Variáveis para busca de categoria Shopee
        let shopeeSearchTimeout;
        let shopeeCurrentRequest;
        let shopeeDropdownInstance;

        // Seletores para os elementos
        const nomeProdutoShopeeInput = document.getElementById('nome_produto_shopee');
        const shopeeSearchDropdown = document.getElementById('shopee-search-dropdown');
        const shopeeErrorMessage = document.getElementById('shopee-error-message');
        const shopeeInfoDiv = document.getElementById('shopee-info');
        const categoriaHiddenInput = document.getElementById('id_shopee');
        const categoriaDisplayInput = document.getElementById('categoria_shopee_display');
        const atributosUl = document.getElementById('atributos-obrigatorios');

        // Initialize Bootstrap dropdown quando a página carregar
        document.addEventListener('DOMContentLoaded', function() {
            if (nomeProdutoShopeeInput) {
                shopeeDropdownInstance = new bootstrap.Dropdown(nomeProdutoShopeeInput);

                // Event listener para o input de busca com debounce melhorado
                nomeProdutoShopeeInput.addEventListener('input', function() {
                    const query = this.value.trim();

                    // Clear previous timeout
                    clearTimeout(shopeeSearchTimeout);

                    // Cancel previous request
                    if (shopeeCurrentRequest) {
                        shopeeCurrentRequest.abort();
                    }

                    if (query.length < 3) {
                        shopeeDropdownInstance.hide();
                        return;
                    }

                    // Show loading
                    showShopeeLoading();

                    // Set timeout for search com debounce de 800ms para melhor performance
                    shopeeSearchTimeout = setTimeout(() => {
                        searchShopeeCategories(query);
                    }, 800); // 800ms delay para debounce mais eficiente
                });

                // Prevent dropdown from closing when typing
                nomeProdutoShopeeInput.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape') {
                        shopeeDropdownInstance.hide();
                    }
                });
            }

            // Sincronização unidirecional dos campos de nome com debounce
            const nomeProdutoInput = document.getElementById('nome_produto');
            if (nomeProdutoInput && nomeProdutoShopeeInput) {
                let nomeProdutoTimeout; // Timeout para debounce do nome_produto

                // Quando nome_produto_shopee é alterado, NÃO sincroniza com nome_produto
                // (removida a sincronização reversa conforme solicitado)

                // Quando nome_produto é alterado, aguarda 1 segundo e sincroniza com nome_produto_shopee
                nomeProdutoInput.addEventListener('input', function() {
                    const valor = this.value;
                    
                    // Clear previous timeout
                    clearTimeout(nomeProdutoTimeout);
                    
                    // Set timeout para aguardar 1 segundo após parar de digitar
                    nomeProdutoTimeout = setTimeout(() => {
                        // Só preenche o nome_produto_shopee se o valor ainda for o mesmo
                        if (nomeProdutoInput.value === valor) {
                            nomeProdutoShopeeInput.value = valor;
                            console.log('Nome sincronizado após 1 segundo:', valor); // Debug
                            
                            // Disparar busca automática de categoria Shopee se tiver valor
                            if (valor.trim().length >= 3) {
                                console.log('Iniciando busca automática de categoria Shopee para:', valor); // Debug

                                // Clear previous search timeout
                                clearTimeout(shopeeSearchTimeout);

                                // Cancel previous request
                                if (shopeeCurrentRequest) {
                                    shopeeCurrentRequest.abort();
                                }

                                // Show loading
                                showShopeeLoading();

                                // Set timeout for search
                                shopeeSearchTimeout = setTimeout(() => {
                                    searchShopeeCategories(valor.trim());
                                }, 500); // 500ms delay após já ter aguardado 1s
                            } else if (valor.trim().length === 0) {
                                // Limpar busca se campo estiver vazio
                                shopeeDropdownInstance.hide();
                                clearShopeeSelection();
                            }
                        }
                    }, 1000); // 1 segundo de debounce conforme solicitado
                });
            }
        });

        function searchShopeeCategories(keyword) {
            // Create FormData for POST request
            const formData = new FormData();
            formData.append('keyword', keyword);
            formData.append('all_pages', '0'); // Primeira página apenas

            // Create AJAX request
            shopeeCurrentRequest = new XMLHttpRequest();
            shopeeCurrentRequest.open('POST', '../../get-produtos/api.php', true);

            shopeeCurrentRequest.onload = function() {
                if (this.status === 200) {
                    try {
                        const response = JSON.parse(this.responseText);

                        if (response.success) {
                            showShopeeResults(response.data.categories);
                            hideShopeeError();
                        } else {
                            showShopeeError(response.error);
                            shopeeDropdownInstance.hide();
                        }
                    } catch (e) {
                        showShopeeError('Erro ao processar resposta do servidor');
                        shopeeDropdownInstance.hide();
                    }
                } else {
                    showShopeeError('Erro na requisição: ' + this.status);
                    shopeeDropdownInstance.hide();
                }
                shopeeCurrentRequest = null;
            };

            shopeeCurrentRequest.onerror = function() {
                showShopeeError('Erro de conexão');
                shopeeDropdownInstance.hide();
                shopeeCurrentRequest = null;
            };

            shopeeCurrentRequest.onabort = function() {
                shopeeCurrentRequest = null;
            };

            shopeeCurrentRequest.send(formData);
        }

        function showShopeeLoading() {
            shopeeSearchDropdown.innerHTML = `
                <li class="dropdown-item-text p-3 text-center">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="spinner-border spinner-border-sm text-primary me-2" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <span class="text-muted">Buscando categorias Shopee...</span>
                    </div>
                </li>
            `;
            shopeeDropdownInstance.show();
        }

        function showShopeeResults(categories) {
            if (!categories || categories.length === 0) {
                shopeeSearchDropdown.innerHTML = `
                    <li class="dropdown-item-text p-3 text-center text-muted fst-italic">
                        <i class="bi bi-search me-2"></i>
                        Nenhuma categoria encontrada
                    </li>
                `;
                shopeeDropdownInstance.show();
                return;
            }

            let html = '';
            categories.forEach((category, index) => {
                const fullTitle = category.full_title || category.name;
                const pathText = category.full_path_text || '';

                html += `
                    <li>
                        <a class="dropdown-item py-3" href="#" onclick="selectShopeeCategory('${category.id}', '${escapeHtml(fullTitle)}'); return false;">
                            <div class="fw-semibold text-dark mb-1">
                                <i class="bi bi-tag-fill text-primary me-2"></i>
                                ${escapeHtml(category.name)}
                            </div>
                            ${pathText ? `<div class="small text-muted mb-1"><i class="bi bi-arrow-right me-1"></i>${escapeHtml(pathText)}</div>` : ''}
                            <div class="small">
                                <span class="badge bg-secondary">ID: ${category.id}</span>
                            </div>
                        </a>
                    </li>
                `;
            });

            shopeeSearchDropdown.innerHTML = html;
            shopeeDropdownInstance.show();

            // Comentado: Auto-seleção removida conforme solicitado
            // A primeira categoria não será mais selecionada automaticamente
            // O usuário deve escolher manualmente qual categoria deseja
        }

        function selectShopeeCategory(categoryId, categoryName, isAutoSelected = false) {
            console.log('Categoria selecionada:', categoryId, categoryName, isAutoSelected ? '(auto-selecionada)' : '(manual)'); // Debug log

            // Fill the hidden input with ID
            categoriaHiddenInput.value = categoryId;

            // Update display input with category name
            categoriaDisplayInput.value = categoryName;

            // Update search input with category name
            nomeProdutoShopeeInput.value = categoryName;

            // Hide dropdown
            shopeeDropdownInstance.hide();

            // Hide error if any
            hideShopeeError();

            // Se foi auto-selecionada, adicionar indicação visual temporária
            if (isAutoSelected) {
                categoriaDisplayInput.style.backgroundColor = '#e3f2fd';
                categoriaDisplayInput.setAttribute('title', 'Categoria selecionada automaticamente - clique para pesquisar outras opções');
                setTimeout(() => {
                    categoriaDisplayInput.style.backgroundColor = '';
                    categoriaDisplayInput.removeAttribute('title');
                }, 3000);
            }

            // Buscar atributos da categoria selecionada
            console.log('Iniciando busca de atributos para categoria:', categoryId); // Debug log
            buscarAtributosShopee(categoryId);
        }

        function clearShopeeSelection() {
            categoriaHiddenInput.value = '';
            categoriaDisplayInput.value = '';
            nomeProdutoShopeeInput.value = '';
            shopeeDropdownInstance.hide();
            hideShopeeError();

            // Limpar atributos
            document.querySelectorAll('.atributo-dinamico-group').forEach(el => el.remove());
            if (atributosUl) atributosUl.innerHTML = '';
        }

        function showShopeeError(message) {
            const errorText = document.getElementById('shopee-error-text');
            errorText.textContent = message;
            shopeeErrorMessage.classList.remove('d-none');
        }

        function hideShopeeError() {
            shopeeErrorMessage.classList.add('d-none');
        }

        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }

        // Manter as funções existentes de busca de atributos
        async function buscarAtributosShopee(categoryId) {
            console.log('Buscando atributos para categoria:', categoryId); // Debug log

            // Remover campos de atributos dinâmicos antigos
            document.querySelectorAll('.atributo-dinamico-group').forEach(el => el.remove());
            if (atributosUl) atributosUl.innerHTML = 'Buscando atributos Shopee...'; // Feedback

            try {
                // Ajustar o caminho para o script PHP
                const response = await fetch('../../assets/ajax/plataformas/shopee/fetch_attributes.php?category_id=' +
                    encodeURIComponent(categoryId));

                console.log('Resposta da API de atributos:', response.status, response.ok); // Debug log

                if (!response.ok) {
                    throw new Error('Erro de rede (' + response.status + ') ao buscar atributos Shopee.');
                }
                const data = await response.json();

                console.log('Dados de atributos recebidos:', data); // Debug log

                if (data.error && data.error !== '' && data.error !== '-') {
                    let errorMsg = data.message || data.error;
                    if (data.http_code) errorMsg += ` (HTTP ${data.http_code})`;
                    if (data.request_id) errorMsg += ` (Request ID: ${data.request_id})`;
                    throw new Error('Erro API Shopee: ' + errorMsg);
                }

                // Novo parser para a estrutura Shopee v2 (attribute_tree)
                let atributosShopee = [];
                if (data.response && Array.isArray(data.response.list) && data.response.list.length > 0 && Array.isArray(data.response.list[0].attribute_tree)) {
                    // Mapeia cada atributo para o formato esperado pelo front
                    atributosShopee = data.response.list[0].attribute_tree.map(attr => {
                        // input_type: 0=TEXT_FIELD, 1=DROP_DOWN, 2=COMBO_BOX, 3=MULTIPLE_SELECT_COMBO_BOX
                        let inputTypeStr = 'TEXT_FIELD';
                        if (attr.attribute_info && typeof attr.attribute_info.input_type === 'number') {
                            switch (attr.attribute_info.input_type) {
                                case 1:
                                    inputTypeStr = 'DROP_DOWN';
                                    break;
                                case 2:
                                    inputTypeStr = 'COMBO_BOX';
                                    break;
                                case 3:
                                    inputTypeStr = 'MULTIPLE_SELECT_COMBO_BOX';
                                    break;
                                default:
                                    inputTypeStr = 'TEXT_FIELD';
                            }
                        }
                        // Monta lista de valores
                        let valueList = [];
                        if (Array.isArray(attr.attribute_value_list)) {
                            valueList = attr.attribute_value_list.map(val => ({
                                value_id: val.value_id,
                                original_value_name: val.name || val.value_id
                            }));
                        }
                        return {
                            attribute_id: attr.attribute_id,
                            display_attribute_name: attr.name,
                            original_attribute_name: attr.name,
                            is_mandatory: !!attr.mandatory,
                            input_type: inputTypeStr,
                            attribute_value_list: valueList
                        };
                    });
                } else if (data.response && Array.isArray(data.response.attribute_list)) {
                    atributosShopee = data.response.attribute_list;
                }
                if (!Array.isArray(atributosShopee) || atributosShopee.length === 0) {
                    console.warn("Resposta inesperada de buscar_atributos.php:", data);
                    throw new Error('Resposta inesperada do servidor (atributos Shopee).');
                }
                console.log('Gerando campos para', atributosShopee.length, 'atributos obrigatórios');
                gerarCamposAtributosShopee(atributosShopee);

            } catch (error) {
                console.error("Erro ao buscar atributos Shopee:", error);
                if (atributosUl) atributosUl.innerHTML = `<li style="color:red;">Erro: ${error.message}</li>`;
                else if (shopeeInfoDiv) {
                    // Se UL não existir, mostra erro na div principal
                    const errorP = document.createElement('p');
                    errorP.style.color = 'red';
                    errorP.textContent = `Erro ao buscar atributos: ${error.message}`;
                    // Limpa a div antes de adicionar o erro
                    while (shopeeInfoDiv.firstChild) {
                        if (shopeeInfoDiv.firstChild.nodeName !== 'P' || !shopeeInfoDiv.firstChild.textContent.includes(
                                'Atributos')) {
                            // Não remove o título <p><strong>Atributos...</strong></p>
                            shopeeInfoDiv.removeChild(shopeeInfoDiv.firstChild);
                        }
                    }
                    shopeeInfoDiv.appendChild(errorP);
                }
            }
        }

        function gerarCamposAtributosShopee(atributos) {
            if (atributosUl) atributosUl.innerHTML = ''; // Limpa o status de carregamento
            // Remover campos de atributos DINÂMICOS antigos (incluindo o de homologação)
            document.querySelectorAll('.atributo-dinamico-group').forEach(el => el.remove());

            let homologacaoEncontrado = false;
            let fabricanteEncontrado = false;
            let atributosObrigatoriosRenderizados = 0;

            if (!shopeeInfoDiv) return; // Sai se a div principal não existe

            // 1. Iterar para encontrar e criar os campos específicos (Homologação e Fabricante)
            atributos.forEach(attr => {
                let campoEspecificoCriado = false;
                let divGroup;

                // Verifica Homologação
                if (attr.attribute_id === 101197) {
                    homologacaoEncontrado = true;
                    divGroup = document.createElement('div');
                    divGroup.className = 'form-group atributo-dinamico-group mb-3'; // Classe e margem

                    const label = document.createElement('label');
                    label.className = 'form-label';
                    label.textContent = `${attr.display_attribute_name || attr.original_attribute_name}:`;
                    label.htmlFor = `attribute_${attr.attribute_id}`;

                    const input = document.createElement('input');
                    input.type = 'text';
                    input.className = 'form-control';
                    input.id = `attribute_${attr.attribute_id}`;
                    input.name = `attributes[${attr.attribute_id}]`; // Nome correto para POST
                    // input.required = attr.is_mandatory;

                    // >> ADICIONAR input hidden para o NOME do atributo
                    const hiddenNameInput = document.createElement('input');
                    hiddenNameInput.type = 'hidden';
                    hiddenNameInput.name = `attributes_meta[${attr.attribute_id}][name]`; // Nome para metadados
                    hiddenNameInput.value = attr.display_attribute_name || attr.original_attribute_name || ''; // Pegar o nome real

                    divGroup.appendChild(label);
                    divGroup.appendChild(input);
                    divGroup.appendChild(hiddenNameInput); // Adiciona o input hidden
                    campoEspecificoCriado = true;
                }
                // Verifica Fabricante
                else if (attr.attribute_id === 101237) {
                    fabricanteEncontrado = true;
                    divGroup = document.createElement('div');
                    divGroup.className = 'form-group atributo-dinamico-group mb-3';

                    const label = document.createElement('label');
                    label.className = 'form-label d-none';
                    label.textContent = `${attr.display_attribute_name || attr.original_attribute_name}:`;
                    label.htmlFor = `attribute_${attr.attribute_id}`;

                    const input = criarCampoInputAtributoShopee(attr);

                    // >> DEFINIR VALOR PADRÃO PARA FABRICANTE <<
                    input.value = '<?php echo Config::get('site_configs.name'); ?>'; // Pré-preenche o campo
                    input.classList.add('d-none');


                    // >> ADICIONAR input hidden para o NOME do atributo
                    const hiddenNameInput = document.createElement('input');
                    hiddenNameInput.type = 'hidden';
                    hiddenNameInput.name = `attributes_meta[${attr.attribute_id}][name]`;
                    hiddenNameInput.value = attr.display_attribute_name || attr.original_attribute_name || '';

                    divGroup.appendChild(label);
                    divGroup.appendChild(input);
                    divGroup.appendChild(hiddenNameInput); // Adiciona o input hidden
                    // Se for COMBO_BOX, pode precisar adicionar o datalist ao DOM
                    if (input.tagName === 'INPUT' && input.getAttribute('list')) {
                        const dataListId = input.getAttribute('list');
                        const dataList = document.getElementById(dataListId);
                        if (dataList) divGroup.appendChild(dataList); // Anexa ao grupo
                    }
                    campoEspecificoCriado = true;
                }

                // Insere o campo específico criado no DOM, dentro de shopeeInfoDiv
                if (campoEspecificoCriado && divGroup) {
                    shopeeInfoDiv.appendChild(divGroup);
                }
            });

            // 2. Iterar novamente para criar campos para OUTROS atributos obrigatórios
            const outrosAtributosObrigatorios = atributos.filter(
                attr => attr.is_mandatory &&
                attr.attribute_id !== 101197 &&
                attr.attribute_id !== 101237
            );

            if (outrosAtributosObrigatorios.length > 0) {
                outrosAtributosObrigatorios.forEach(attr => {
                    atributosObrigatoriosRenderizados++;
                    const divGroup = document.createElement('div');
                    divGroup.className = 'form-group atributo-dinamico-group mb-3';

                    const label = document.createElement('label');
                    label.className = 'form-label';
                    label.textContent = `${attr.display_attribute_name || attr.original_attribute_name}: *`; // Indica obrigatório
                    label.htmlFor = `attribute_${attr.attribute_id}`;

                    const input = criarCampoInputAtributoShopee(attr);
                    if (input) input.required = true; // Garante que seja marcado como obrigatório

                    // >> ADICIONAR input hidden para o NOME do atributo
                    const hiddenNameInput = document.createElement('input');
                    hiddenNameInput.type = 'hidden';
                    hiddenNameInput.name = `attributes_meta[${attr.attribute_id}][name]`;
                    hiddenNameInput.value = attr.display_attribute_name || attr.original_attribute_name || '';

                    divGroup.appendChild(label);
                    divGroup.appendChild(input);
                    divGroup.appendChild(hiddenNameInput); // Adiciona o input hidden
                    // Se for COMBO_BOX, anexa datalist ao grupo
                    if (input.tagName === 'INPUT' && input.getAttribute('list')) {
                        const dataListId = input.getAttribute('list');
                        const dataList = document.getElementById(dataListId);
                        if (dataList) divGroup.appendChild(dataList);
                    }

                    shopeeInfoDiv.appendChild(divGroup);
                });
            }

            // Mensagem se nenhum atributo for encontrado/renderizado
            if (!homologacaoEncontrado && !fabricanteEncontrado && atributosObrigatoriosRenderizados === 0) {
                const noAttrMsg = document.createElement('p');
                noAttrMsg.className = 'text-muted atributo-dinamico-group';
                noAttrMsg.textContent = 'Nenhum atributo obrigatório ou específico (Homologação, Fabricante) encontrado para esta categoria Shopee.';
                shopeeInfoDiv.appendChild(noAttrMsg);
            }
        }

        // Função auxiliar para criar diferentes tipos de input baseados no atributo Shopee
        function criarCampoInputAtributoShopee(attr) {
            let input;
            const inputId = `attribute_${attr.attribute_id}`;
            const inputName = `attributes[${attr.attribute_id}]`; // Nome para POST

            switch (attr.input_type) {
                case 'DROP_DOWN':
                    input = document.createElement('select');
                    input.className = 'form-select';
                    input.id = inputId;
                    input.name = inputName;
                    // input.required = attr.is_mandatory; // Será definido no loop principal se for obrigatório

                    const defaultOption = document.createElement('option');
                    defaultOption.value = '';
                    defaultOption.textContent = '-- Selecione --';
                    defaultOption.disabled = true;
                    defaultOption.selected = true;
                    input.appendChild(defaultOption);

                    if (attr.attribute_value_list) {
                        attr.attribute_value_list.forEach(val => {
                            const option = document.createElement('option');
                            option.value = val.value_id; // Enviar value_id
                            option.textContent = val.original_value_name || `ID: ${val.value_id}`;
                            input.appendChild(option);
                        });
                    }
                    break;

                case 'MULTIPLE_SELECT_COMBO_BOX': // Tratar como select múltiplo se necessário
                case 'COMBO_BOX':
                    input = document.createElement('input');
                    input.type = 'text';
                    input.className = 'form-control';
                    input.id = inputId;
                    input.name = inputName;
                    // input.required = attr.is_mandatory;
                    input.setAttribute('list', `datalist_${attr.attribute_id}`);

                    // Cria o datalist, mas não anexa aqui, será anexado no loop principal
                    const dataList = document.createElement('datalist');
                    dataList.id = `datalist_${attr.attribute_id}`;
                    if (attr.attribute_value_list) {
                        attr.attribute_value_list.forEach(val => {
                            const option = document.createElement('option');
                            option.value = val.original_value_name || `ID: ${val.value_id}`;
                            dataList.appendChild(option);
                        });
                    }
                    // Anexa ao body para garantir que esteja disponível
                    // document.body.appendChild(dataList);
                    break;

                case 'TEXT_FILED': // Corrigido typo potencial (FIELD)
                case 'TEXT_FIELD':
                default:
                    input = document.createElement('input');
                    input.type = 'text';
                    input.className = 'form-control';
                    input.id = inputId;
                    input.name = inputName;
                    // input.required = attr.is_mandatory;
                    break;
            }
            return input;
        }
    </script>
    <!-- FIM NOVO SCRIPT -->

    <script>
        // REMOVER/COMENTAR Listener antigo do botão de atributos Shopee
        /*
        $(document).ready(function() {
            $('.atributos_shopee').on('click', function(e) {
                e.preventDefault();
                const categoryId = $('#id_shopee').val();

                $.ajax({
                    url: '../../assets/ajax/plataformas/shopee/fetch_attributes.php',
                    type: 'POST',
                    data: {
                        category_id: categoryId
                    },
                    success: function(response) {
                        $('#attributesResult').html(response);
                    },
                    error: function() {
                        $('#attributesResult').html('<p style="color:red">Erro ao buscar atributos.</p>');
                    }
                });
            });
        });
        */
    </script>

    <?php
    // REMOVER/COMENTAR Bloco antigo de salvar atributos shopee (será substituído)
    /*
    if ($_POST && isset($_POST['ADD'])) {
        // ... (código antigo de processamento POST) ...

        // Salvar atributos Shopee vindos do fetch_attributes.php
        // Modificado para iterar sobre $_POST e encontrar chaves 'shopee_attr_'
        foreach ($_POST as $key => $attrData) {
            // Verifica se a chave começa com 'shopee_attr_' e se o valor é um array
            if (strpos($key, 'shopee_attr_') === 0 && is_array($attrData)) {
                 // ... (lógica antiga de salvar atributos) ...
            }
        }

        // ... (resto do código antigo) ...
        sendAlert("Produto adicionado com sucesso!", "success", "/dash/adicionar_produtos");
        exit();
    }
    */
    ?>


</body>

</html>