<?php
session_start();
date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');

require '../../class/walletClass.php';
require '../../class/getPlanosConfig.php';
require '../../class/vendasClass.php';
require '../../class/produtosClass.php';

// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

if ($_SESSION['usuario']['is_adm'] != '1') {
    header('Location: /dash/dashboard');
    exit();
}

$query = "SELECT id, ativo, configuracao FROM planos_assinatura";
$stmt = $pdo->query($query);
$planos_temp = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Filtrar planos gratuitos da listagem
$planos = [];
foreach ($planos_temp as $plano) {
    $config = json_decode($plano['configuracao'], true);
    $nome_plano = $config['dados_plano'][0]['nome'] ?? '';
    
    // Não incluir na listagem se o nome contém "gratuito"
    if (stripos($nome_plano, 'gratuito') === false && stripos($nome_plano, 'grátis') === false) {
        $planos[] = $plano;
    }
}


// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);

?>


<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter">

<head>
    <?php include('../../includes/dashHead.php'); ?>

    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>
                    </div>
                </nav>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="alert alert-warning p-4 rounded shadow">
                                <h4 class="alert-heading ">⚠ Atenção!</h4>
                                <p class="mb-3">Configure os Webhooks da sua Plataforma de Pagamento:</p>
                                <hr>
                                <div>
                                    <?php
                                    $dominio = $_SERVER['HTTP_HOST'];
                                    $kiwifyWebhook = "https://{$dominio}/routes/webhooks.php?p=".base64_encode('kiwify')."&w=".base64_encode($dominio);
                                    $hublaWebhook = "https://{$dominio}/routes/webhooks.php?p=".base64_encode('hubla')."&w=".base64_encode($dominio);
                                    $kirvanoWebhook = "https://{$dominio}/routes/webhooks.php?p=".base64_encode('kirvano')."&w=".base64_encode($dominio);

                                    function mascararWebhook($url)
                                    {
                                        return preg_replace('/(https:\/\/[^\/]+\/).*/', '$1************', $url);
                                    }

                                    ?>

                                    <!-- Kiwify -->
                                    <div class="d-flex align-items-center justify-content-start mb-2">
                                        <strong class="me-2">Kiwify:</strong>
                                        <span class="masked-webhook me-2"><?= mascararWebhook($kiwifyWebhook) ?></span>
                                        <button class="btn btn-sm btn-warning" onclick="copiarTexto('<?= $kiwifyWebhook ?>')">
                                            <i class="ti ti-clipboard"></i>
                                        </button>
                                    </div>

                                    <!-- Hubla -->
                                    <div class="d-flex align-items-center justify-content-start mb-2">
                                        <strong class="me-2">Hubla: </strong>
                                        <span class="masked-webhook me-2"><?= mascararWebhook($hublaWebhook) ?></span>
                                        <button class="btn btn-sm btn-warning" onclick="copiarTexto('<?= $hublaWebhook ?>')">
                                            <i class="ti ti-clipboard"></i>
                                        </button>
                                    </div>

                                    <!-- Kirvano -->
                                    <?php
                                    $kirvano = buscarAdicionalPorNome($pdo, 'kirvano');

                                    if ($kirvano['status'] == 1) {
                                    ?>
                                        <div class="d-flex align-items-center justify-content-start mb-2">
                                            <strong class="me-2">Kirvano: </strong>
                                            <span class="masked-webhook me-2"><?= mascararWebhook($kirvanoWebhook) ?></span>
                                            <button class="btn btn-sm btn-warning" onclick="copiarTexto('<?= $kirvanoWebhook ?>')">
                                                <i class="ti ti-clipboard"></i>
                                            </button>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>

                            <div class="mt-3">
                                <div class="card p-2 rounded shadow">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-1">Gestao de planos</h5>
                                    </div>

                                    <div class="container">
                                        <div class="p-3">
                                            <?php
                                            if (checkPermissionAdmin('planos_assinatura', 'ver', $dataAdmin) == 'true') {
                                            ?>
                                                <?php
                                                if (checkPermissionAdmin('planos_assinatura', 'editar', $dataAdmin) == 'true') {
                                                    echo '
                                                        <!-- Botão de Adicionar Plano -->
                                                        <button class="btn btn-success mb-4" data-bs-toggle="modal" data-bs-target="#addPlanoModal">Adicionar Plano</button>
                                                    ';
                                                } else {
                                                    echo '
                                                        <!-- Botão de Adicionar Plano desativado-->
                                                        <button class="btn btn-success disabled mb-4" disabled>Adicionar Plano</button>
                                                    ';
                                                }
                                                ?>


                                                <!-- Tabela de Planos -->
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>Nome</th>
                                                            <th>Valor</th>
                                                            <th>Duração</th>
                                                            <th>Status</th>
                                                            <th>Ações</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($planos as $plano): ?>
                                                            <?php
                                                            $config = json_decode($plano['configuracao'], true);
                                                            $dadosPlano = $config['dados_plano'][0] ?? [];
                                                            $permissao = $config['permissao'] ?? [];
                                                            $integracao = $config['integracao'] ?? [];
                                                            $isRestricted = $plano['id'] == 2 || strtolower($dadosPlano['nome']) == 'gratuito';
                                                            ?>
                                                            <tr>
                                                                <td><i class="ti <?php echo $dadosPlano['icone'] ?>"></i></td>
                                                                <td><?= htmlspecialchars($dadosPlano['nome'] ?? 'Indefinido') ?></td>
                                                                <td>R$ <?= number_format($dadosPlano['valor'] ?? 0, 2, ',', '.') ?></td>
                                                                <td><?= htmlspecialchars($dadosPlano['duracao_dias'] ?? '0') ?> dias</td>
                                                                <td><?= $plano['ativo'] ? '<span class="badge text-bg-success">Ativo</span>' : '<span class="badge text-bg-danger">Inativo</span>' ?></td>
                                                                <td>
                                                                    <?php
                                                                    if (!$isRestricted && checkPermissionAdmin('planos_assinatura', 'editar', $dataAdmin) == 'true') {
                                                                        echo '<button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editPlanoModal-' . $plano['id'] . '">Editar</button>';
                                                                    } else {
                                                                        echo '<button class="btn btn-primary disabled btn-sm" disabled>Editar</button>';
                                                                    }
                                                                    ?>

                                                                    <?php
                                                                    if (!$isRestricted && checkPermissionAdmin('planos_assinatura', 'deletar', $dataAdmin) == 'true') {
                                                                        echo '<button type="button" class="btn btn-danger btn-sm" onclick="excluirPlano(' . $plano['id'] . ')">Excluir</button>';
                                                                    } else {
                                                                        echo '<button type="button" class="btn btn-danger disabled btn-sm" disabled >Excluir</button>';
                                                                    }
                                                                    ?>
                                                                </td>
                                                            </tr>

                                                            <?php
                                                            if (!$isRestricted && checkPermissionAdmin('planos_assinatura', 'editar', $dataAdmin) == 'true') {
                                                            ?>

                                                                <!-- Modal para Editar Plano -->
                                                                <div class="modal fade" id="editPlanoModal-<?= $plano['id'] ?>" tabindex="-1" aria-labelledby="editPlanoModalLabel" aria-hidden="true">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h5 class="modal-title" id="editPlanoModalLabel">Editar Plano</h5>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <form id="editPlanoForm" method="POST">
                                                                                    <input type="hidden" name="id" value="<?= $plano['id'] ?>">

                                                                                    <!-- Dados do Plano -->
                                                                                    <h4>Dados do Plano</h4>
                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Nome do Plano</label>
                                                                                        <input type="text" class="form-control" name="dados_plano[nome]" value="<?= htmlspecialchars($dadosPlano['nome']) ?>" required>
                                                                                    </div>
                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Valor</label>
                                                                                        <input type="number" class="form-control" name="dados_plano[valor]" value="<?= htmlspecialchars($dadosPlano['valor']) ?>" step="0.01" required>
                                                                                    </div>
                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Duração (dias)</label>
                                                                                        <input type="number" class="form-control" name="dados_plano[duracao_dias]" value="<?= htmlspecialchars($dadosPlano['duracao_dias']) ?>" required>
                                                                                    </div>
                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Link de Compra</label>
                                                                                        <input type="text" class="form-control" name="dados_plano[link_compra]" value="<?= htmlspecialchars($dadosPlano['link_compra'] ?? '#') ?>">
                                                                                    </div>
                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Icone</label>
                                                                                        <div class="d-flex flex-wrap mb-2" id="icons-<?php echo $plano['id']; ?>">
                                                                                            <!-- Botões de seleção de ícones -->
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-diamond">
                                                                                                <i class="ti ti-diamond"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-crown">
                                                                                                <i class="ti ti-crown"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-star">
                                                                                                <i class="ti ti-star"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-stars">
                                                                                                <i class="ti ti-stars"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-rocket">
                                                                                                <i class="ti ti-rocket"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-send">
                                                                                                <i class="ti ti-send"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-plane-tilt">
                                                                                                <i class="ti ti-plane-tilt"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-parachute">
                                                                                                <i class="ti ti-parachute"></i>
                                                                                            </button>
                                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-edt-icon="ti ti-trophy">
                                                                                                <i class="ti ti-trophy"></i>
                                                                                            </button>
                                                                                        </div>
                                                                                        <input type="hidden" class="form-control" name="dados_plano[icone]" value="<?= htmlspecialchars($dadosPlano['icone']) ?>" id="iconInputEdt-<?= $plano['id'] ?>">


                                                                                        <script>
                                                                                            document.addEventListener('DOMContentLoaded', () => {
                                                                                                const editPlanoModal = document.getElementById('editPlanoModal-<?php echo $plano['id']; ?>');
                                                                                                const iconInputEdt = document.getElementById('iconInputEdt-<?php echo $plano['id']; ?>');
                                                                                                const iconsContainer = document.getElementById('icons-<?php echo $plano['id']; ?>');

                                                                                                if (editPlanoModal && iconInputEdt && iconsContainer) {
                                                                                                    editPlanoModal.addEventListener('show.bs.modal', () => {
                                                                                                        const initialIconValue = iconInputEdt.value;

                                                                                                        // Limita a busca de botões ao container do modal ativo
                                                                                                        const modalButtons = iconsContainer.querySelectorAll('[data-edt-icon]');
                                                                                                        modalButtons.forEach(btn => {
                                                                                                            btn.classList.remove('border-primary', 'text-primary');
                                                                                                        });

                                                                                                        // Adiciona classes ao botão correspondente dentro do container
                                                                                                        const matchingButton = iconsContainer.querySelector(`[data-edt-icon="${initialIconValue}"]`);
                                                                                                        if (matchingButton) {
                                                                                                            matchingButton.classList.add('border-primary', 'text-primary');
                                                                                                        }
                                                                                                    });
                                                                                                } else {
                                                                                                    console.error("Elementos do modal, input ou container de botões não encontrados.");
                                                                                                }
                                                                                            });


                                                                                            document.querySelectorAll('[data-edt-icon]').forEach(button => {
                                                                                                button.addEventListener('click', function() {
                                                                                                    document.querySelectorAll('[data-edt-icon]').forEach(btn => {
                                                                                                        btn.classList.remove('border-primary', 'text-primary');
                                                                                                    });

                                                                                                    $(this).addClass('border-primary text-primary');

                                                                                                    const iconValue = this.getAttribute('data-edt-icon');
                                                                                                    document.getElementById('iconInputEdt-<?php echo $plano['id']; ?>').value = iconValue;
                                                                                                });
                                                                                            });
                                                                                        </script>


                                                                                    </div>

                                                                                    <!-- Permissões -->
                                                                                    <h4>Permissões</h4>
                                                                                    <?php foreach ($permissao as $chave => $valor): ?>
                                                                                        <div class="form-check2 mb-2">
                                                                                            <input
                                                                                                class="form-check-input"
                                                                                                type="checkbox"
                                                                                                name="permissao[<?= $chave ?>]"
                                                                                                value="1"
                                                                                                <?= $valor ? 'checked' : '' ?>>
                                                                                            <label class="form-check-label"><?= ucfirst(str_replace('_', ' ', $chave)) ?></label>
                                                                                        </div>
                                                                                    <?php endforeach; ?>




                                                                                    <!-- Integrações -->
                                                                                    <h4>Integrações</h4>
                                                                                    <?php
                                                                                    $integracoes = [
                                                                                        'mercado_livre' => 'Mercado Livre',
                                                                                        'shopee' => 'Shopee',
                                                                                        'yampi' => 'Yampi',
                                                                                        'bling' => 'Bling'
                                                                                    ];
                                                                                    foreach ($integracoes as $key => $nome): 
                                                                                        $statusAtual = isset($integracao[$key]) ? $integracao[$key] : '0';
                                                                                    ?>
                                                                                        <div class="mb-3 d-flex justify-content-between align-items-center">
                                                                                            <div class="d-flex align-items-center">
                                                                                                <input
                                                                                                    class="form-check-input"
                                                                                                    type="checkbox"
                                                                                                    name="integracao[<?= $key ?>]"
                                                                                                    value="1"
                                                                                                    <?= $statusAtual != '0' ? 'checked' : '' ?>>
                                                                                                <label class="form-check-label ms-2"><?= $nome ?></label>
                                                                                            </div>
                                                                                            <div>
                                                                                                <input
                                                                                                    type="number"
                                                                                                    class="form-control"
                                                                                                    name="integracao[<?= $key ?>_quantidade]"
                                                                                                    placeholder="Quantidade"
                                                                                                    min="0"
                                                                                                    max="<?= $key == 'bling' ? '1' : '10' ?>"
                                                                                                    value="<?= $statusAtual != '0' ? $statusAtual : '' ?>"
                                                                                                    <?= $statusAtual != '0' ? '' : 'disabled' ?>>
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php endforeach; ?>

                                                                                    <script>
                                                                                        // JavaScript para habilitar/desabilitar inputs de quantidade das integrações no modal de edição
                                                                                        document.addEventListener('DOMContentLoaded', function() {
                                                                                            const modal<?= $plano['id'] ?> = document.getElementById('editPlanoModal-<?= $plano['id'] ?>');
                                                                                            
                                                                                            if (modal<?= $plano['id'] ?>) {
                                                                                                const integracaoCheckboxes = modal<?= $plano['id'] ?>.querySelectorAll('input[name^="integracao["][type="checkbox"]');
                                                                                                
                                                                                                integracaoCheckboxes.forEach(function(checkbox) {
                                                                                                    const integracaoName = checkbox.name.replace('integracao[', '').replace(']', '');
                                                                                                    const quantidadeInput = modal<?= $plano['id'] ?>.querySelector(`input[name="integracao[${integracaoName}_quantidade]"]`);
                                                                                                    
                                                                                                    if (quantidadeInput) {
                                                                                                        function updateQuantidadeInput() {
                                                                                                            if (checkbox.checked) {
                                                                                                                quantidadeInput.disabled = false;
                                                                                                                if (quantidadeInput.value === '') {
                                                                                                                    quantidadeInput.value = '1';
                                                                                                                }
                                                                                                            } else {
                                                                                                                quantidadeInput.disabled = true;
                                                                                                                quantidadeInput.value = '';
                                                                                                            }
                                                                                                        }
                                                                                                        
                                                                                                        updateQuantidadeInput();
                                                                                                        
                                                                                                        checkbox.addEventListener('change', updateQuantidadeInput);
                                                                                                    }
                                                                                                });
                                                                                            }
                                                                                        });
                                                                                    </script>

                                                                                    <div class="mb-3">
                                                                                        <label class="form-label">Ativo</label>
                                                                                        <div class="form-check2">
                                                                                            <input
                                                                                                class="form-check-input"
                                                                                                type="checkbox"
                                                                                                name="dados_plano[ativo]"
                                                                                                value="1"
                                                                                                id="ativoCheckbox"
                                                                                                <?php echo $plano['ativo'] ? 'checked' : ''; ?>>
                                                                                            <label class="form-check-label" for="ativoCheckbox">Plano Ativo</label>
                                                                                        </div>
                                                                                    </div>


                                                                                    <button type="submit" class="btn btn-primary">Salvar</button>

                                                                                </form>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                            <?php
                                                            }
                                                            ?>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>

                                                <!-- Modal para Adicionar Plano -->
                                                <div class="modal fade" id="addPlanoModal" tabindex="-1" aria-labelledby="addPlanoModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="addPlanoModalLabel">Adicionar Plano</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <form id="addPlanoForm" method="POST">
                                                                    <!-- Dados do Plano -->
                                                                    <h4>Dados do Plano</h4>
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Nome do Plano</label>
                                                                        <input type="text" class="form-control" name="dados_plano[nome]" required>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Valor</label>
                                                                        <input type="number" class="form-control" name="dados_plano[valor]" step="0.01" required>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Duração (dias)</label>
                                                                        <input type="number" class="form-control" name="dados_plano[duracao_dias]" required>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Link de Compra</label>
                                                                        <input type="text" class="form-control" name="dados_plano[link_compra]">
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Icone</label>
                                                                        <div class="d-flex flex-wrap mb-2">
                                                                            <!-- Botões de seleção de ícones -->
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-diamond">
                                                                                <i class="ti ti-diamond"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-crown">
                                                                                <i class="ti ti-crown"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-star">
                                                                                <i class="ti ti-star"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-stars">
                                                                                <i class="ti ti-stars"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-rocket">
                                                                                <i class="ti ti-rocket"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-send">
                                                                                <i class="ti ti-send"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-plane-tilt">
                                                                                <i class="ti ti-plane-tilt"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-parachute">
                                                                                <i class="ti ti-parachute"></i>
                                                                            </button>
                                                                            <button type="button" class="btn btn-outline-secondary me-2" data-icon="ti ti-trophy">
                                                                                <i class="ti ti-trophy"></i>
                                                                            </button>
                                                                        </div>
                                                                        <input type="hidden" class="form-control" name="dados_plano[icone]" id="iconInput">
                                                                    </div>

                                                                    <!-- Permissões -->
                                                                    <h4>Permissões</h4>
                                                                    <?php
                                                                    $permissoes = [
                                                                        'bloquear_dashboard' => 'Bloquear Dashboard',
                                                                        'bloquear_chamados' => 'Bloquear Chamados',
                                                                        'bloquear_vendas' => 'Bloquear Vendas',
                                                                        'bloquear_reembolso' => 'Bloquear Reembolso',
                                                                        'bloquear_pedido_manual' => 'Bloquear Pedido Manual',
                                                                        'bloquear_integracao' => 'Bloquear Integrações',
                                                                        'bloquear_catalogo' => 'Bloquear Catálogo',
                                                                        'bloquear_ferramentas' => 'Bloquear Ferramentas',
                                                                        'bloquear_videos' => 'Bloquear Vídeos'
                                                                    ];
                                                                    foreach ($permissoes as $chave => $nome): ?>
                                                                        <div class="form-check-2 mb-2">
                                                                            <input class="form-check-input" type="checkbox" name="permissao[<?= $chave ?>]" value="1">
                                                                            <label class="form-check-label"><?= $nome ?></label>
                                                                        </div>
                                                                    <?php endforeach; ?>

                                                                    <!-- Integrações -->
                                                                    <h4>Integrações</h4>
                                                                    <?php
                                                                    $integracoes = [
                                                                        'mercado_livre' => 'Mercado Livre',
                                                                        'shopee' => 'Shopee',
                                                                        'yampi' => 'Yampi'
                                                                    ];
                                                                    foreach ($integracoes as $key => $nome): ?>
                                                                        <div class="mb-3 d-flex justify-content-between align-items-center">
                                                                            <div class="d-flex align-items-center">
                                                                                <!-- Checkbox para a integração -->
                                                                                <input class="form-check-input" type="checkbox" name="integracao[<?= $key ?>]" value="1">
                                                                                <label class="form-check-label ms-2"><?= $nome ?></label>
                                                                            </div>
                                                                            <div>
                                                                                <!-- Input de Quantidade, só preenche se o status for '1' -->
                                                                                <input type="number" class="form-control" name="integracao[<?= $key ?>_quantidade]" placeholder="Quantidade" min="0" disabled>
                                                                            </div>
                                                                        </div>
                                                                    <?php endforeach; ?>

                                                                    <script>
                                                                        // JavaScript para habilitar/desabilitar inputs de quantidade das integrações no modal de adicionar
                                                                        document.addEventListener('DOMContentLoaded', function() {
                                                                            const addModal = document.getElementById('addPlanoModal');
                                                                            
                                                                            if (addModal) {
                                                                                const integracaoCheckboxes = addModal.querySelectorAll('input[name^="integracao["][type="checkbox"]');
                                                                                
                                                                                integracaoCheckboxes.forEach(function(checkbox) {
                                                                                    const integracaoName = checkbox.name.replace('integracao[', '').replace(']', '');
                                                                                    const quantidadeInput = addModal.querySelector(`input[name="integracao[${integracaoName}_quantidade]"]`);
                                                                                    
                                                                                    if (quantidadeInput) {
                                                                                        // Função para atualizar o estado do input
                                                                                        function updateQuantidadeInput() {
                                                                                            if (checkbox.checked) {
                                                                                                quantidadeInput.disabled = false;
                                                                                                if (quantidadeInput.value === '') {
                                                                                                    quantidadeInput.value = '1';
                                                                                                }
                                                                                            } else {
                                                                                                quantidadeInput.disabled = true;
                                                                                                quantidadeInput.value = '';
                                                                                            }
                                                                                        }
                                                                                        
                                                                                        // Adicionar evento de mudança
                                                                                        checkbox.addEventListener('change', updateQuantidadeInput);
                                                                                    }
                                                                                });
                                                                            }
                                                                        });
                                                                    </script>


                                                                    <button type="submit" class="btn btn-success">Adicionar</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                            } else {
                                                echo 'Sem acesso para visualização!';
                                            }
                                            ?>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->


    <script>
        function logout() {
            Swal.fire({
                toast: true,
                position: "top-end",
                icon: 'success',
                title: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: false,
                timer: 2000,
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>

    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="../../assets/js/depositar_saldo.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
        $(document).ready(function() {
            $('#vendas').DataTable({
                "language": {
                    "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese.json"
                },
                "paging": false,
                "responsive": true,
                "searching": false
            });
        });

        function limitarTexto(texto, limite) {
            return texto.length > limite ? texto.substring(0, limite) + '...' : texto;
        }

        document.querySelectorAll('[data-icon]').forEach(button => {
            button.addEventListener('click', function() {
                document.querySelectorAll('[data-icon]').forEach(btn => {
                    btn.classList.remove('border-primary', 'text-primary');
                });

                $(this).addClass('border-primary text-primary');

                const iconValue = this.getAttribute('data-icon');
                document.getElementById('iconInput').value = iconValue;
            });
        });
    </script>

    <script>
        // Adicionar plano
        $('#addPlanoForm').on('submit', function(e) {
            e.preventDefault();

            const formData = new FormData(this);

            const dadosPlano = {
                nome: formData.get('dados_plano[nome]'),
                valor: parseFloat(formData.get('dados_plano[valor]')) || 0,
                duracao_dias: parseInt(formData.get('dados_plano[duracao_dias]'), 10) || 0,
                link_compra: formData.get('dados_plano[link_compra]') || '#',
                icone: formData.get('dados_plano[icone]') || ''
            };

            const permissao = {};
            $('[name^="permissao"]').each(function() {
                permissao[$(this).attr('name').replace('permissao[', '').replace(']', '')] = $(this).is(':checked');
            });

            const integracao = {};
            $('[name^="integracao"]').each(function() {
                const key = $(this).attr('name').replace('integracao[', '').replace(']', '');
                if (!key.endsWith('_quantidade')) {
                    const quantidadeKey = `integracao[${key}_quantidade]`;
                    integracao[key] = parseInt(formData.get(quantidadeKey)) || 0;
                }
            });

            $.ajax({
                url: '../../assets/ajax/planos_assinatura/add_plano.php',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    dados_plano: [dadosPlano],
                    permissao,
                    integracao
                }),
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Sucesso!', 'Plano adicionado com sucesso!', 'success').then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire('Erro!', 'Erro ao adicionar o plano: ' + response.message, 'error');
                    }
                },
                error: function() {
                    Swal.fire('Erro!', 'Ocorreu um erro inesperado.', 'error');
                }
            });
        });


        $(document).on('submit', '#editPlanoForm', function(e) {
            e.preventDefault();

            const formId = $(this).closest('.modal').attr('id'); // Captura o ID do modal ativo
            const formData = new FormData(this);

            // Dados do Plano
            const dadosPlano = {
                nome: formData.get('dados_plano[nome]'),
                valor: parseFloat(formData.get('dados_plano[valor]')) || 0,
                duracao_dias: parseInt(formData.get('dados_plano[duracao_dias]'), 10) || 0,
                link_compra: formData.get('dados_plano[link_compra]') || '#',
                ativo: $(`#${formId} [name="dados_plano[ativo]"]`).is(':checked') ? 1 : 0,
                icone: formData.get('dados_plano[icone]') || ''
            };

            // Permissões
            const permissao = {};
            $(`#${formId} [name^="permissao"]`).each(function() {
                const chave = $(this).attr('name').replace('permissao[', '').replace(']', '');
                permissao[chave] = $(this).is(':checked'); // Captura valores corretamente
            });

            // Integrações
            const integracao = {};
            $(`#${formId} [name^="integracao"]`).each(function() {
                const key = $(this).attr('name').replace('integracao[', '').replace(']', '');
                if (!key.endsWith('_quantidade')) {
                    const quantidadeKey = `integracao[${key}_quantidade]`;
                    integracao[key] = parseInt(formData.get(quantidadeKey)) || 0;
                }
            });

            // Criação do Payload
            const payload = {
                id: formData.get('id'),
                dados_plano: [dadosPlano],
                permissao,
                integracao
            };

            console.log('Payload enviado:', payload);

            // Envio da Requisição AJAX
            $.ajax({
                url: '../../assets/ajax/planos_assinatura/edt_plano.php',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(payload),
                success: function(response) {
                    if (response.success) {
                        toastAlert("Plano atualizado com sucesso!", "success", 8000, null, null, "right-top");
                        setTimeout(function() {
                            $(`#${formId}`).modal('hide');
                            $(`#${formId}`).on('hidden.bs.modal', function () {
                                location.reload();
                            });
                        }, 1000);
                    } else {
                        toastAlert('Erro ao atualizar o plano: ' + response.message, "error", 8000, null, null, "right-top");
                    }
                },
                error: function() {
                     toastAlert('Ocorreu um erro inesperado.', "error", 8000, null, null, "right-top");
                }
            });
        });


        // Excluir plano
        function excluirPlano(idPlano) {
            Swal.fire({
                title: 'Tem certeza?',
                text: 'Esta ação não pode ser desfeita!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sim, excluir!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '../../assets/ajax/planos_assinatura/del_plano.php',
                        type: 'POST',
                        contentType: 'application/json',
                        data: JSON.stringify({
                            id: idPlano
                        }),
                        success: function(response) {
                            if (response.success) {
                                Swal.fire('Excluído!', response.message, 'success').then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire('Erro!', 'Erro ao excluir o plano: ' + response.message, 'error');
                            }
                        },
                        error: function() {
                            Swal.fire('Erro!', 'Ocorreu um erro inesperado.', 'error');
                        }
                    });
                }
            });
        }
    </script>


    <script>
        function copiarTexto(texto) {
            navigator.clipboard.writeText(texto).then(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Copiado!',
                    html: 'Webhook copiado para a área de transferência.'
                });
            }).catch(err => {
                console.error("Erro ao copiar: ", err);
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: 'Não foi possível copiar o webhook.',
                });
            });
        }
    </script>

</body>

</html>