<?php
session_start();

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
include_once('../../funcoes/general.php');
include_once('../../funcoes/users.php');

// Classes
require '../../class/walletClass.php';
require '../../class/getPlanosConfig.php';
require '../../class/chamadosClass.php';
require '../../class/vendasClass.php';
require '../../class/statusClass.php';
require '../../class/topicoClass.php';
require '../../class/getEtiquetasClass.php';
require '../../class/GenerateEtiquetasClass.php';
require '../../class/getProdutosVendas.php';
require '../../class/pagarVendaUsuarioClass.php';
require '../../class/fornecedorClass.php';
require '../../class/usuariosApiContas.php';
require '../../class/conexoes_plataformas.php';
require '../../class/validaAssinatura.php';


// Verifica se está logado ou não
if (!isset($_SESSION['usuario']['email'])) {
    header('Location: /login');
    exit();
}

$customBase = __DIR__ . '/../../custom/includes/';
if (isset($_SESSION['usuario']['is_adm']) && $_SESSION['usuario']['is_adm'] == 1) {
    $customDir = $customBase . 'admin/';
} else {
    $customDir = $customBase . 'user/';
}

if (is_dir($customDir)) {
    foreach (glob($customDir . '*.php') as $filename) {
        include_once $filename;
    }
}

//pegar informações do plano
$plano_id = $_SESSION['usuario']['plano_id'];

$plano = new getPlanoConfiguracao($pdo);
$configuracao = $plano->getConfiguracao($plano_id);

$dataPlanos = json_decode($configuracao, true);

// Valida Sessoes e atualiza dados
validarSessaoUsuario($pdo, $_SESSION['usuario']['id_usuario']);

?>



<!DOCTYPE html>

<html lang="en" class="light-style layout-navbar-fixed layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default" data-assets-path="../../assets/" data-template="vertical-menu-template-no-customizer-starter">

<head>
    <?php include('../../includes/dashHead.php'); ?>


    <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
    <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

    <!-- Helpers -->
    <script src="../../assets/vendor/js/helpers.js"></script>
    <script src="../../assets/vendor/js/template-customizer.js"></script>
    <script src="../../assets/js/config.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script src="../../assets/js/funcoes.js"></script>

   
</head>

<body>

    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            <aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">
                <div class="app-brand demo mt-3">
                    <a href="dashboard" class="app-brand-link">

                        <?php
                        if (Config::get('site_configs.text_icon') == true) {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                            <span class="app-brand-text text-body fw-bold ms-1"><?php echo Config::get('site_configs.name'); ?></span>
                        <?php
                        } else {
                        ?>
                            <span class="app-brand-logo">
                                <img src="<?php echo Config::get('site_configs.icon'); ?>" width="<?php echo Config::get('site_configs.icon_width'); ?>" height="<?php echo Config::get('site_configs.icon_height'); ?>" style="object-fit: contain;">
                            </span>
                        <?php
                        }
                        ?>

                    </a>

                    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto">
                        <i class="ti menu-toggle-icon d-none d-xl-block ti-sm align-middle"></i>
                        <i class="ti ti-x d-block d-xl-none ti-sm align-middle"></i>
                    </a>
                </div>

                <div class="menu-inner-shadow"></div>

                <ul class="menu-inner py-1">
                    <?php
                    if ($_SESSION['usuario']['n_acesso'] == '0') {
                        include('../../includes/sidebars-menus/sidebar_usuario.php');
                    } else {
                        include('../../includes/sidebars-menus/sidebar_master.php');
                    }
                    ?>

                </ul>
            </aside>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <nav class="layout-navbar container-xxl navbar navbar-expand-xl navbar-detached align-items-center bg-navbar-theme" id="layout-navbar">
                    <div class="layout-menu-toggle navbar-nav align-items-xl-center me-3 me-xl-0 d-xl-none">
                        <a class="nav-item nav-link px-0 me-xl-4" href="javascript:void(0)">
                            <i class="ti ti-menu-2 ti-sm"></i>
                        </a>
                    </div>

                    <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
                        <?php include('../../includes/dashnav.php') ?>

                    </div>
                </nav>

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="mt-3">
                                <div class="card p-2 rounded shadow">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-1">Integrações</h5>
                                    </div>


                                    <div class="card-body">

                                        <div class="alert alert-warning" role="alert">
                                            <h4 class="alert-heading">Atenção!</h4>
                                            <p>Para que seu pedido seja processado corretamente, é obrigatório atualizar o endereço da sua loja no marketplace com o endereço do fornecedor.</p>
                                            <hr>
                                            <p class="mb-0">Você pode consultar o endereço acessando o card <a href="/dash/dashboard#fornecedores">Fornecedores</a> no dashboard.</p>
                                        </div>


                                        <div class="alert alert-primary mb-3" role="alert">
                                            Seu plano é o <b><?php echo $dataPlanos['dados_plano'][0]['nome'] ?></b>. Você pode conectar nas integrações abaixo:
                                        </div>

                                        <div class="row">
                                            <?php
                                            // Criação da instância da classe Fornecedor
                                            $fornecedorClass = new Fornecedor($pdo);
                                            $fornecedores = $fornecedorClass->listarFornecedores();

                                            $integracao = $dataPlanos['integracao'];
                                            $user_id = $_SESSION['usuario']['id_usuario'];
                                            $conexaoContas = new ConexaoContas($pdo);

                                            // Lista unificada de todas as integrações com configurações completas
                                            $todasIntegracoes = [
                                                'mercado_livre' => [
                                                    'name' => 'Mercado Livre',
                                                    'em_breve' => false,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-warning',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-warning text-dark'
                                                ],
                                                'shopee' => [
                                                    'name' => 'Shopee',
                                                    'em_breve' => false,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-danger',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-danger text-white'
                                                ],
                                                'yampi' => [
                                                    'name' => 'Yampi',
                                                    'em_breve' => false,
                                                    'ativa_flag' => true,
                                                    'editar_valores' => false,
                                                    'border_color' => 'border-info',
                                                    'text_flag' => 'BETA',
                                                    'flag_color' => 'bg-danger text-white'
                                                ],
                                                'bling' => [
                                                    'name' => 'Bling',
                                                    'em_breve' => false,
                                                    'ativa_flag' => true,
                                                    'editar_valores' => false,
                                                    'border_color' => 'border-success',
                                                    'text_flag' => 'BETA',
                                                    'flag_color' => 'bg-danger text-white'
                                                ],
                                                'tiktok_shop' => [
                                                    'name' => 'TikTok Shop',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => false,
                                                    'border_color' => 'border-info',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-danger text-white'
                                                ],
                                                'shopify' => [
                                                    'name' => 'Shopify',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-success text-white'
                                                ],
                                                'magalu' => [
                                                    'name' => 'Magalu',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-primary text-white'
                                                ],
                                                'americanas' => [
                                                    'name' => 'Americanas',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => ''
                                                ],
                                                'via_varejo' => [
                                                    'name' => 'Via Varejo',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => ''
                                                ],
                                                'nuvemshop' => [
                                                    'name' => 'Nuvemshop',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => ''
                                                ],
                                                'woocommerce' => [
                                                    'name' => 'WooCommerce',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-secondary text-white'
                                                ],
                                                'amazon' => [
                                                    'name' => 'Amazon',
                                                    'em_breve' => true,
                                                    'ativa_flag' => false,
                                                    'editar_valores' => true,
                                                    'border_color' => 'border-light',
                                                    'text_flag' => '',
                                                    'flag_color' => 'bg-dark text-white'
                                                ]
                                            ];

                                            foreach ($todasIntegracoes as $key => $config):
                                                $nomePlataforma = $config['name'];
                                                $isAtiva = isset($integracao[$key]);
                                                $isEmBreve = $config['em_breve'];
                                                $value = $isAtiva ? $integracao[$key] : 0; // Limite de conexões para a plataforma
                                                $editar_valores = $config['editar_valores'] ;

                                                // Usar a cor da borda definida na configuração
                                                $colorClass = $isEmBreve ? 'border-light' : $config['border_color'];

                                                $totalConexoes = $isAtiva ? $conexaoContas->contarConexoes($user_id, $key) : 0;
                                                $atingiuLimite = $isAtiva && ($totalConexoes >= $value);
                                            ?>

                                                <div class="col-md-3 mb-3">
                                                    <div class="card text-center px-3 py-2 border <?php echo $colorClass; ?> <?php echo $isEmBreve ? 'bg-light' : ''; ?> position-relative"
                                                        <?php if ($isAtiva && !$isEmBreve && !$atingiuLimite): ?>
                                                        data-bs-toggle="collapse"
                                                        data-bs-target="#accordion-<?php echo strtolower(str_replace('_', '-', $key)); ?>"
                                                        aria-expanded="false"
                                                        aria-controls="accordion-<?php echo strtolower(str_replace('_', '-', $key)); ?>"
                                                        <?php endif; ?>
                                                        style="<?php echo ($isEmBreve || ($isAtiva && $atingiuLimite)) ? 'cursor: not-allowed; opacity: 0.7;' : 'cursor: pointer;'; ?>"
                                                        <?php if ($isEmBreve): ?>
                                                        title="Integração em breve"
                                                        <?php elseif ($isAtiva && $atingiuLimite): ?>
                                                        title="Limite de conexões atingido para esta plataforma"
                                                        <?php endif; ?>>

                                                        <!-- Flag no canto superior direito -->
                                                        <?php if ($config['ativa_flag'] && !empty($config['text_flag'])): ?>
                                                            <span class="position-absolute top-0 end-0 translate-middle-y mt-2 badge <?php echo $config['flag_color']; ?> small">
                                                                <?php echo $config['text_flag']; ?>
                                                            </span>
                                                        <?php endif; ?>

                                                        <div class="card-body d-flex align-items-center justify-content-center w-100 flex-row gap-2">
                                                            <img src="../../../assets/img/icons/brands/<?php echo strtolower($key); ?>.png" height="30px" alt="<?php echo $nomePlataforma; ?>" onerror="this.src='/assets/img/icons/brands/default.png';"> <!-- Imagem padrão caso não exista -->
                                                            <div class="text-start">
                                                                <h6 class="card-title mb-0"><?php echo $nomePlataforma; ?></h6>
                                                            </div>
                                                        </div>
                                                        <?php if ($isEmBreve): ?>
                                                            <small class="text-end position-absolute bottom-0 end-0 m-2 text-muted">Em breve</small>
                                                        <?php elseif ($isAtiva): ?>
                                                            <small class="text-end position-absolute bottom-0 end-0 m-2 <?php echo $atingiuLimite ? 'text-danger' : 'text-primary'; ?>"><?php echo $totalConexoes . ' / ' . $value; ?></small>
                                                        <?php endif; ?>
                                                    </div>

                                                    <?php if ($isAtiva && !$isEmBreve): ?>
                                                        <!-- Accordion (apenas para integrações ativas e não "Em breve") -->
                                                        <div class="collapse" id="accordion-<?php echo strtolower(str_replace('_', '-', $key)); ?>" data-bs-parent="#accordionExample">
                                                            <div class="card card-body mt-3 border <?php echo $colorClass; ?>">
                                                                <p>Selecione o fornecedor!</p>
                                                                <div id="dynamic-selects-<?php echo strtolower($key); ?>">
                                                                    <select class="form-select mb-2" name="fornecedor_<?php echo strtolower($key); ?>">
                                                                        <option value="">Selecione um fornecedor</option>
                                                                        <?php foreach ($fornecedores as $fornecedor): ?>
                                                                            <?php
                                                                            $prefixo_fornId = strstr($fornecedor['id'], '_', true) . '_';
                                                                            $prefixoOriginal = pegaPrefixo();

                                                                            if (
                                                                                $fornecedor['liberar_forn_whitelabel'] == 1 ||
                                                                                ($fornecedor['liberar_forn_whitelabel'] == 0 && $prefixoOriginal == $prefixo_fornId)
                                                                            ) {
                                                                            ?>
                                                                                <option value="<?php echo $fornecedor['id']; ?>"><?php echo $fornecedor['nome']; ?></option>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                        <?php endforeach; ?>
                                                                    </select>
                                                                    <!-- Input para o nome da loja -->
                                                                    <div class="mb-2">
                                                                        <label for="store-name-<?php echo strtolower($key); ?>" class="form-label">Nome da Loja</label>
                                                                        <input type="text" class="form-control" id="store-name-<?php echo strtolower($key); ?>" placeholder="Digite o nome da loja" required>
                                                                    </div>

                                                                    <!-- Campos específicos por marketplace -->
                                                                    <div id="marketplace-specific-fields-<?php echo strtolower($key); ?>">
                                                                        <?php
                                                                        // Array de campos específicos por marketplace
                                                                        $marketplaceFields = [
                                                                            'yampi' => [
                                                                                [
                                                                                    'name' => 'alias',
                                                                                    'label' => 'Alias',
                                                                                    'placeholder' => 'Digite seu Alias da Yampi',
                                                                                    'type' => 'text',
                                                                                    'required' => true
                                                                                ],
                                                                                [
                                                                                    'name' => 'token',
                                                                                    'label' => 'Token',
                                                                                    'placeholder' => 'Digite o Token da Yampi',
                                                                                    'type' => 'text',
                                                                                    'required' => true
                                                                                ],
                                                                                [
                                                                                    'name' => 'chave_secreta',
                                                                                    'label' => 'Chave Secreta',
                                                                                    'placeholder' => 'Digite a Chave Secreta da Yampi',
                                                                                    'type' => 'text',
                                                                                    'required' => true
                                                                                ]
                                                                            ]

                                                                        ];

                                                                        if (isset($marketplaceFields[strtolower($key)])) {
                                                                            foreach ($marketplaceFields[strtolower($key)] as $field) {
                                                                                $fieldId = 'marketplace-field-' . strtolower($key) . '-' . $field['name'];
                                                                                $required = $field['required'] ? 'required' : '';

                                                                                echo '<div class="mb-2">';
                                                                                echo '<label for="' . $fieldId . '" class="form-label">' . $field['label'];
                                                                                if ($field['required']) {
                                                                                    echo ' <span class="text-danger">*</span>';
                                                                                }
                                                                                echo '</label>';
                                                                                echo '<input type="' . $field['type'] . '" class="form-control marketplace-specific-input" ';
                                                                                echo 'id="' . $fieldId . '" ';
                                                                                echo 'name="marketplace_fields[' . $field['name'] . ']" ';
                                                                                echo 'placeholder="' . $field['placeholder'] . '" ';
                                                                                echo 'data-marketplace="' . strtolower($key) . '" ';
                                                                                echo 'data-field="' . $field['name'] . '" ';
                                                                                echo $required . '>';
                                                                                echo '</div>';
                                                                            }
                                                                        }
                                                                        ?>
                                                                    </div>
                                                                </div>
                                                                <button class="btn btn-primary mt-3 integrate-btn"
                                                                    data-integration="<?php echo strtolower($key); ?>"
                                                                    data-platform="<?php echo strtolower($key); ?>"
                                                                    <?php echo $atingiuLimite ? 'disabled' : ''; ?>>Integrar</button>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="container-xxl flex-grow-1 container-p-y">
                            <div class="card p-2 rounded shadow">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h5 class="card-title mb-1">Lojas Conectadas</h5>
                                </div>

                                <div class="px-4">
                                    <?php
                                    $conexoes = new ConexoesPlataformas($pdo);
                                    $conexoesAgrupadas = $conexoes->getConexoesPorPlataforma($user_id);

                                    foreach ($conexoesAgrupadas as $plataforma => $contas) {
                                        // Exibe o card para cada plataforma
                                        echo '
                                        <div class="card border mb-4">
                                            <div class="card-header d-flex align-items-center">
                                                <img src="/assets/img/icons/brands/' . strtolower($plataforma) . '.png" alt="' . $plataforma . ' Logo" class="me-2" style="width: 30px; height: auto;">
                                                <h5 class="mb-0">' . ucfirst($plataforma) . '</h5>
                                            </div>
                                            <div class="card-body">
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr class="text-center">
                                                            <th>Nome</th>
                                                            <th>ID Vendedor</th>
                                                            <th>Hora de corte</th>
                                                            <th>Fornecedor</th>
                                                            <th>Ações</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>';

                                        // Loop para exibir as contas na tabela
                                        foreach ($contas as $conta) {
                                            $seller_id = htmlspecialchars($conta['seller_id']);
                                            $percent_venda = htmlspecialchars($conta['percent_venda']);
                                            $percent_com_mkp = htmlspecialchars($conta['percent_com_mkp']);
                                            $taxa = htmlspecialchars($conta['taxa']);
                                            $frete = htmlspecialchars($conta['frete']);
                                            $percent_imposto = htmlspecialchars($conta['percent_imposto']);
                                            
                                            // Verifica se a plataforma permite editar valores
                                            $plataformaKey = strtolower(str_replace(' ', '_', $plataforma));
                                            $podeEditarValores = isset($todasIntegracoes[$plataformaKey]['editar_valores']) ? $todasIntegracoes[$plataformaKey]['editar_valores'] : true;

                                            echo '
                                                <tr class="text-center">
                                                    <td>' . htmlspecialchars($conta['nome']) . '</td>
                                                    <td>' . $seller_id . '</td>
                                                    <td class="text-primary">12:00</td>
                                                    <td class="">' . htmlspecialchars($conta['f_nome']) . '</td>
                                                    <td class="">';
                                                    
                                            // Botão de editar valores (só aparece se editar_valores for true)
                                            if ($podeEditarValores) {
                                                echo '<button type="button" class="btn btn-light btn-sm p-1" data-bs-toggle="modal" data-bs-target="#modal_' . $seller_id . '">
                                                            <i class="ti ti-dots"></i>
                                                        </button>';
                                            }
                                            
                                            echo '
                                                        <button type="button" class="btn btn-danger btn-sm p-1 remove-integ" data-seller="' . $seller_id . '">
                                                            <i class="ti ti-minus"></i>
                                                        </button>
                                                    </td>
                                                </tr>';
                                                
                                            // Modal de edição (só aparece se editar_valores for true)
                                            if ($podeEditarValores) {
                                                echo '
                                                <div class="modal fade modal_update_conexao" id="modal_' . $seller_id . '" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <form class="updateDadosConexoes">
                                                                    <div class="mb-3 d-none">
                                                                        <label for="basic-url" class="form-label">Seller Id</label>
                                                                        <div class="input-group mb-3">
                                                                          <input type="number" min="0" maxlength="3" name="seller_id" value="' . $seller_id . '" class="control-value form-control">
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="mb-3">
                                                                        <label for="basic-url" class="form-label">Porcentagem Venda</label>
                                                                        <div class="input-group mb-3">
                                                                          <input type="number" min="0" maxlength="3" name="percent_venda" value="' . $percent_venda . '" class="control-value form-control">
                                                                          <span class="input-group-text">%</span>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="mb-3">
                                                                        <label for="basic-url" class="form-label">Comissão Marketplace</label>
                                                                        <div class="input-group mb-3">
                                                                          <input type="number" min="0" maxlength="3" name="percent_com_mkp" value="' . $percent_com_mkp . '" class="control-value form-control">
                                                                          <span class="input-group-text">%</span>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="mb-3">
                                                                        <label for="basic-url" class="form-label">Taxa</label>
                                                                        <div class="input-group mb-3">
                                                                          <input type="number" min="0" maxlength="3" name="taxa" value="' . $taxa . '" class="control-value form-control">
                                                                          <span class="input-group-text">R$</span>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="mb-3">
                                                                        <label for="basic-url" class="form-label">Frete</label>
                                                                        <div class="input-group mb-3">
                                                                          <input type="number" min="0" maxlength="3" name="frete" value="' . $frete . '" class="control-value form-control">
                                                                          <span class="input-group-text">R$</span>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="mb-3">
                                                                        <label for="basic-url" class="form-label">Porcentagem Imposto</label>
                                                                        <div class="input-group mb-3">
                                                                          <input type="number" min="0" maxlength="3" name="percent_imposto" value="' . $percent_imposto . '" class="control-value form-control">
                                                                          <span class="input-group-text">%</span>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div class="modal-footer">
                                                                            <button type="submit" class="btn btn-primary">Salvar</button>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                            
                                                        </div>
                                                    </div>
                                                </div>';
                                            }
                                        }


                                        echo '
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>';
                                    }
                                    ?>
                                </div>

                            </div>
                        </div>

                        <script>
                            // Script para abrir apenas um collapse por vez e desabilitar selects e inputs dos outros collapses
                            document.addEventListener('DOMContentLoaded', function() {
                                const collapses = document.querySelectorAll('.collapse');

                                collapses.forEach(collapse => {
                                    collapse.addEventListener('show.bs.collapse', function() {
                                        collapses.forEach(c => {
                                            if (c !== collapse) {
                                                const select = c.querySelector('select');
                                                const input = c.querySelector('input[type="text"]');
                                            }
                                        });
                                    });

                                });

                                // Ação do botão de integrar
                                const integrateButtons = document.querySelectorAll('.integrate-btn');
                                integrateButtons.forEach(button => {
                                    button.addEventListener('click', function() {
                                        const cardBody = button.closest('.card-body');
                                        const selectBox = cardBody.querySelector('select');
                                        const storeInput = cardBody.querySelector('input[type="text"]');
                                        const selectedValue = selectBox.value;
                                        const storeName = storeInput.value.trim();
                                        const idUsuario = '<?php echo $_SESSION['usuario']['id_usuario'] ?>';
                                        const platform = button.getAttribute('data-platform');

                                        // Captura os campos específicos do marketplace
                                        const marketplaceFields = {};
                                        const specificInputs = cardBody.querySelectorAll('.marketplace-specific-input');

                                        let hasRequiredFieldsEmpty = false;
                                        specificInputs.forEach(input => {
                                            const fieldName = input.getAttribute('data-field');
                                            const fieldValue = input.value.trim();

                                            // Verifica se campo obrigatório está vazio
                                            if (input.hasAttribute('required') && !fieldValue) {
                                                hasRequiredFieldsEmpty = true;
                                                input.classList.add('is-invalid');
                                            } else {
                                                input.classList.remove('is-invalid');
                                                if (fieldValue) {
                                                    marketplaceFields[fieldName] = fieldValue;
                                                }
                                            }
                                        });

                                        if (selectedValue && storeName && !hasRequiredFieldsEmpty) {
                                            // Constrói a URL com os parâmetros básicos
                                            let url = `/assets/ajax/plataformas/${platform}/integrar.php?plataforma=${platform}&fornecedor=${selectedValue}&loja=${encodeURIComponent(storeName)}&user_id=${encodeURIComponent(idUsuario)}`;

                                            // Adiciona os campos específicos do marketplace como parâmetros individuais
                                            for (const [fieldName, fieldValue] of Object.entries(marketplaceFields)) {
                                                url += `&${fieldName}=${encodeURIComponent(fieldValue)}`;
                                            }

                                            window.location.href = url;
                                        } else {
                                            let errorMessage = 'Por favor, ';
                                            const errors = [];

                                            if (!selectedValue) errors.push('selecione um fornecedor');
                                            if (!storeName) errors.push('digite o nome da loja');
                                            if (hasRequiredFieldsEmpty) errors.push('preencha todos os campos obrigatórios');

                                            errorMessage += errors.join(', ') + ' antes de integrar.';

                                            Swal.fire({
                                                icon: 'warning',
                                                title: 'Atenção!',
                                                text: errorMessage,
                                                confirmButtonText: 'OK'
                                            });
                                        }
                                    });
                                });
                            });
                        </script>
                        <!-- / Content -->
                    </div>
                    <!-- / Content -->



                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <div class="layout-overlay layout-menu-toggle"></div>

        <div class="drag-target"></div>
    </div>
    <!-- / Layout wrapper -->




    <script>
        function logout() {
            Swal.fire({
                icon: 'success',
                title: 'Desconectar',
                text: 'Você se desconectou com sucesso! Até logo. 😉',
                showConfirmButton: true,
                confirmButtonText: 'OK'
            }).then(function() {
                window.location.href = '/logout';
            });
        }
    </script>


    <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../../assets/vendor/libs/popper/popper.js"></script>
    <script src="../../assets/vendor/js/bootstrap.js"></script>
    <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
    <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
    <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
    <script src="../../assets/vendor/js/menu.js"></script>
    <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/dashboards-analytics.js"></script>
    <script src="../../assets/js/main.js"></script>
    <script src="../../assets/js/chamados.js"></script>
    <script src="../../assets/js/ui-modals.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
        // Configuração global do SweetAlert para evitar fechamento automático
        if (typeof Swal !== 'undefined') {
            // Override das configurações padrão
            const originalFire = Swal.fire;
            Swal.fire = function(options) {
                // Se for um objeto de configuração
                if (typeof options === 'object' && options !== null) {
                    // Remove timer automático se não for explicitamente definido
                    if (!options.hasOwnProperty('timer')) {
                        options.timer = false;
                    }
                    // Garante que showConfirmButton seja true por padrão
                    if (!options.hasOwnProperty('showConfirmButton')) {
                        options.showConfirmButton = true;
                    }
                    // Remove allowOutsideClick para evitar fechamento acidental
                    if (!options.hasOwnProperty('allowOutsideClick')) {
                        options.allowOutsideClick = false;
                    }
                }
                return originalFire.apply(this, arguments);
            };
        }
    </script>

    <?php
    if (isset($_GET['info'])) {
        echo '
                <script>
                    Swal.fire({
                        icon: "error",
                        title: "Erro!",
                        html: "' . base64_decode($_GET['info']) . '",
                        showConfirmButton: true
                    }).then(function() {
                        if (window.history.replaceState) {
                            const url = new URL(window.location.href);
                            url.searchParams.delete(\'info\');
                            window.history.replaceState({}, document.title, url.pathname + url.search);
                        }
                    });
                </script>
            ';
    }
    ?>

    <script>
        $(document).on('click', '.remove-integ', function() {
            const sellerId = $(this).data('seller');

            Swal.fire({
                title: 'Tem certeza?',
                text: 'Você deseja realmente remover esta integração?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sim, remover!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Primeiro verifica se existem produtos cadastrados
                    $.ajax({
                        url: '../../assets/ajax/integracao/verificar_produtos.php',
                        type: 'POST',
                        data: {
                            seller_id: sellerId
                        },
                        success: function(response) {
                            let data = typeof response === 'string' ? JSON.parse(response) : response;
                            
                            if (data.success && data.has_products === false) {
                                // Não tem produtos, pode remover
                                $.ajax({
                                    url: '../../assets/ajax/integracao/remove_conexao.php',
                                    type: 'POST',
                                    data: {
                                        seller_id: sellerId
                                    },
                                    success: function(response) {
                                        Swal.fire({
                                            title: 'Removido!',
                                            text: 'A integração foi removida com sucesso.',
                                            icon: 'success',
                                            confirmButtonText: 'OK'
                                        }).then(() => {
                                            window.location.href = '/dash/integracoes';
                                        });
                                    },
                                    error: function(xhr, status, error) {
                                        Swal.fire(
                                            'Erro!',
                                            'Ocorreu um erro ao tentar remover a integração.',
                                            'error'
                                        );
                                    }
                                });
                            } else if (data.has_products === true) {
                                // Tem produtos cadastrados, não permite remover
                                Swal.fire({
                                    title: 'Não é possível remover!',
                                    text: data.message,
                                    icon: 'warning',
                                    confirmButtonText: 'OK'
                                });
                            } else {
                                // Erro na verificação
                                Swal.fire(
                                    'Erro!',
                                    data.message || 'Ocorreu um erro ao verificar os produtos.',
                                    'error'
                                );
                            }
                        },
                        error: function(xhr, status, error) {
                            Swal.fire(
                                'Erro!',
                                'Ocorreu um erro ao verificar os produtos cadastrados.',
                                'error'
                            );
                        }
                    });
                }
            });
        });



        function pagarVenda(idUsuario, idVenda, botao) {
            if (!idUsuario || !idVenda) {
                exibirMensagem('Erro', 'Usuário ou venda inválidos.', 'error');
                return;
            }

            botao.disabled = true;

            fetch('../../assets/ajax/vendas/pagar_vendas.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        id_usuario: idUsuario,
                        id_venda: idVenda
                    })
                })
                .then(response => {
                    if (!response.ok) {
                        return response.text().then(text => {
                            throw new Error(`Erro na resposta do servidor: ${text}`);
                        });
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            title: 'Sucesso!',
                            text: data.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        exibirMensagem('Erro', data.message, 'error');
                    }
                })
                .catch(error => {
                    console.error('Erro na requisição:', error);
                    exibirMensagem('Erro', 'Ocorreu um erro ao processar a solicitação.', 'error');
                })
                .finally(() => {
                    botao.disabled = false;
                });
        }

        function exibirMensagem(titulo, mensagem, tipo) {
            Swal.fire({
                title: titulo,
                text: mensagem,
                icon: tipo,
                confirmButtonText: 'Ok'
            });
        }

        $(document).on('submit', '.uploadNFForm', function(event) {
            event.preventDefault(); // Previne o comportamento padrão do formulário

            var formData = new FormData(this);

            $.ajax({
                url: '../../assets/ajax/nf/enviar_nf.php', // Endereço do PHP para processamento
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'text', // Importante: tratar a resposta como texto simples
                success: function(response) {
                    // Exibe a mensagem de sucesso usando SweetAlert
                    Swal.fire({
                        title: 'Sucesso!',
                        text: response,
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then((result) => {
                        $('.uploadNFFormodal').modal('hide'); // Fecha o modal

                        if (result.isConfirmed) { // Verifica se o botão OK foi clicado
                            location.reload(); // Recarrega a página
                        }
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Exibe a mensagem de erro usando SweetAlert
                    Swal.fire({
                        title: 'Erro!',
                        text: 'Erro ao enviar a Nota Fiscal: ' + textStatus,
                        icon: 'error',
                        confirmButtonText: 'OK'
                    });
                }
            });
        });

        $(document).ready(function() {
            $('#form-reembolso').on('submit', function(e) {
                e.preventDefault(); // Evita o envio normal do formulário

                $.ajax({
                    url: '/assets/ajax/pagamentos/solicitar_reembolso.php',
                    type: 'POST',
                    data: {
                        numero_do_pedido: $('#numero_pedido').val(),
                        codigo_devolucao: $('#codigo_devolucao').val(),
                        id_usuario: $('#id_usuario').val(),
                        status: 0
                    },
                    success: function(response) {
                        // Utilizando SweetAlert para exibir a mensagem de sucesso
                        Swal.fire({
                            icon: 'success',
                            title: 'Reembolso Solicitado!',
                            text: 'Sua solicitação de reembolso foi enviada com sucesso.',
                            confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                // Opcional: redirecionar ou resetar o formulário
                                $('#form-reembolso')[0].reset(); // Limpa o formulário
                            }
                        });

                        console.log(response); // Exibe a resposta para debug
                    },
                    error: function(xhr, status, error) {
                        // Utilizando SweetAlert para exibir a mensagem de erro
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Ocorreu um erro ao enviar a solicitação: ' + error,
                            confirmButtonText: 'OK'
                        });

                        console.error('Erro na solicitação: ' + error);
                    }
                });
            });
        });

        $(document).ready(function() {
            $('.control-value').on('input', function() {
                var value = $(this).val();

                // Remove qualquer caractere que não seja número
                value = value.replace(/\D/g, '');

                // Limitar a 3 caracteres
                if (value.length > 3) {
                    value = value.slice(0, 3);
                }

                // Atualizar o valor do input
                $(this).val(value);
            });
        });


        $(document).ready(function() {
            $(document).on('submit', '.updateDadosConexoes', function(e) {
                e.preventDefault(); // Evita o envio tradicional do formulário

                let form = $(this); // Garante que estamos enviando o formulário correto

                $.ajax({
                    url: '/assets/ajax/integracao/update_conexao.php',
                    type: 'POST',
                    data: form.serialize(), // Envia os dados do formulário correto
                    success: function(response) {
                       Swal.fire({
                           icon: 'success',
                           title: 'Sucesso!',
                           text: 'Dados atualizados com sucesso!',
                           confirmButtonText: 'OK'
                       });

                       console.log(response); // Exibe a resposta do servidor no console
                    },
                    error: function(xhr, status, error) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao atualizar os dados. Tente novamente.',
                            confirmButtonText: 'Ok'
                        });

                        console.error(error);
                    }
                });
            });
        });


        $('.enviar_nf').on('click', function() {
            $('#uploadNFForm').submit();

            setTimeout(function() {
                $('.uploadNFFormodal').modal('hide');
            }, 500);
        });
    </script>





</body>

</html>