<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
date_default_timezone_set('America/Sao_Paulo');

require '../../class/configClass.php';
Config::load('../../config/config.php');
include_once('../../funcoes/general.php');
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <?php include('../../includes/dashHead.php'); ?>

  <link rel="stylesheet" href="../../assets/vendor/libs/apex-charts/apex-charts.css" />
  <link rel="stylesheet" href="../../assets/vendor/libs/swiper/swiper.css" />
  <link rel="stylesheet" href="../../assets/vendor/css/pages/cards-advance.css" />

  <!-- Helpers -->
  <script src="../../assets/vendor/js/helpers.js"></script>
  <script src="../../assets/vendor/js/template-customizer.js"></script>
  <script src="../../assets/js/config.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
  <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
  <script src="../../assets/js/funcoes.js"></script>
  
</head>
<body>

  <!-- Header Banner -->
  <header class="header-banner border-bottom shadow-sm mb-4">
    <div class="container header-content py-4">
      <div class="row align-items-center">
        <div class="col"></div>
        <div class="col-auto text-start">
          <div class="logo-container mb-2">
            <img src="<?php echo Config::get('site_configs.icon'); ?>" height="50" alt="Logo">
          </div>
        </div>
        <div class="col text-end">
          <button class="btn theme-toggle-btn" title="Alternar tema">
            <i class="ti ti-moon ti-md"></i>
          </button>
        </div>
      </div>
    </div>
  </header>

  <div class="container pb-5">
  
    <!-- Banner do Catálogo -->
    <div id="banner-catalogo-container" class="mb-4" style="display: none;">
      <a id="banner-catalogo-link" href="#" target="_blank">
        <img id="banner-catalogo-img" src="" alt="Banner Catálogo" class="w-100 rounded shadow-sm" style="max-height: 200px; object-fit: cover;">
      </a>
    </div>

    <!-- Card de Filtros -->
    <div class="card shadow-sm mb-4">
      <div class="card-header bg-white">
        <h5 class="mb-0 fw-semibold">Filtros</h5>
      </div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-md-6">
            <label for="fornecedor-select" class="form-label fw-semibold">Fornecedor</label>
            <select id="fornecedor-select" class="form-select">
              <option value="">Carregando fornecedores...</option>
            </select>
          </div>
          <div class="col-md-6">
            <label for="busca-produto-top" class="form-label fw-semibold">Nome do Produto</label>
            <input type="text" id="busca-produto-top" class="form-control" placeholder="Pesquisar produto...">
          </div>
        </div>
      </div>
    </div>

    <!-- Card de Produtos -->
    <div id="catalogo-container" style="display: none;">
      <div class="card shadow-sm">
        <div class="card-header bg-white">
          <h5 class="mb-0 fw-semibold">Catálogo de Produtos</h5>
        </div>
        <div class="card-body mt-3">
          
          <!-- Loading -->
          <div id="loading-produtos" class="text-center py-5" style="display: none;">
            <div class="spinner-border text-dark" role="status">
              <span class="visually-hidden">Carregando...</span>
            </div>
            <p class="mt-3 text-muted">Carregando produtos...</p>
          </div>

          <!-- Grid de Produtos -->
          <div id="produtos-grid" class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 g-3">
            <!-- Produtos aqui -->
          </div>

          <!-- Paginação -->
          <nav id="paginacao-container" class="mt-4" style="display: none;">
            <ul id="paginacao" class="pagination pagination-sm justify-content-center">
              <!-- Paginação aqui -->
            </ul>
          </nav>

          <!-- Sem Produtos -->
          <div id="sem-produtos" class="text-center py-5" style="display: none;">
            <i class="ti ti-inbox display-1 text-muted"></i>
            <p class="mt-3 text-muted">Nenhum produto encontrado</p>
          </div>

        </div>
      </div>
    </div>

  </div>

  <script src="../../assets/vendor/libs/jquery/jquery.js"></script>
  <script src="../../assets/vendor/libs/popper/popper.js"></script>
  <script src="../../assets/vendor/js/bootstrap.js"></script>
  <script src="../../assets/vendor/libs/node-waves/node-waves.js"></script>
  <script src="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
  <script src="../../assets/vendor/libs/hammer/hammer.js"></script>
  <script src="../../assets/vendor/libs/i18n/i18n.js"></script>
  <script src="../../assets/vendor/libs/typeahead-js/typeahead.js"></script>
  <script src="../../assets/vendor/js/menu.js"></script>
  <script src="../../assets/vendor/libs/apex-charts/apexcharts.js"></script>
  <script src="../../assets/vendor/libs/swiper/swiper.js"></script>
  <script src="../../assets/js/main.js"></script>
  <script src="../../assets/js/dashboards-analytics.js"></script>
  <script src="../../assets/js/main.js"></script>
  <script src="../../assets/js/ui-modals.js"></script>
  <script src="../../assets/js/depositar_saldo.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <script>
    const API_URL = '<?php echo Config::get('api_configs.base_url'); ?>';
    const API_TOKEN = '<?php echo Config::get('api_configs.token'); ?>';
    const WHITELABEL = '<?php echo Config::get('database.dbname'); ?>';
    
    console.log('🔧 Configurações:');
    console.log('API_URL:', API_URL);
    console.log('API_TOKEN:', API_TOKEN ? 'Presente ('+API_TOKEN.length+' chars)' : 'AUSENTE');
    console.log('WHITELABEL:', WHITELABEL);
    
    let produtosData = [];
    let paginaAtual = 1;
    const PRODUTOS_POR_PAGINA = 50;

    $(document).ready(function() {
      carregarBannerCatalogo();
      carregarFornecedores();
    });

    function carregarBannerCatalogo() {
      const sql = `SELECT filename, link FROM ${WHITELABEL}.banners WHERE filename LIKE 'catalogo_%' ORDER BY id DESC LIMIT 1`;
      
      fazerRequisicaoAPI(sql, {}, function(response) {
        const banners = response.data && response.data.data ? response.data.data : [];
        
        if (banners.length > 0) {
          const banner = banners[0];
          const imagemUrl = `https://${window.location.hostname}/assets/uploads/banners/${banner.filename}`;
          const link = banner.link || '#';
          
          $('#banner-catalogo-img').attr('src', imagemUrl);
          $('#banner-catalogo-link').attr('href', link);
          $('#banner-catalogo-container').fadeIn();
          
          console.log('✅ Banner do catálogo carregado:', banner.filename);
        } else {
          console.log('ℹ️ Nenhum banner do catálogo encontrado');
        }
      });
    }

    function carregarFornecedores() {
      const sql = `
        SELECT id, nome 
        FROM drophub_global.fornecedores 
        WHERE JSON_EXTRACT(whitelabels, '$."${WHITELABEL}"') = true
        ORDER BY nome
      `;
      
      fazerRequisicaoAPI(sql, {}, function(response) {
        const fornecedores = response.data && response.data.data ? response.data.data : [];
        const select = $('#fornecedor-select');
        select.empty();
        select.append('<option value="">Selecione um fornecedor</option>');
        
        fornecedores.forEach(function(f) {
          select.append(`<option value="${f.id}">${f.nome}</option>`);
        });
      });
    }

    $('#fornecedor-select').on('change', function() {
      const fornecedorId = $(this).val();
      
      if (!fornecedorId) {
        // Se não há fornecedor selecionado, limpa os produtos
        $('#catalogo-container').hide();
        $('#produtos-grid').empty();
        produtosData = [];
        return;
      }

      console.log('🔍 Fornecedor selecionado! ID:', fornecedorId);
      
      // Carrega os produtos automaticamente
      $('#catalogo-container').show();
      $('#loading-produtos').show();
      $('#produtos-grid').empty();
      $('#sem-produtos').hide();

      const sql = `
        SELECT 
          p.id,
          p.titulo,
          p.descricao,
          (SELECT imagem_url FROM drophub_global.produtos_imagens WHERE produto_id = p.id LIMIT 1) as imagem_principal
        FROM drophub_global.produtos p
        WHERE p.fornecedor = :fornecedor_id
        ORDER BY p.titulo
      `;

      const params = { fornecedor_id: fornecedorId };
      
      console.log('📤 Enviando requisição de produtos...');

      fazerRequisicaoAPI(sql, params, function(response) {
        console.log('📥 Resposta recebida:', response);
        $('#loading-produtos').hide();
        const produtos = response.data && response.data.data ? response.data.data : [];
        
        console.log('📦 Total de produtos:', produtos.length);
        
        if (produtos && produtos.length > 0) {
          produtosData = produtos;
          paginaAtual = 1;
          renderizarProdutos(produtosData);
          renderizarPaginacao(produtosData);
        } else {
          $('#sem-produtos').show();
          $('#paginacao-container').hide();
        }
      });
    });

    $('#busca-produto-top').on('keyup', function() {
      const termo = $(this).val().toLowerCase();
      
      if (!produtosData || produtosData.length === 0) return;
      
      if (termo === '') {
        renderizarProdutos(produtosData);
        renderizarPaginacao(produtosData);
      } else {
        const produtosFiltrados = produtosData.filter(function(produto) {
          return produto.titulo.toLowerCase().includes(termo) ||
                 (produto.descricao && produto.descricao.toLowerCase().includes(termo));
        });
        paginaAtual = 1;
        renderizarProdutos(produtosFiltrados);
        renderizarPaginacao(produtosFiltrados);
      }
    });

    function renderizarProdutos(produtos) {
      const container = $('#produtos-grid');
      container.empty();

      if (produtos.length === 0) {
        $('#sem-produtos').show();
        $('#paginacao-container').hide();
        return;
      }

      $('#sem-produtos').hide();

      // Calcular produtos da página atual
      const inicio = (paginaAtual - 1) * PRODUTOS_POR_PAGINA;
      const fim = inicio + PRODUTOS_POR_PAGINA;
      const produtosPagina = produtos.slice(inicio, fim);

      produtosPagina.forEach(function(produto) {
        const imagemUrl = produto.imagem_principal || '../../assets/img/placeholder-produto.jpg';
        const titulo = produto.titulo || 'Sem título';
        const produto_hash = btoa(String(produto.id)); // Usar ID como hash simples

        const card = `
          <div class="col">
            <div class="card h-100 shadow-sm">
              <img src="${imagemUrl}" 
                   class="card-img-top p-3" 
                   style="height: 200px; object-fit: contain;"
                   onerror="this.src='../../assets/img/placeholder-produto.jpg'"
                   alt="${titulo}">
              <div class="card-body d-flex flex-column">
                <h6 class="card-title fw-semibold mb-2">${titulo}</h6>
                <a href="/produto_detalhes?n=${produto_hash}" class="btn btn-dark btn-sm mt-auto">
                  Ver Detalhes <i class="ti ti-arrow-right ms-1"></i>
                </a>
              </div>
            </div>
          </div>
        `;
        
        container.append(card);
      });

      // Scroll suave para o topo dos produtos
      if (paginaAtual > 1) {
        $('html, body').animate({
          scrollTop: $('#produtos-grid').offset().top - 100
        }, 300);
      }
    }

    function renderizarPaginacao(produtos) {
      const totalPaginas = Math.ceil(produtos.length / PRODUTOS_POR_PAGINA);
      const container = $('#paginacao-container');
      const paginacao = $('#paginacao');
      
      // Limpar tudo
      container.empty();
      container.append('<ul id="paginacao" class="pagination justify-content-center mb-0"></ul>');
      const pag = $('#paginacao');

      if (totalPaginas <= 1) {
        container.hide();
        return;
      }

      container.show();

      // Botão Anterior
      if (paginaAtual > 1) {
        pag.append(`
          <li class="page-item">
            <a class="page-link px-3" href="javascript:void(0)" onclick="mudarPagina(${paginaAtual - 1})">
              Anterior
            </a>
          </li>
        `);
      }

      // Primeira página
      if (paginaAtual > 3) {
        pag.append(`
          <li class="page-item">
            <a class="page-link px-3" href="javascript:void(0)" onclick="mudarPagina(1)">1</a>
          </li>
        `);
        if (paginaAtual > 4) {
          pag.append('<li class="page-item disabled"><span class="page-link px-3">...</span></li>');
        }
      }

      // Páginas ao redor da atual
      const inicioPag = Math.max(1, paginaAtual - 2);
      const fimPag = Math.min(totalPaginas, paginaAtual + 2);

      for (let i = inicioPag; i <= fimPag; i++) {
        if (i === paginaAtual) {
          pag.append(`
            <li class="page-item active">
              <span class="page-link px-3">${i}</span>
            </li>
          `);
        } else {
          pag.append(`
            <li class="page-item">
              <a class="page-link px-3" href="javascript:void(0)" onclick="mudarPagina(${i})">${i}</a>
            </li>
          `);
        }
      }

      // Última página
      if (paginaAtual < totalPaginas - 2) {
        if (paginaAtual < totalPaginas - 3) {
          pag.append('<li class="page-item disabled"><span class="page-link px-3">...</span></li>');
        }
        pag.append(`
          <li class="page-item">
            <a class="page-link px-3" href="javascript:void(0)" onclick="mudarPagina(${totalPaginas})">${totalPaginas}</a>
          </li>
        `);
      }

      // Botão Próximo
      if (paginaAtual < totalPaginas) {
        pag.append(`
          <li class="page-item">
            <a class="page-link px-3" href="javascript:void(0)" onclick="mudarPagina(${paginaAtual + 1})">
              Próximo
            </a>
          </li>
        `);
      }

      // Info de produtos abaixo
      const inicio = (paginaAtual - 1) * PRODUTOS_POR_PAGINA + 1;
      const fim = Math.min(paginaAtual * PRODUTOS_POR_PAGINA, produtos.length);
      
      container.append(`
        <div class="text-center text-muted mt-3">
          <small>Mostrando ${inicio}-${fim} de ${produtos.length} produtos</small>
        </div>
      `);
    }

    function mudarPagina(novaPagina) {
      paginaAtual = novaPagina;
      const termo = $('#busca-produto-top').val().toLowerCase();
      
      if (termo === '') {
        renderizarProdutos(produtosData);
        renderizarPaginacao(produtosData);
      } else {
        const produtosFiltrados = produtosData.filter(function(produto) {
          return produto.titulo.toLowerCase().includes(termo) ||
                 (produto.descricao && produto.descricao.toLowerCase().includes(termo));
        });
        renderizarProdutos(produtosFiltrados);
        renderizarPaginacao(produtosFiltrados);
      }
    }

    // Tornar função global
    window.mudarPagina = mudarPagina;

    function fazerRequisicaoAPI(sql, params, callback) {
      console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
      console.log('🚀 Chamando API:', API_URL + 'query/custom');
      console.log('� Token:', API_TOKEN ? API_TOKEN.substring(0, 20) + '...' : 'AUSENTE');
      console.log('�📝 SQL:', sql);
      console.log('📋 Params:', params);
      console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
      
      $.ajax({
        url: API_URL + 'query/custom',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'Authorization': 'Bearer ' + API_TOKEN
        },
        data: JSON.stringify({ sql: sql, params: params }),
        success: function(response) {
          console.log('✅ Response Success:', response);
          if (response.success) {
            callback(response);
          } else {
            console.error('❌ Response indica erro:', response);
            alert('Erro na API: ' + (response.message || 'Erro desconhecido'));
            $('#loading-produtos').hide();
          }
        },
        error: function(xhr, status, error) {
          console.error('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
          console.error('❌ ERRO AJAX:');
          console.error('Status:', status);
          console.error('Error:', error);
          console.error('XHR Status:', xhr.status);
          console.error('XHR Response:', xhr.responseText);
          console.error('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
          alert('Erro ao carregar dados. Verifique o console (F12) para detalhes.');
          $('#loading-produtos').hide();
        }
      });
    }


    // Gerenciamento do Theme Switcher (usando localStorage)
  function updateThemeIcon(theme) {
    const themeIcon = document.querySelector('.theme-toggle-btn i');
    if (!themeIcon) return;

    // Remove todas as classes de ícone existentes
    themeIcon.className = 'ti ti-md';

    // Atualiza ícone e título baseado no tema atual
    const themeBtn = document.querySelector('.theme-toggle-btn');
    
    if (theme === 'light') {
      themeIcon.classList.add('ti-moon');
      themeBtn.title = 'Mudar para tema escuro';
    } else {
      themeIcon.classList.add('ti-sun');
      themeBtn.title = 'Mudar para tema claro';
    }
  }

  function getCurrentTheme() {
    // Verifica localStorage - MÉTODO RÁPIDO!
    let templateName = document.documentElement.getAttribute('data-template') || 'vertical-menu-template-no-customizer-starter';
    let theme = localStorage.getItem('templateCustomizer-' + templateName + '--Style') || 'light';
    
    // Para o botão simples, removemos o suporte ao 'system', apenas light/dark
    if (theme === 'system') {
      theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
    }
    
    return theme;
  }

  function toggleTheme() {
    const currentTheme = getCurrentTheme();
    const newTheme = currentTheme === 'light' ? 'dark' : 'light';
    applyTheme(newTheme);
  }

  function applyTheme(theme) {
    // Salva no localStorage - INSTANTÂNEO!
    let templateName = document.documentElement.getAttribute('data-template') || 'vertical-menu-template-no-customizer-starter';
    localStorage.setItem('templateCustomizer-' + templateName + '--Style', theme);
    
    // Aplica o tema visualmente
    changeThemeDirectly(theme);
    
    // Atualiza o ícone
    updateThemeIcon(theme);
  }

  function changeThemeDirectly(theme) {
    const html = document.documentElement;
    const themeLink = document.querySelector('.template-customizer-theme-css');
    const coreLink = document.querySelector('.template-customizer-core-css');
    
    // Remove classes de tema anteriores
    html.classList.remove('light-style', 'dark-style');
    
    // Adiciona nova classe de tema
    html.classList.add(theme + '-style');
    
    // Atualiza o CSS do core
    if (coreLink) {
      let newCoreHref = coreLink.href;
      if (theme === 'dark') {
        newCoreHref = newCoreHref.replace('core.css', 'core-dark.css');
      } else {
        newCoreHref = newCoreHref.replace('core-dark.css', 'core.css');
      }
      coreLink.href = newCoreHref;
    }
    
    // Atualiza o CSS do tema
    if (themeLink) {
      let newThemeHref = themeLink.href;
      if (theme === 'dark') {
        newThemeHref = newThemeHref.replace('theme-default.css', 'theme-default-dark.css');
      } else {
        newThemeHref = newThemeHref.replace('theme-default-dark.css', 'theme-default.css');
      }
      themeLink.href = newThemeHref;
    }
    
    // Atualiza imagens baseadas no tema
    switchImageByTheme(theme);
  }

  // Função para trocar imagens baseadas no tema
  function switchImageByTheme(style) {
    if (style === 'system') {
      if (window.matchMedia('(prefers-color-scheme: dark)').matches) {
        style = 'dark';
      } else {
        style = 'light';
      }
    }
    const switchImagesList = [].slice.call(document.querySelectorAll('[data-app-' + style + '-img]'));
    switchImagesList.map(function (imageEl) {
      const setImage = imageEl.getAttribute('data-app-' + style + '-img');
      if (typeof assetsPath !== 'undefined') {
        imageEl.src = assetsPath + 'img/' + setImage;
      }
    });
  }

  // Inicializa o tema quando a página carrega
  $(document).ready(function() {
    // Atualiza apenas o ícone do tema salvo (não reaplicar o tema, pois já foi aplicado no head)
    const currentTheme = getCurrentTheme();
    updateThemeIcon(currentTheme);
    
    // Event listener para o botão de toggle
    $('.theme-toggle-btn').on('click', function(e) {
      e.preventDefault();
      toggleTheme();
    });
  });

  </script>

</body>
</html>
