<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require '../../class/configClass.php';
require '../../vendor/autoload.php';
Config::load('../../config/config.php');
include_once('../../conexao/conexao.php');
require '../../class/pagarVendaUsuarioClass.php';

// Função para salvar logs
function salvar_log($mensagem)
{
    $arquivo_log = '../../logs/upload_imagem.log';
    $data_hora = date('Y-m-d H:i:s');
    file_put_contents($arquivo_log, "[{$data_hora}] {$mensagem}\n", FILE_APPEND);
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Recebe dados do produto pai e dados da variação
    $produto_pai_id = isset($_POST['produto_pai_id']) ? $_POST['produto_pai_id'] : null;
    $tipo_variacao = isset($_POST['tipo_variacao']) ? trim($_POST['tipo_variacao']) : null; // Ex: Cor, Tamanho
    // O valor da variação pode vir como valor_cor ou valor_tamanho
    $valor_variacao = null;
    if ($tipo_variacao === 'cor' && isset($_POST['valor_cor'])) {
        $valor_variacao = trim($_POST['valor_cor']);
    } elseif ($tipo_variacao === 'tamanho' && isset($_POST['valor_tamanho'])) {
        $valor_variacao = trim($_POST['valor_tamanho']);
    }
    $sku_variacao = isset($_POST['sku']) ? trim($_POST['sku']) : null;
    $imagem_variacao = isset($_FILES['imagem']) ? $_FILES['imagem'] : null;
    $preco_variacao = isset($_POST['preco']) ? $_POST['preco'] : null;
    $estoque_variacao = isset($_POST['estoque']) ? $_POST['estoque'] : null;
    // ...outros campos necessários...

    if (!$produto_pai_id) {
        echo json_encode(['error' => 'ID do produto pai não informado']);
        exit;
    }

    // Buscar dados do produto principal
    $stmt_produto = $pdo->prepare("SELECT * FROM drophub_global.produtos WHERE id = :id LIMIT 1");
    $stmt_produto->execute([':id' => $produto_pai_id]);
    $produto_pai = $stmt_produto->fetch(PDO::FETCH_ASSOC);
    if (!$produto_pai) {
        echo json_encode(['error' => 'Produto pai não encontrado']);
        exit;
    }

    // Buscar atributos Mercado Livre
    $stmt_attr_ml = $pdo->prepare("SELECT * FROM drophub_global.produtos_atributos WHERE id_produto = :id_produto");
    $stmt_attr_ml->execute([':id_produto' => $produto_pai_id]);
    $atributos_ml = $stmt_attr_ml->fetchAll(PDO::FETCH_ASSOC);

    // Buscar atributos Shopee
    $stmt_attr_shopee = $pdo->prepare("SELECT * FROM drophub_global.produtos_atributos_shopee WHERE id_produto = :id_produto");
    $stmt_attr_shopee->execute([':id_produto' => $produto_pai_id]);
    $atributos_shopee = $stmt_attr_shopee->fetchAll(PDO::FETCH_ASSOC);

        // ... após buscar os atributos Shopee ...

    // Verificar se já existe uma variação com o mesmo SKU para o produto pai
    $stmt_check = $pdo->prepare("
        SELECT COUNT(*) 
        FROM drophub_global.produtos 
        WHERE produto_pai = :produto_pai AND sku = :sku
    ");
    $stmt_check->execute([
        ':produto_pai' => $produto_pai_id,
        ':sku' => $sku_variacao
    ]);
    $ja_existe = $stmt_check->fetchColumn();

    if ($ja_existe > 0) {
        exit;
    }

    // Gerar novo ID com prefixo
    $prefixo = '';
    if (preg_match('/^([A-Z]+_)/', $produto_pai_id, $matches)) {
        $prefixo = $matches[1];
    } else {
        echo json_encode(['error' => 'Prefixo do produto pai não identificado']);
        exit;
    }


    // Gerar novo ID com prefixo
    $prefixo = '';
    if (preg_match('/^([A-Z]+_)/', $produto_pai_id, $matches)) {
        $prefixo = $matches[1];
    } else {
        echo json_encode(['error' => 'Prefixo do produto pai não identificado']);
        exit;
    }

    // Buscar o maior ID existente com o mesmo prefixo
    $stmt_max_id = $pdo->prepare("SELECT id FROM drophub_global.produtos WHERE id LIKE :prefixo ORDER BY LENGTH(id) DESC, id DESC LIMIT 1");
    $stmt_max_id->execute([':prefixo' => $prefixo . '%']);
    $last_id = $stmt_max_id->fetchColumn();
    $next_num = 1;
    if ($last_id && preg_match('/^' . preg_quote($prefixo, '/') . '(\d+)$/', $last_id, $m)) {
        $next_num = intval($m[1]) + 1;
    }
    $novo_id = $prefixo . $next_num;

    // Exemplo de resposta para debug
    // Montar dados para o novo produto variação
    $dados_insert = $produto_pai;
    unset($dados_insert['id_ai']); // será autoincrementado
    $dados_insert['id'] = $novo_id;
    $dados_insert['produto_pai'] = $produto_pai_id;
    $dados_insert['is_filho'] = 1;
    // Montar título: nome do produto pai + tipo + valor (máx 60 chars)
    $titulo_base = isset($produto_pai['titulo']) ? trim($produto_pai['titulo']) : '';
    $sufixo = '';
    if ($tipo_variacao && $valor_variacao) {
        $sufixo = ' - ' . ucfirst($tipo_variacao) . ': ' . $valor_variacao;
    }
    $max_titulo = 60;
    $titulo_final = $titulo_base;
    if (mb_strlen($titulo_base . $sufixo) > $max_titulo) {
        $titulo_final = mb_substr($titulo_base, 0, $max_titulo - mb_strlen($sufixo));
    }
    $titulo_final .= $sufixo;
    $dados_insert['titulo'] = $titulo_final;
    $dados_insert['sku'] = $sku_variacao;
    $dados_insert['imagem'] = null;
    // Atualiza preço e estoque se enviados
    if ($preco_variacao !== null) {
        $dados_insert['preco_custo'] = $preco_variacao;
    }
    if ($estoque_variacao !== null) {
        $dados_insert['estoque'] = $estoque_variacao;
    }
    // Preencher variacao_cor/variacao_tamanho
    $tipo_variacao_lower = isset($tipo_variacao) ? mb_strtolower($tipo_variacao) : '';
    $valor_variacao_final = isset($valor_variacao) ? $valor_variacao : null;
    if ($tipo_variacao_lower === 'cor' || $tipo_variacao_lower === 'color') {
        $dados_insert['variacao_cor'] = $valor_variacao_final;
        $dados_insert['variacao_tamanho'] = null;
    } elseif ($tipo_variacao_lower === 'tamanho' || $tipo_variacao_lower === 'size') {
        $dados_insert['variacao_cor'] = null;
        $dados_insert['variacao_tamanho'] = $valor_variacao_final;
    } else {
        $dados_insert['variacao_cor'] = null;
        $dados_insert['variacao_tamanho'] = null;
    }

    // Montar query dinâmica
    $campos = array_keys($dados_insert);
    $placeholders = array_map(function ($c) {
        return ':' . $c;
    }, $campos);
    // Insert na tabela global
    $sql_insert_global = "INSERT INTO drophub_global.produtos (" . implode(",", $campos) . ") VALUES (" . implode(",", $placeholders) . ")";
    $stmt_insert_global = $pdo->prepare($sql_insert_global);
    $ok_global = $stmt_insert_global->execute($dados_insert);


    // Recuperar id_ai do novo produto (da global)
    $id_ai_var = $pdo->lastInsertId();

    // Inserir atributos Mercado Livre
    foreach ($atributos_ml as $attr) {
        $valor_atributo = $attr['valor_atributo'];
        $nome_attr_lower = mb_strtolower(trim($attr['nome_atributo']));
        // Se for atributo de cor, usar SEMPRE o valor da variação enviada
        if (($tipo_variacao_lower === 'cor' || $tipo_variacao_lower === 'color') && (strpos($nome_attr_lower, 'cor') !== false || strpos($nome_attr_lower, 'color') !== false)) {
            $valor_atributo = $valor_variacao_final;
        }
        // Se for atributo de tamanho, usar SEMPRE o valor da variação enviada
        if (($tipo_variacao_lower === 'tamanho' || $tipo_variacao_lower === 'size') && (strpos($nome_attr_lower, 'tamanho') !== false || strpos($nome_attr_lower, 'size') !== false)) {
            $valor_atributo = $valor_variacao_final;
        }
        // Insert na tabela global
        $query_attr_global = "INSERT INTO drophub_global.produtos_atributos (id_produto, nome_atributo, id_atributo, valor_atributo) VALUES (:id_produto, :nome_atributo, :id_atributo, :valor_atributo)";
        $stmt_attr_global = $pdo->prepare($query_attr_global);
        $stmt_attr_global->execute([
            ':id_produto' => $novo_id,
            ':nome_atributo' => $attr['nome_atributo'],
            ':id_atributo' => $attr['id_atributo'],
            ':valor_atributo' => $valor_atributo
        ]);

    }

    // Inserir atributos Shopee
    foreach ($atributos_shopee as $attr) {
        // Insert na tabela global
        $query_attr_sh_global = "INSERT INTO drophub_global.produtos_atributos_shopee (id_produto, attribute_id, attribute_name, attribute_value, value_id, original_value_name, value_unit) VALUES (:id_produto, :attribute_id, :attribute_name, :attribute_value, :value_id, :original_value_name, :value_unit)";
        $stmt_attr_sh_global = $pdo->prepare($query_attr_sh_global);
        $stmt_attr_sh_global->execute([
            ':id_produto' => $novo_id,
            ':attribute_id' => $attr['attribute_id'],
            ':attribute_name' => $attr['attribute_name'],
            ':attribute_value' => $attr['attribute_value'],
            ':value_id' => $attr['value_id'],
            ':original_value_name' => $attr['original_value_name'],
            ':value_unit' => $attr['value_unit']
        ]);
        
    }

    // Inserir imagem da variação (se enviada)
    if ($imagem_variacao && isset($imagem_variacao['tmp_name']) && $imagem_variacao['error'] === UPLOAD_ERR_OK) {
        $document_root = $_SERVER['DOCUMENT_ROOT'] ?? dirname(__DIR__, 3);
        $produtos_dir = rtrim($document_root, '/') . "/images/produtos_imagens/";
        $upload_dir = $produtos_dir . $novo_id . "/";
        if (!file_exists($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        $image_name = $novo_id . "_1.jpg";
        $dest_file = $upload_dir . $image_name;
        if (move_uploaded_file($imagem_variacao['tmp_name'], $dest_file)) {
            $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
            $dominio = $_SERVER['HTTP_HOST'] ?? '';
            $final_image_url = $protocol . '://' . $dominio . "/images/produtos_imagens/{$novo_id}/{$image_name}";
            $id_unico = uniqid('', true);
            // Alimenta a tabela produtos_imagens corretamente
            // Insert na tabela global
            $insertImg_global = "INSERT INTO drophub_global.produtos_imagens (id, produto_id, imagem_url, ordem) VALUES (:id, :produto_id, :imagem_url, :ordem)";
            $pdo->prepare($insertImg_global)->execute([
                ':id' => $id_unico,
                ':produto_id' => $novo_id,
                ':imagem_url' => $final_image_url,
                ':ordem' => 1
            ]);
           
        }
    }


    // Resposta de sucesso
    echo json_encode([
        'success' => true,
        'message' => "Variação ID {$novo_id} adicionada com sucesso!",
        'novo_id' => $novo_id,
        'id_ai' => $id_ai_var
    ]);
    exit;
}
